/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.placemark.gcp;

import com.bc.ceres.core.Assert;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GcpGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.ui.product.AbstractPlacemarkTableModel;

public class GcpTableModel
extends AbstractPlacemarkTableModel {
    public GcpTableModel(PlacemarkDescriptor placemarkDescriptor, Product product, Band[] selectedBands, TiePointGrid[] selectedGrids) {
        super(placemarkDescriptor, product, selectedBands, selectedGrids);
    }

    public String[] getStandardColumnNames() {
        return new String[]{"X", "Y", "Lon", "Lat", "Delta Lon", "Delta Lat", "Label"};
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex < this.getStandardColumnNames().length && columnIndex != 4 && columnIndex != 5;
    }

    protected Object getStandardColumnValueAt(int rowIndex, int columnIndex) {
        GeoPos expectedGeoPos;
        Assert.notNull((Object)this.getProduct());
        Placemark placemark = (Placemark)this.getPlacemarkDescriptor().getPlacemarkGroup(this.getProduct()).get(rowIndex);
        double x = Double.NaN;
        double y = Double.NaN;
        PixelPos pixelPos = placemark.getPixelPos();
        if (pixelPos != null) {
            x = pixelPos.x;
            y = pixelPos.y;
        }
        double lon = Double.NaN;
        double lat = Double.NaN;
        GeoPos geoPos = placemark.getGeoPos();
        if (geoPos != null) {
            lon = geoPos.lon;
            lat = geoPos.lat;
        }
        double dLon = Double.NaN;
        double dLat = Double.NaN;
        GeoCoding geoCoding = this.getProduct().getSceneGeoCoding();
        if (geoCoding instanceof GcpGeoCoding && pixelPos != null && (expectedGeoPos = geoCoding.getGeoPos(pixelPos, new GeoPos())) != null) {
            dLon = Math.abs(lon - expectedGeoPos.lon);
            dLat = Math.abs(lat - expectedGeoPos.lat);
        }
        switch (columnIndex) {
            case 0: {
                return x;
            }
            case 1: {
                return y;
            }
            case 2: {
                return lon;
            }
            case 3: {
                return lat;
            }
            case 4: {
                return dLon;
            }
            case 5: {
                return dLat;
            }
            case 6: {
                return placemark.getLabel();
            }
        }
        return "";
    }
}

