/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.nodes;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import javax.swing.Action;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.datamodel.quicklooks.Quicklook;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.CloseProductAction;
import org.esa.snap.rcp.nodes.PNGGroup;
import org.esa.snap.rcp.nodes.PNGroup;
import org.esa.snap.rcp.nodes.PNGroupBase;
import org.esa.snap.rcp.nodes.PNGroupNode;
import org.esa.snap.rcp.nodes.PNGroupingGroup;
import org.esa.snap.rcp.nodes.PNNode;
import org.esa.snap.rcp.nodes.PNNodeSupport;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.WeakListeners;

public class PNode
extends PNNode<Product>
implements PreferenceChangeListener {
    private final PContent group;

    public PNode(Product product) {
        this(product, new PContent());
    }

    private PNode(Product product, PContent group) {
        super(product, group);
        this.group = group;
        group.node = this;
        this.setDisplayName(product.getDisplayName());
        this.setShortDescription(product.getDescription());
        this.setIconBaseWithExtension("org/esa/snap/rcp/icons/RsProduct16.gif");
        Preferences preferences = SnapApp.getDefault().getPreferences();
        preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)preferences));
    }

    public Product getProduct() {
        return (Product)this.getProductNode();
    }

    @Override
    public UndoRedo getUndoRedo() {
        return SnapApp.getDefault().getUndoManager(this.getProduct());
    }

    public boolean canDestroy() {
        return false;
    }

    public void destroy() throws IOException {
        new CloseProductAction(Collections.singletonList(this.getProduct())).execute();
    }

    @Override
    public Action[] getActions(boolean context) {
        return PNNodeSupport.getContextActions(this.getProductNode());
    }

    public Action getPreferredAction() {
        return super.getPreferredAction();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        String key = evt.getKey();
        if ("group_by_node_type".equals(key)) {
            this.group.refresh();
        }
    }

    @Override
    public Node.PropertySet[] getPropertySets() {
        Sheet.Set set = new Sheet.Set();
        set.setDisplayName("Product Properties");
        set.put((Node.Property)new PropertySupport.ReadOnly<File>("fileLocation", File.class, "File", "File location"){

            public File getValue() {
                return PNode.this.getProduct().getFileLocation();
            }
        });
        set.put((Node.Property)new PropertySupport.ReadWrite<String>("productType", String.class, "Product Type", "The product type identifier"){

            public String getValue() {
                return PNode.this.getProduct().getProductType();
            }

            public void setValue(String newValue) throws IllegalArgumentException {
                String oldValue = PNode.this.getProduct().getProductType();
                PNNodeSupport.performUndoableProductNodeEdit("Edit Product Type", PNode.this.getProduct(), node -> node.setProductType(newValue), node -> node.setProductType(oldValue));
            }
        });
        set.put((Node.Property)new PropertySupport.ReadWrite<String>("startTime", String.class, "Sensing Start Time", "The product's sensing start time"){

            public String getValue() {
                ProductData.UTC startTime = PNode.this.getProduct().getStartTime();
                return startTime != null ? startTime.format() : "";
            }

            public void setValue(String s) throws IllegalArgumentException {
                ProductData.UTC oldValue = PNode.this.getProduct().getStartTime();
                try {
                    ProductData.UTC newValue = ProductData.UTC.parse((String)s);
                    PNNodeSupport.performUndoableProductNodeEdit("Edit Sensing Start Time", PNode.this.getProduct(), node -> node.setStartTime(newValue), node -> node.setStartTime(oldValue));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
        });
        set.put((Node.Property)new PropertySupport.ReadWrite<String>("endTime", String.class, "Sensing Stop Time", "The product's sensing stop time"){

            public String getValue() {
                ProductData.UTC endTime = PNode.this.getProduct().getEndTime();
                return endTime != null ? endTime.format() : "";
            }

            public void setValue(String s) throws IllegalArgumentException {
                Product product = PNode.this.getProduct();
                ProductData.UTC oldValue = product.getEndTime();
                try {
                    ProductData.UTC newValue = ProductData.UTC.parse((String)s);
                    PNNodeSupport.performUndoableProductNodeEdit("Edit Sensing Stop Time", product, node -> node.setEndTime(newValue), node -> node.setEndTime(oldValue));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
        });
        set.put((Node.Property)new PropertySupport.ReadWrite<String>("bandGrouping", String.class, "Band Grouping", "The product's band grouping"){

            public String getValue() {
                Product.AutoGrouping autoGrouping = PNode.this.getProduct().getAutoGrouping();
                if (autoGrouping == null) {
                    return "";
                }
                return autoGrouping.toString();
            }

            public void setValue(String s) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                Product.AutoGrouping oldValue = PNode.this.getProduct().getAutoGrouping();
                Product.AutoGrouping newValue = Product.AutoGrouping.parse((String)s);
                PNNodeSupport.performUndoableProductNodeEdit("Edit Band-Grouping", PNode.this.getProduct(), node -> node.setAutoGrouping(newValue), node -> node.setAutoGrouping(oldValue));
            }
        });
        this.includeAbstractedMetadata(set);
        return (Node.PropertySet[])Stream.concat(Stream.of(super.getPropertySets()), Stream.of(set)).toArray(Node.PropertySet[]::new);
    }

    private void includeAbstractedMetadata(Sheet.Set set) {
        MetadataElement absRoot;
        MetadataElement root = this.getProduct().getMetadataRoot();
        if (root != null && (absRoot = root.getElement("Abstracted_Metadata")) != null) {
            set.put((Node.Property)new PropertySupport.ReadOnly<String>("mission", String.class, "Mission", "Earth Observation Mission"){

                public String getValue() {
                    return absRoot.getAttributeString("mission");
                }
            });
            set.put((Node.Property)new PropertySupport.ReadOnly<String>("mode", String.class, "Acquisition Mode", "Sensor Acquisition Mode"){

                public String getValue() {
                    return absRoot.getAttributeString("ACQUISITION_MODE");
                }
            });
            set.put((Node.Property)new PropertySupport.ReadOnly<String>("pass", String.class, "Pass", "Orbital Pass"){

                public String getValue() {
                    return absRoot.getAttributeString("pass");
                }
            });
            set.put((Node.Property)new PropertySupport.ReadOnly<String>("track", String.class, "Track", "Relative Orbit"){

                public String getValue() {
                    return absRoot.getAttributeString("REL_ORBIT");
                }
            });
            set.put((Node.Property)new PropertySupport.ReadOnly<String>("orbit", String.class, "Orbit", "Absolute Orbit"){

                public String getValue() {
                    return absRoot.getAttributeString("ABS_ORBIT");
                }
            });
        }
    }

    private boolean isGroupByNodeType() {
        return SnapApp.getDefault().getPreferences().getBoolean("group_by_node_type", true);
    }

    static class PContent
    extends PNGroupBase<Object> {
        PNode node;

        PContent() {
        }

        protected boolean createKeys(List<Object> list) {
            Product product = this.node.getProduct();
            ProductNodeGroup metadataElementGroup = product.getMetadataRoot().getElementGroup();
            if (this.node.isGroupByNodeType()) {
                if (metadataElementGroup != null) {
                    list.add((Object)new PNGGroup.ME((ProductNodeGroup<MetadataElement>)metadataElementGroup));
                }
                if (product.getIndexCodingGroup().getNodeCount() > 0) {
                    list.add((Object)new PNGGroup.IC((ProductNodeGroup<IndexCoding>)product.getIndexCodingGroup()));
                }
                if (product.getFlagCodingGroup().getNodeCount() > 0) {
                    list.add((Object)new PNGGroup.FC((ProductNodeGroup<FlagCoding>)product.getFlagCodingGroup()));
                }
                if (product.getVectorDataGroup().getNodeCount() > 0) {
                    list.add((Object)new PNGGroup.VDN((ProductNodeGroup<VectorDataNode>)product.getVectorDataGroup()));
                }
                if (product.getTiePointGridGroup().getNodeCount() > 0) {
                    list.add((Object)new PNGroupingGroup.TPG((ProductNodeGroup<TiePointGrid>)product.getTiePointGridGroup()));
                }
                if (product.getQuicklookGroup().getNodeCount() > 0) {
                    list.add((Object)new PNGGroup.QL((ProductNodeGroup<Quicklook>)product.getQuicklookGroup()));
                }
                if (product.getBandGroup().getNodeCount() > 0) {
                    list.add((Object)new PNGroupingGroup.B((ProductNodeGroup<Band>)product.getBandGroup()));
                }
                if (product.getMaskGroup().getNodeCount() > 0) {
                    list.add((Object)new PNGGroup.M((ProductNodeGroup<Mask>)product.getMaskGroup()));
                }
            } else {
                if (metadataElementGroup != null) {
                    list.addAll(Arrays.asList(metadataElementGroup.toArray()));
                }
                list.addAll(Arrays.asList(product.getIndexCodingGroup().toArray()));
                list.addAll(Arrays.asList(product.getFlagCodingGroup().toArray()));
                list.addAll(Arrays.asList(product.getVectorDataGroup().toArray()));
                list.addAll(Arrays.asList(product.getTiePointGridGroup().toArray()));
                list.addAll(Arrays.asList(product.getQuicklookGroup().toArray()));
                list.addAll(Arrays.asList(product.getBandGroup().toArray()));
                list.addAll(Arrays.asList(product.getMaskGroup().toArray()));
            }
            return true;
        }

        protected Node createNodeForKey(Object key) {
            if (key instanceof ProductNode) {
                return PNNode.create((ProductNode)key);
            }
            return new PNGroupNode((PNGroup)((Object)key));
        }
    }
}

