/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.mask;

import com.bc.ceres.swing.TableLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.ui.ModalDialog;

class TransferMaskDialog
extends ModalDialog {
    private final Mask[] selectedMasks;
    private final Product sourceProduct;
    private final Product[] allProducts;
    private final Map<Product, ButtonModel> definitionMap;
    private final Map<Product, ButtonModel> dataMap;

    TransferMaskDialog(Window window, Product product, Product[] allProducts, Mask[] selectedMasks) {
        super(window, "Transfer Mask(s) to other product", 161, "transferMaskEditor");
        this.sourceProduct = product;
        this.allProducts = allProducts;
        this.selectedMasks = selectedMasks;
        this.definitionMap = new HashMap<Product, ButtonModel>();
        this.dataMap = new HashMap<Product, ButtonModel>();
        this.getJDialog().setResizable(true);
        this.setContent(this.createUI());
    }

    Product[] getMaskPixelTargets() {
        return TransferMaskDialog.getSelectedProducts(this.dataMap);
    }

    Product[] getMaskDefinitionTargets() {
        return TransferMaskDialog.getSelectedProducts(this.definitionMap);
    }

    private static Product[] getSelectedProducts(Map<Product, ButtonModel> buttonMap) {
        ArrayList<Product> selectedProducts = new ArrayList<Product>(buttonMap.size());
        for (Map.Entry<Product, ButtonModel> entry : buttonMap.entrySet()) {
            Product product = entry.getKey();
            ButtonModel buttonModel = entry.getValue();
            if (!buttonModel.isSelected()) continue;
            selectedProducts.add(product);
        }
        return selectedProducts.toArray(new Product[selectedProducts.size()]);
    }

    private JComponent createUI() {
        TableLayout layout = new TableLayout(3);
        layout.setTableFill(TableLayout.Fill.BOTH);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setTableWeightY(Double.valueOf(0.0));
        layout.setTablePadding(5, 5);
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.add(new JLabel("<html><u>Target product</u></html>"));
        panel.add(new JLabel("<html><u>Definition</u></html>"));
        panel.add(new JLabel("<html><u>Pixels</u></html>"));
        int row = 1;
        for (Product targetProduct : this.allProducts) {
            if (targetProduct == this.sourceProduct) continue;
            panel.add(new JLabel(targetProduct.getDisplayName()));
            boolean canCopyDef = TransferMaskDialog.canCopyDefinition(this.selectedMasks, targetProduct);
            JCheckBox defCheckBox = TransferMaskDialog.createCeckbox(panel, canCopyDef);
            if (canCopyDef) {
                this.definitionMap.put(targetProduct, defCheckBox.getModel());
            }
            boolean canCopyData = TransferMaskDialog.intersectsWith(this.sourceProduct, targetProduct);
            JCheckBox dataCheckBox = TransferMaskDialog.createCeckbox(panel, canCopyData);
            if (canCopyData) {
                this.dataMap.put(targetProduct, dataCheckBox.getModel());
            }
            if (canCopyData && canCopyDef) {
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(dataCheckBox);
                buttonGroup.add(defCheckBox);
            }
            ++row;
        }
        layout.setCellColspan(row, 0, Integer.valueOf(3));
        panel.add(this.createHelpPanel());
        return panel;
    }

    private JComponent createHelpPanel() {
        JEditorPane helpPane = new JEditorPane("text/html", null);
        helpPane.setEditable(false);
        helpPane.setPreferredSize(new Dimension(400, 120));
        helpPane.setText("<html><body>Copying the <b>definition</b> of a mask means the mathematical expression is evaluated in the target product. This is only possible,  if the bands which are used in this expression are present in the target product.<br/> Copying the <b>pixel</b> means the data of the mask is transferred to the target product. This is only possible when both product overlap spatially.</body></html>");
        JScrollPane helpPanelScrollPane = new JScrollPane(helpPane);
        helpPanelScrollPane.setBorder(BorderFactory.createTitledBorder("Description"));
        return helpPanelScrollPane;
    }

    private static JCheckBox createCeckbox(JPanel panel, boolean enabled) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setHorizontalAlignment(0);
        checkBox.setEnabled(enabled);
        panel.add(checkBox);
        return checkBox;
    }

    private static boolean canCopyDefinition(Mask[] masks, Product targetProduct) {
        boolean canCopyDef = true;
        for (Mask mask : masks) {
            boolean canTransferMask = mask.getImageType().canTransferMask(mask, targetProduct);
            canCopyDef = canCopyDef && canTransferMask;
        }
        return canCopyDef;
    }

    private static boolean intersectsWith(Product sourceProduct, Product targetProduct) {
        GeoCoding srcGC = sourceProduct.getSceneGeoCoding();
        GeoCoding targetGC = targetProduct.getSceneGeoCoding();
        if (srcGC != null && srcGC.canGetGeoPos() && targetGC != null && targetGC.canGetGeoPos()) {
            GeneralPath[] sourcePath = ProductUtils.createGeoBoundaryPaths((Product)sourceProduct);
            GeneralPath[] targetPath = ProductUtils.createGeoBoundaryPaths((Product)targetProduct);
            for (GeneralPath spath : sourcePath) {
                Rectangle bounds = spath.getBounds();
                for (GeneralPath tPath : targetPath) {
                    if (!tPath.getBounds().intersects(bounds)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

