/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.mask;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.ui.ModalDialog;

class RangeEditorDialog
extends ModalDialog {
    private String code;
    private PropertyContainer container;
    private DefaultComboBoxModel rasterModel;
    private Model model;

    public static void main(String[] args) {
        String[] rasterNames = new String[]{"raster_1", "raster_2", "raster_3"};
        final RangeEditorDialog editorDialog = new RangeEditorDialog(null, new Model(rasterNames));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                editorDialog.show();
            }
        });
    }

    RangeEditorDialog(Window window, Model model) {
        super(window, "New Range Mask", 161, "rangeEditor");
        this.model = model;
        this.container = PropertyContainer.createObjectBacked((Object)this.model);
        this.getJDialog().setResizable(false);
        this.rasterModel = new DefaultComboBoxModel<String>(this.model.rasterNames);
        this.setContent(this.createUI());
    }

    Model getModel() {
        return this.model;
    }

    private JComponent createUI() {
        TableLayout layout = new TableLayout(5);
        layout.setTableFill(TableLayout.Fill.BOTH);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setTableWeightY(Double.valueOf(0.0));
        layout.setTablePadding(3, 3);
        layout.setColumnPadding(1, new Insets(3, 6, 3, 6));
        layout.setColumnPadding(3, new Insets(3, 6, 3, 6));
        layout.setColumnWeightX(1, Double.valueOf(0.0));
        layout.setColumnWeightX(3, Double.valueOf(0.0));
        JPanel panel = new JPanel((LayoutManager)layout);
        panel.add((Component)new JLabel("Min value:"), TableLayout.cell((int)0, (int)0));
        panel.add((Component)new JLabel("Raster:"), TableLayout.cell((int)0, (int)2));
        panel.add((Component)new JLabel("Max value:"), TableLayout.cell((int)0, (int)4));
        DoubleFormatter formatter = new DoubleFormatter("###0.0###");
        JFormattedTextField minValueField = new JFormattedTextField(formatter);
        JFormattedTextField maxValueField = new JFormattedTextField(formatter);
        JComboBox rasterNameComboBox = new JComboBox(this.rasterModel);
        panel.add(minValueField);
        panel.add(new JLabel("<html><b>&lt;=</b>"));
        panel.add(rasterNameComboBox);
        panel.add(new JLabel("<html><b>&lt;=</b>"));
        panel.add(maxValueField);
        BindingContext context = new BindingContext((PropertySet)this.container);
        context.bind("rasterName", rasterNameComboBox);
        context.bind("minValue", minValueField);
        context.bind("maxValue", maxValueField);
        return panel;
    }

    protected boolean verifyUserInput() {
        boolean nameEmpty;
        boolean minGreaterMax;
        String errorMsg = null;
        boolean bl = minGreaterMax = this.model.getMaxValue() <= this.model.getMinValue();
        if (minGreaterMax) {
            errorMsg = "The specified maximum is less or equal to the minimum.";
        }
        if (nameEmpty = StringUtils.isNullOrEmpty((String)this.model.getRasterName())) {
            errorMsg = "No raster selected.";
        }
        if (errorMsg != null) {
            JOptionPane.showMessageDialog(this.getJDialog(), errorMsg, "New Range Mask", 0);
            return false;
        }
        return true;
    }

    private static class DoubleFormatter
    extends JFormattedTextField.AbstractFormatter {
        private final DecimalFormat format;

        DoubleFormatter(String pattern) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.ENGLISH);
            this.format = new DecimalFormat(pattern, decimalFormatSymbols);
            this.format.setParseIntegerOnly(false);
            this.format.setParseBigDecimal(false);
            this.format.setDecimalSeparatorAlwaysShown(true);
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            return this.format.parse(text).doubleValue();
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value == null) {
                return "";
            }
            return this.format.format(value);
        }
    }

    static class Model {
        private String rasterName;
        private double minValue;
        private double maxValue;
        private final String[] rasterNames;

        Model(String[] rasterNames) {
            this.rasterNames = rasterNames;
        }

        public void setRasterName(String rasterName) {
            this.rasterName = rasterName;
        }

        public String getRasterName() {
            return this.rasterName;
        }

        public double getMinValue() {
            return this.minValue;
        }

        public void setMinValue(double minValue) {
            this.minValue = minValue;
        }

        public double getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(double maxValue) {
            this.maxValue = maxValue;
        }

        public String[] getRasterNames() {
            return this.rasterNames;
        }
    }
}

