/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.mask;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.mask.MaskTableModel;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.color.ColorTableCellEditor;
import org.esa.snap.ui.color.ColorTableCellRenderer;

class MaskTable
extends JTable {
    private final VisibilityHR visibilityHR = new VisibilityHR();

    public MaskTable(boolean maskManagmentMode) {
        super(new MaskTableModel(maskManagmentMode));
        this.setName("maskTable");
        this.setAutoCreateColumnsFromModel(true);
        this.setPreferredScrollableViewportSize(new Dimension(200, 150));
        this.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorTableCellRenderer());
        this.setDefaultEditor(Color.class, (TableCellEditor)new ColorTableCellEditor());
        this.setSelectionMode(2);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(true);
        this.setAutoResizeMode(0);
        ToolTipMIL toolTipSetter = new ToolTipMIL();
        this.addMouseListener(toolTipSetter);
        this.addMouseMotionListener(toolTipSetter);
        this.setRowHeight(this.getRowHeight() + 4);
        this.reconfigureColumnModel();
    }

    @Override
    public MaskTableModel getModel() {
        return (MaskTableModel)super.getModel();
    }

    Product getProduct() {
        return this.getModel().getProduct();
    }

    void setProduct(Product product, RasterDataNode visibleBand) {
        this.saveColumnWidths();
        this.getModel().setProduct(product, visibleBand);
        this.reconfigureColumnModel();
    }

    Mask getSelectedMask() {
        int selectedRow = this.getSelectedRow();
        return selectedRow >= 0 ? this.getMask(selectedRow) : null;
    }

    Mask[] getSelectedMasks() {
        int[] rows = this.getSelectedRows();
        Mask[] masks = new Mask[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            masks[i] = this.getMask(row);
        }
        return masks;
    }

    void clear() {
        this.getModel().clear();
    }

    boolean isInManagmentMode() {
        return this.getModel().isInManagmentMode();
    }

    Mask getMask(int rowIndex) {
        return this.getModel().getMask(rowIndex);
    }

    void addMask(Mask mask) {
        this.getModel().addMask(mask);
        int rowIndex = this.getModel().getMaskIndex(mask.getName());
        this.getSelectionModel().addSelectionInterval(rowIndex, rowIndex);
        this.scrollRectToVisible(this.getCellRect(rowIndex, 0, true));
    }

    public void insertMask(Mask mask, int index) {
        this.getModel().addMask(mask, index);
    }

    void removeMask(Mask mask) {
        this.getModel().removeMask(mask);
    }

    private void saveColumnWidths() {
        if (this.getRowCount() > 0) {
            MaskTableModel maskTableModel = this.getModel();
            for (int i = 0; i < maskTableModel.getColumnCount(); ++i) {
                maskTableModel.setPreferredColumnWidth(i, this.columnModel.getColumn(i).getPreferredWidth());
            }
        }
    }

    private void reconfigureColumnModel() {
        this.createDefaultColumnsFromModel();
        TableColumnModel columnModel = this.getColumnModel();
        MaskTableModel maskTableModel = this.getModel();
        int vci = maskTableModel.getVisibilityColumnIndex();
        if (vci >= 0) {
            columnModel.getColumn(vci).setHeaderRenderer(this.visibilityHR);
        }
        for (int i = 0; i < maskTableModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setPreferredWidth(maskTableModel.getPreferredColumnWidth(i));
        }
    }

    private static class VisibilityHR
    extends JLabel
    implements TableCellRenderer {
        VisibilityHR() {
            ImageIcon icon = UIUtils.loadImageIcon((String)"icons/EyeIcon10.gif");
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setText(null);
            this.setIcon(icon);
            this.setHorizontalAlignment(0);
            this.setPreferredSize(this.getPreferredSize());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    private class ToolTipMIL
    extends MouseInputAdapter {
        private int currentRowIndex = -1;

        ToolTipMIL() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.currentRowIndex = -1;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int rowIndex = MaskTable.this.rowAtPoint(e.getPoint());
            if (rowIndex != this.currentRowIndex) {
                this.currentRowIndex = rowIndex;
                if (this.currentRowIndex >= 0 && this.currentRowIndex < MaskTable.this.getRowCount()) {
                    MaskTable.this.setToolTipText(this.getToolTipText(rowIndex));
                }
            }
        }

        private String getToolTipText(int rowIndex) {
            Mask mask = MaskTable.this.getMask(rowIndex);
            return mask.getDescription();
        }
    }
}

