/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.mask;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.grender.Viewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.dataio.dimap.spi.DimapPersistable;
import org.esa.snap.core.dataio.dimap.spi.DimapPersistence;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.impl.Tokenizer;
import org.esa.snap.core.util.DefaultPropertyMap;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.vector.CreateVectorDataNodeAction;
import org.esa.snap.rcp.mask.MaskAction;
import org.esa.snap.rcp.mask.MaskForm;
import org.esa.snap.rcp.mask.MaskIOAction;
import org.esa.snap.rcp.mask.RangeEditorDialog;
import org.esa.snap.rcp.mask.TransferMaskDialog;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.util.MultiSizeIssue;
import org.esa.snap.rcp.util.internal.RasterDataNodeDeleter;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.product.ProductExpressionPane;
import org.esa.snap.ui.product.ProductSceneView;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openide.windows.TopComponent;

class MaskFormActions {
    private final MaskAction[] maskActions;

    MaskFormActions(ToolTopComponent maskTopComponent, MaskForm maskForm) {
        this.maskActions = new MaskAction[]{new NewBandMathsAction(maskForm), new NewRangeAction(maskForm), new NewVectorDataNodeAction(maskForm), new NullAction(maskForm), new NewUnionAction(maskForm), new NewIntersectionAction(maskForm), new NewDifferenceAction(maskForm), new NewInvDifferenceAction(maskForm), new NewComplementAction(maskForm), new NullAction(maskForm), new CopyAction(maskForm), new EditAction(maskForm), new RemoveAction(maskForm), new TransferAction(maskForm), new ImportAction(maskTopComponent, maskForm), new ExportAction(maskTopComponent, maskForm), new ZoomToVectorMaskAction(maskTopComponent, maskForm), new NullAction(maskForm)};
    }

    private MaskAction getMaskAction(Class<?> type) {
        for (MaskAction maskAction : this.maskActions) {
            if (!type.getName().equals(maskAction.getValue("ActionCommandKey"))) continue;
            return maskAction;
        }
        return null;
    }

    public MaskAction[] getAllActions() {
        return (MaskAction[])this.maskActions.clone();
    }

    public MaskAction getNewBandMathAction() {
        return this.getMaskAction(NewBandMathsAction.class);
    }

    public MaskAction getNewRangeAction() {
        return this.getMaskAction(NewRangeAction.class);
    }

    public MaskAction getNewIntersectionAction() {
        return this.getMaskAction(NewIntersectionAction.class);
    }

    public MaskAction getNewSubtractionAction() {
        return this.getMaskAction(NewDifferenceAction.class);
    }

    public MaskAction getNewUnionAction() {
        return this.getMaskAction(NewUnionAction.class);
    }

    public MaskAction getNewInversionAction() {
        return this.getMaskAction(NewComplementAction.class);
    }

    public MaskAction getCopyAction() {
        return this.getMaskAction(CopyAction.class);
    }

    public MaskAction getEditAction() {
        return this.getMaskAction(EditAction.class);
    }

    public MaskAction getExportAction() {
        return this.getMaskAction(ExportAction.class);
    }

    public MaskAction getImportAction() {
        return this.getMaskAction(ImportAction.class);
    }

    public MaskAction getRemoveAction() {
        return this.getMaskAction(RemoveAction.class);
    }

    public MaskAction getNullAction() {
        return this.getMaskAction(NullAction.class);
    }

    static Window getWindow(ActionEvent e) {
        Object source = e.getSource();
        Window window = null;
        if (source instanceof Component) {
            Component component = (Component)source;
            window = SwingUtilities.getWindowAncestor(component);
        }
        return window;
    }

    private static class ZoomToVectorMaskAction
    extends MaskAction {
        private final ToolTopComponent topComponent;

        private ZoomToVectorMaskAction(ToolTopComponent topComponent, MaskForm maskForm) {
            super(maskForm, "icons/ZoomTo24.gif", "zoomToButton", "Zooms to the selected mask.");
            this.topComponent = topComponent;
        }

        @Override
        void updateState() {
            this.setEnabled(this.getMaskForm().getSelectedRowCount() == 1 && this.topComponent.getSelectedProductSceneView() != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Mask mask = this.getMaskForm().getSelectedMask();
            Mask.ImageType imageType = mask.getImageType();
            ProductSceneView productSceneView = this.topComponent.getSelectedProductSceneView();
            if (productSceneView != null) {
                Rectangle2D modelBounds = imageType == Mask.VectorDataType.INSTANCE ? ZoomToVectorMaskAction.handleVectorMask(mask) : this.handleImageMask(mask, productSceneView.getBaseImageLayer().getImageToModelTransform());
                if (modelBounds != null) {
                    Viewport viewport = productSceneView.getViewport();
                    AffineTransform m2vTransform = viewport.getModelToViewTransform();
                    AffineTransform v2mTransform = viewport.getViewToModelTransform();
                    Rectangle2D viewBounds = m2vTransform.createTransformedShape(modelBounds).getBounds2D();
                    viewBounds.setFrameFromDiagonal(viewBounds.getMinX() - 10.0, viewBounds.getMinY() - 10.0, viewBounds.getMaxX() + 10.0, viewBounds.getMaxY() + 10.0);
                    Shape transformedModelBounds = v2mTransform.createTransformedShape(viewBounds);
                    viewport.zoom(transformedModelBounds.getBounds2D());
                } else {
                    Dialogs.showMessage("Zoom to Mask", "The selected mask is empty.", 1, null);
                }
            }
        }

        private static Rectangle2D handleVectorMask(Mask mask) {
            VectorDataNode vectorData = Mask.VectorDataType.getVectorData((Mask)mask);
            ReferencedEnvelope envelope = vectorData.getEnvelope();
            if (!envelope.isEmpty()) {
                return new Rectangle2D.Double(envelope.getMinX(), envelope.getMinY(), envelope.getWidth(), envelope.getHeight());
            }
            return null;
        }

        private Rectangle2D handleImageMask(Mask mask, AffineTransform i2m) {
            RenderedImage image = mask.getSourceImage().getImage(0);
            int minTileX = image.getMinTileX();
            int minTileY = image.getMinTileY();
            int numXTiles = image.getNumXTiles();
            int numYTiles = image.getNumYTiles();
            int width = image.getWidth();
            int height = image.getHeight();
            int minX = width;
            int maxX = 0;
            int minY = height;
            int maxY = 0;
            for (int tileX = minTileX; tileX < minTileX + numXTiles; ++tileX) {
                for (int tileY = minTileY; tileY < minTileY + numYTiles; ++tileY) {
                    Raster data = image.getTile(tileX, tileY);
                    for (int x = data.getMinX(); x < data.getMinX() + data.getWidth(); ++x) {
                        for (int y = data.getMinY(); y < data.getMinY() + data.getHeight(); ++y) {
                            if (data.getSample(x, y, 0) == 0) continue;
                            minX = Math.min(x, minX);
                            maxX = Math.max(x, maxX);
                            minY = Math.min(y, minY);
                            maxY = Math.max(y, maxY);
                        }
                    }
                }
            }
            Rectangle rect = new Rectangle(minX, minY, maxX - minX + 1, maxY - minY + 1);
            if (rect.isEmpty()) {
                return null;
            }
            return i2m.createTransformedShape(rect).getBounds2D();
        }
    }

    private static class TransferAction
    extends MaskAction {
        private TransferAction(MaskForm maskForm) {
            super(maskForm, "icons/MultiAssignProducts24.gif", "transferButton", "Transfer the selected mask(s) to other products.");
        }

        @Override
        void updateState() {
            this.setEnabled(this.getMaskForm().isInManagementMode() && this.getMaskForm().getSelectedRowCount() > 0 && SnapApp.getDefault().getProductManager().getProductCount() > 1);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window window = MaskFormActions.getWindow(e);
            Product sourcProduct = this.getMaskForm().getProduct();
            Mask[] selectedMasks = this.getMaskForm().getSelectedMasks();
            Product[] allProducts = SnapApp.getDefault().getProductManager().getProducts();
            TransferMaskDialog dialog = new TransferMaskDialog(window, sourcProduct, allProducts, selectedMasks);
            if (dialog.show() == 1) {
                Product[] maskPixelTargetProducts = dialog.getMaskPixelTargets();
                TransferAction.copyMaskPixel(selectedMasks, sourcProduct, maskPixelTargetProducts);
                Product[] maskDefinitionTargetProducts = dialog.getMaskDefinitionTargets();
                TransferAction.copyMaskDefinition(selectedMasks, maskDefinitionTargetProducts);
            }
        }

        private static void copyMaskDefinition(Mask[] selectedMasks, Product[] maskPixelTargetProducts) {
            for (Product targetProduct : maskPixelTargetProducts) {
                for (Mask selectedMask : selectedMasks) {
                    Mask.ImageType imageType = selectedMask.getImageType();
                    if (!imageType.canTransferMask(selectedMask, targetProduct)) continue;
                    imageType.transferMask(selectedMask, targetProduct);
                }
            }
        }

        private static void copyMaskPixel(Mask[] selectedMasks, Product sourceProduct, Product[] maskPixelTargetProducts) {
            if (MultiSizeIssue.isMultiSize(sourceProduct)) {
                Product resampledProduct = MultiSizeIssue.maybeResample(sourceProduct);
                if (resampledProduct != null) {
                    sourceProduct = resampledProduct;
                    for (int i = 0; i < selectedMasks.length; ++i) {
                        Mask selectedMask = selectedMasks[i];
                        selectedMasks[i] = (Mask)sourceProduct.getMaskGroup().get(selectedMask.getName());
                    }
                } else {
                    return;
                }
            }
            for (Product targetProduct : maskPixelTargetProducts) {
                if (sourceProduct.isCompatibleProduct(targetProduct, 0.001f)) {
                    TransferAction.copyBandData(selectedMasks, targetProduct);
                    continue;
                }
                TransferAction.reprojectBandData(selectedMasks, sourceProduct, targetProduct);
            }
        }

        private static void copyBandData(Mask[] selectedMasks, Product targetProduct) {
            for (Mask mask : selectedMasks) {
                Band band = TransferAction.createBandCopy(targetProduct, mask);
                band.setSourceImage(mask.getSourceImage());
            }
        }

        private static void reprojectBandData(Mask[] selectedMasks, Product sourceProduct, Product targetProduct) {
            Map projParameters = Collections.emptyMap();
            HashMap<String, Product> projProducts = new HashMap<String, Product>();
            projProducts.put("source", sourceProduct);
            projProducts.put("collocateWith", targetProduct);
            Product reprojectedProduct = GPF.createProduct((String)"Reproject", projParameters, projProducts);
            for (Mask mask : selectedMasks) {
                Band band = TransferAction.createBandCopy(targetProduct, mask);
                MultiLevelImage image = ((Mask)reprojectedProduct.getMaskGroup().get(mask.getName())).getSourceImage();
                band.setSourceImage(image);
            }
        }

        private static Band createBandCopy(Product targetProduct, Mask mask) {
            String bandName = ProductUtils.getAvailableNodeName((String)("mask_" + mask.getName()), (ProductNodeGroup)targetProduct.getBandGroup());
            String maskName = ProductUtils.getAvailableNodeName((String)mask.getName(), (ProductNodeGroup)targetProduct.getMaskGroup());
            int dataType = mask.getDataType();
            Band band = targetProduct.addBand(bandName, dataType);
            String description = mask.getDescription() + " (from " + mask.getProduct().getDisplayName() + ")";
            targetProduct.addMask(maskName, bandName, description, mask.getImageColor(), mask.getImageTransparency());
            return band;
        }
    }

    private static abstract class BandMathsAction
    extends MaskAction {
        BandMathsAction(MaskForm maskForm, String iconPath, String buttonName, String description) {
            super(maskForm, iconPath, buttonName, description);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String code = this.getCode(e);
            if (code != null) {
                this.addBandMathMask(code);
            }
        }

        abstract String getCode(ActionEvent var1);

        String createCodeFromSelection(String op) {
            return this.createCodeFromSelection(op, 0);
        }

        String createCodeFromSelection(String op, int selectionOffset) {
            return this.createCodeFromSelection(op, this.getMaskForm().getSelectedMasks(), selectionOffset);
        }

        String createCodeFromSelection(String op, Mask[] selectedMasks, int selectionOffset) {
            StringBuilder code = new StringBuilder();
            for (int i = selectionOffset; i < selectedMasks.length; ++i) {
                Mask mask = selectedMasks[i];
                if (code.length() > 0) {
                    code.append(" ");
                    code.append(op);
                    code.append(" ");
                }
                code.append(BandArithmetic.createExternalName((String)mask.getName()));
            }
            return code.toString();
        }

        void addBandMathMask(String code) {
            RasterDataNode[] refRasters;
            Product product = this.getMaskForm().getProduct();
            try {
                refRasters = BandArithmetic.getRefRasters((String)code, (Product[])new Product[]{product});
            }
            catch (ParseException e) {
                Dialogs.showError("Invalid expression '" + code + "':\n" + e.getMessage());
                return;
            }
            Dimension expectedSize = this.getMaskForm().getTargetMaskSize();
            if (expectedSize != null && !ProductUtils.areRastersEqualInSize((int)expectedSize.width, (int)expectedSize.height, (RasterDataNode[])refRasters)) {
                String message = String.format("Referenced rasters must all be the same size (%d x %d pixels).", expectedSize.width, expectedSize.height);
                Dialogs.showError(message);
                return;
            }
            Mask mask = this.createNewMask((Mask.ImageType)Mask.BandMathsType.INSTANCE);
            PropertyContainer imageConfig = mask.getImageConfig();
            String propertyNameExpression = "expression";
            imageConfig.setValue("expression", (Object)code);
            imageConfig.addPropertyChangeListener("expression", evt -> {
                if (evt.getOldValue().equals(mask.getDescription())) {
                    mask.setDescription((String)evt.getNewValue());
                }
            });
            mask.setDescription(code);
            this.getMaskForm().addMask(mask);
            RasterDataNode refRaster = this.getMaskForm().getRaster();
            if (refRaster != null) {
                ProductUtils.copyImageGeometry((RasterDataNode)refRaster, (RasterDataNode)mask, (boolean)false);
            }
        }
    }

    private static class CopyAction
    extends MaskAction {
        private CopyAction(MaskForm maskForm) {
            super(maskForm, "icons/Copy24.gif", "copyButton", "Copy the selected mask.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Property[] models;
            Mask selectedMask = this.getMaskForm().getSelectedMask();
            Mask mask = this.createNewMask(selectedMask.getImageType());
            mask.setName("Copy_of_" + selectedMask.getName());
            mask.setDescription(selectedMask.getDescription());
            PropertyContainer selectedConfig = selectedMask.getImageConfig();
            for (Property model : models = selectedConfig.getProperties()) {
                mask.getImageConfig().setValue(model.getDescriptor().getName(), model.getValue());
            }
            this.getMaskForm().addMask(mask);
        }

        @Override
        void updateState() {
            this.setEnabled(this.getMaskForm().isInManagementMode() && this.getMaskForm().getSelectedRowCount() == 1);
        }
    }

    private static class EditAction
    extends MaskAction {
        private EditAction(MaskForm maskForm) {
            super(maskForm, "icons/Edit24.gif", "editButton", "Edit the selected mask.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Window window = MaskFormActions.getWindow(e);
            Mask selectedMask = this.getMaskForm().getSelectedMask();
            PropertyContainer selectedMaskConfig = selectedMask.getImageConfig();
            Mask.ImageType type = selectedMask.getImageType();
            if (type == Mask.BandMathsType.INSTANCE) {
                Product product = this.getMaskForm().getProduct();
                ProductExpressionPane expressionPane = ProductExpressionPane.createBooleanExpressionPane((Product[])new Product[]{product}, (Product)product, null);
                expressionPane.setEmptyExpressionAllowed(false);
                expressionPane.setCode((String)selectedMaskConfig.getValue("expression"));
                if (expressionPane.showModalDialog(window, "Edit Band Maths Mask") == 1) {
                    String code = expressionPane.getCode();
                    selectedMaskConfig.setValue("expression", (Object)code);
                    selectedMask.setDescription(code);
                }
            } else if (type == Mask.RangeType.INSTANCE) {
                String[] namesOfRastersOfSameSize = this.collectNamesOfRastersOfSameSize();
                RangeEditorDialog.Model model = new RangeEditorDialog.Model(namesOfRastersOfSameSize);
                model.setMinValue((Double)selectedMaskConfig.getValue("minimum"));
                model.setMaxValue((Double)selectedMaskConfig.getValue("maximum"));
                model.setRasterName((String)selectedMaskConfig.getValue("rasterName"));
                RangeEditorDialog rangeEditorDialog = new RangeEditorDialog(window, model);
                if (rangeEditorDialog.show() == 1) {
                    String description = String.format("%s <= %s <= %s", model.getMinValue(), model.getRasterName(), model.getMaxValue());
                    selectedMask.setDescription(description);
                    selectedMaskConfig.setValue("minimum", (Object)model.getMinValue());
                    selectedMaskConfig.setValue("maximum", (Object)model.getMaxValue());
                    selectedMaskConfig.setValue("rasterName", (Object)model.getRasterName());
                }
            } else if (type == Mask.VectorDataType.INSTANCE) {
                JOptionPane.showMessageDialog(window, "Use the geometry tools to add new points, lines or polygons.\nYou can then use the select tool to select and modify the shape\nand position of the geometries.", "Edit Geometry Mask", 1);
            }
        }

        @Override
        void updateState() {
            this.setEnabled(this.getMaskForm().isInManagementMode() && this.getMaskForm().getSelectedRowCount() == 1);
        }
    }

    private static class ExportAction
    extends MaskIOAction {
        private static final String ACTION_NAME = "Export mask definition(s) to XML file.";
        private final TopComponent maskTopComponent;

        private ExportAction(TopComponent maskTopComponent, MaskForm maskForm) {
            super(maskTopComponent, maskForm, "icons/Export24.gif", "exportButton", ACTION_NAME);
            this.maskTopComponent = maskTopComponent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.exportSelectedMasks();
        }

        @Override
        void updateState() {
            this.setEnabled(this.getMaskForm().isInManagementMode() && this.getMaskForm().getSelectedRowCount() > 0);
        }

        private void exportSelectedMasks() {
            boolean allExportsFailed;
            Mask[] masks = this.getMaskForm().getSelectedMasks();
            if (masks.length == 0) {
                return;
            }
            Document document = new Document(new Element("Masks"));
            boolean[] masksExported = this.addContent(masks, document);
            boolean dialogApproved = false;
            if (ExportAction.hasAtLeastOneMaskExported(masksExported)) {
                File file;
                SnapFileChooser fileChooser = new SnapFileChooser();
                fileChooser.setDialogTitle(ACTION_NAME);
                SnapFileFilter fileFilter = new SnapFileFilter("XML", ".xml", "XML files (*.xml)");
                fileChooser.setFileFilter((FileFilter)fileFilter);
                File targetDirectory = this.getDirectory();
                fileChooser.setCurrentDirectory(targetDirectory);
                fileChooser.setSelectedFile(new File(targetDirectory, masks[0].getName()));
                int result = fileChooser.showSaveDialog(SwingUtilities.getWindowAncestor((Component)this.maskTopComponent));
                boolean bl = dialogApproved = result == 0;
                if (dialogApproved && (file = fileChooser.getSelectedFile()) != null && Boolean.TRUE.equals(Dialogs.requestOverwriteDecision(ACTION_NAME, file))) {
                    this.setDirectory(file.getAbsoluteFile().getParentFile());
                    file = FileUtils.ensureExtension((File)file, (String)".xml");
                    this.writeXml(file, document);
                }
            }
            boolean bl = allExportsFailed = ExportAction.countFailedMasks(masksExported) == masksExported.length;
            if (dialogApproved || allExportsFailed) {
                this.showUserFeedback(masks, masksExported);
            }
        }

        private void showUserFeedback(Mask[] masks, boolean[] masksExported) {
            Mask mask;
            int i;
            int maskIndex;
            StringBuilder stringBuilder = new StringBuilder();
            if (ExportAction.countExportedMasks(masksExported) > 0) {
                stringBuilder.append("Successfully exported mask");
                if (ExportAction.countExportedMasks(masksExported) > 1) {
                    stringBuilder.append("s");
                }
                stringBuilder.append(" ");
                maskIndex = 0;
                for (i = 0; i < masks.length; ++i) {
                    mask = masks[i];
                    if (!masksExported[i]) continue;
                    ExportAction.addMaskName(stringBuilder, maskIndex++, mask.getName(), ExportAction.countExportedMasks(masksExported));
                }
                stringBuilder.append(".");
            }
            if (ExportAction.countFailedMasks(masksExported) > 0) {
                stringBuilder.append("\n");
                stringBuilder.append("Unable to export mask");
                if (ExportAction.countFailedMasks(masksExported) > 1) {
                    stringBuilder.append("s");
                }
                stringBuilder.append(" ");
                maskIndex = 0;
                for (i = 0; i < masks.length; ++i) {
                    mask = masks[i];
                    if (masksExported[i]) continue;
                    ExportAction.addMaskName(stringBuilder, maskIndex++, mask.getName(), ExportAction.countFailedMasks(masksExported));
                }
                stringBuilder.append(" to XML.");
            }
            Dialogs.showInformation(ACTION_NAME, stringBuilder.toString(), null);
        }

        private static int countExportedMasks(boolean[] masksExported) {
            int exportedMaskCount = 0;
            for (boolean maskExported : masksExported) {
                if (!maskExported) continue;
                ++exportedMaskCount;
            }
            return exportedMaskCount;
        }

        private static int countFailedMasks(boolean[] masksExported) {
            int exportedMaskCount = 0;
            for (boolean maskExported : masksExported) {
                if (maskExported) continue;
                ++exportedMaskCount;
            }
            return exportedMaskCount;
        }

        private static void addMaskName(StringBuilder stringBuilder, int index, String maskName, int maskCount) {
            if (maskCount < 2) {
                stringBuilder.append(maskName);
            } else if (index < maskCount - 2) {
                stringBuilder.append(maskName);
                stringBuilder.append(", ");
            } else if (index < maskCount - 1) {
                stringBuilder.append(maskName);
                stringBuilder.append(" ");
            } else if (index == maskCount - 1) {
                stringBuilder.append("and ");
                stringBuilder.append(maskName);
            }
        }

        private static boolean hasAtLeastOneMaskExported(boolean[] masksExported) {
            for (boolean maskExported : masksExported) {
                if (!maskExported) continue;
                return true;
            }
            return false;
        }

        private boolean[] addContent(Mask[] masks, Document document) {
            boolean[] masksExported = new boolean[masks.length];
            for (int i = 0; i < masks.length; ++i) {
                Mask mask = masks[i];
                DimapPersistable persistable = DimapPersistence.getPersistable((Object)mask);
                if (persistable == null) continue;
                Element element = persistable.createXmlFromObject((Object)mask);
                document.getRootElement().addContent((Content)element);
                masksExported[i] = true;
            }
            return masksExported;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeXml(File file, Document document) {
            FileWriter writer = null;
            try {
                writer = new FileWriter(file);
                Format format = Format.getPrettyFormat();
                XMLOutputter outputter = new XMLOutputter(format);
                outputter.output(document, (Writer)writer);
            }
            catch (IOException e) {
                this.showErrorDialog("Failed to export mask(s): " + e.getMessage());
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static class ImportAction
    extends MaskIOAction {
        private final TopComponent maskTopComponent;

        private ImportAction(TopComponent maskTopComponent, MaskForm maskForm) {
            super(maskTopComponent, maskForm, "icons/Import24.gif", "importButton", "Import masks from file.");
            this.maskTopComponent = maskTopComponent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.importMasks();
        }

        @Override
        void updateState() {
            this.setEnabled(this.getMaskForm().isInManagementMode());
        }

        private void importMasks() {
            File file;
            SnapFileChooser fileChooser = new SnapFileChooser();
            fileChooser.setDialogTitle("Import Masks from file");
            SnapFileFilter bmdFilter = new SnapFileFilter("BITMASK_DEFINITION_FILE", ".bmd", "Bitmask definition files (*.bmd)");
            fileChooser.addChoosableFileFilter((FileFilter)bmdFilter);
            SnapFileFilter bmdxFilter = new SnapFileFilter("BITMASK_DEFINITION_FILE_XML", ".bmdx", "Bitmask definition xml files (*.bmdx)");
            fileChooser.addChoosableFileFilter((FileFilter)bmdxFilter);
            SnapFileFilter xmlFilter = new SnapFileFilter("XML", ".xml", "XML files (*.xml)");
            fileChooser.setFileFilter((FileFilter)xmlFilter);
            fileChooser.setCurrentDirectory(this.getDirectory());
            if (fileChooser.showOpenDialog(SwingUtilities.getWindowAncestor((Component)this.maskTopComponent)) == 0 && (file = fileChooser.getSelectedFile()) != null) {
                this.setDirectory(file.getAbsoluteFile().getParentFile());
                if (file.canRead()) {
                    if (bmdFilter.accept(file)) {
                        this.importMaskFromBmd(file);
                    } else if (bmdxFilter.accept(file)) {
                        this.importMasksFromBmdx(file);
                    } else {
                        this.importMasksFromXml(file);
                    }
                }
            }
        }

        private void importMaskFromBmd(File file) {
            DefaultPropertyMap propertyMap = new DefaultPropertyMap();
            try {
                propertyMap.load(file.toPath());
                String name = propertyMap.getPropertyString("bitmaskName", "bitmask");
                String description = propertyMap.getPropertyString("bitmaskDesc", null);
                String expression = propertyMap.getPropertyString("bitmaskExpr", "");
                Color color = propertyMap.getPropertyColor("bitmaskColor", Color.yellow);
                double transparency = propertyMap.getPropertyDouble("bitmaskTransparency", Double.valueOf(0.5));
                Product product = this.getMaskForm().getProduct();
                product.addMask(name, expression, description, color, transparency);
            }
            catch (Exception e) {
                this.showErrorDialog(String.format("Failed to import mask(s): %s", e.getMessage()));
            }
        }

        private void importMasksFromBmdx(File file) {
            try {
                SAXBuilder saxBuilder = new SAXBuilder();
                Document document = saxBuilder.build(file);
                Element rootElement = document.getRootElement();
                List children = rootElement.getChildren("Bitmask_Definition");
                Product product = this.getMaskForm().getProduct();
                for (Element element : children) {
                    Mask mask = Mask.BandMathsType.createFromBitmaskDef((Element)element, (int)product.getSceneRasterWidth(), (int)product.getSceneRasterHeight());
                    product.getMaskGroup().add((ProductNode)mask);
                }
            }
            catch (Exception e) {
                this.showErrorDialog(String.format("Failed to import mask(s): %s", e.getMessage()));
            }
        }

        private void importMasksFromXml(File file) {
            try {
                SAXBuilder saxBuilder = new SAXBuilder();
                Document document = saxBuilder.build(file);
                Element rootElement = document.getRootElement();
                List children = rootElement.getChildren("Mask");
                Product product = this.getMaskForm().getProduct();
                for (Element child : children) {
                    DimapPersistable persistable = DimapPersistence.getPersistable((Element)child);
                    if (persistable == null) continue;
                    Mask mask = (Mask)persistable.createObjectFromXml(child, product);
                    this.addMaskToProductIfPossible(mask, product);
                }
            }
            catch (Exception e) {
                this.showErrorDialog(String.format("Failed to import mask(s): %s", e.getMessage()));
            }
        }

        private void addMaskToProductIfPossible(Mask mask, Product product) throws Exception {
            if (!mask.getImageType().canTransferMask(mask, product)) {
                throw new Exception(String.format("Cannot add mask '%s' to selected product.", mask.getName()));
            }
            product.getMaskGroup().add((ProductNode)mask);
        }
    }

    private static class RemoveAction
    extends MaskAction {
        private RemoveAction(MaskForm maskForm) {
            super(maskForm, "icons/Remove24.gif", "removeButton", "Remove the selected mask.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Mask[] selectedMasks = this.getMaskForm().getSelectedMasks();
            this.getMaskForm().getMaskTable().clearSelection();
            RasterDataNodeDeleter.deleteRasterDataNodes((RasterDataNode[])selectedMasks);
        }

        @Override
        void updateState() {
            this.setEnabled(this.getMaskForm().isInManagementMode() && this.getMaskForm().getSelectedRowCount() > 0);
        }
    }

    private static class NullAction
    extends MaskAction {
        private NullAction(MaskForm maskForm) {
            super(maskForm, "", "", "");
        }

        @Override
        JComponent createComponent() {
            return new JPanel();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private static class NewUnionAction
    extends BandMathsAction {
        private NewUnionAction(MaskForm maskForm) {
            super(maskForm, "Union24.png", "unionButton", "Creates the union of the selected masks");
        }

        @Override
        String getCode(ActionEvent e) {
            return this.createCodeFromSelection("||");
        }

        @Override
        void updateState() {
            this.setEnabled(this.getMaskForm().isInManagementMode() && this.getMaskForm().getSelectedRowCount() > 1);
        }
    }

    private static class NewInvDifferenceAction
    extends BandMathsAction {
        private NewInvDifferenceAction(MaskForm maskForm) {
            super(maskForm, "InvDifference24.png", "invDifferenceButton", "Creates the difference of the selected masks (in bottom-up order)");
        }

        @Override
        String getCode(ActionEvent e) {
            Mask[] selectedMasks = this.getMaskForm().getSelectedMasks();
            ArrayList<Mask> reverseList = new ArrayList<Mask>(Arrays.asList(selectedMasks));
            Collections.reverse(reverseList);
            selectedMasks = reverseList.toArray(new Mask[selectedMasks.length]);
            StringBuilder code = new StringBuilder();
            code.append(BandArithmetic.createExternalName((String)selectedMasks[0].getName()));
            if (selectedMasks.length > 1) {
                code.append(" && !(");
                code.append(this.createCodeFromSelection("||", selectedMasks, 1));
                code.append(")");
            }
            return code.toString();
        }

        @Override
        void updateState() {
            this.setEnabled(this.getMaskForm().isInManagementMode() && this.getMaskForm().getSelectedRowCount() > 1);
        }
    }

    private static class NewDifferenceAction
    extends BandMathsAction {
        private NewDifferenceAction(MaskForm maskForm) {
            super(maskForm, "Difference24.png", "differenceButton", "Creates the difference of the selected masks (in top-down order)");
        }

        @Override
        String getCode(ActionEvent e) {
            Mask[] selectedMasks = this.getMaskForm().getSelectedMasks();
            StringBuilder code = new StringBuilder();
            code.append(BandArithmetic.createExternalName((String)selectedMasks[0].getName()));
            if (selectedMasks.length > 1) {
                code.append(" && !(");
                code.append(this.createCodeFromSelection("||", selectedMasks, 1));
                code.append(")");
            }
            return code.toString();
        }

        @Override
        void updateState() {
            this.setEnabled(this.getMaskForm().isInManagementMode() && this.getMaskForm().getSelectedRowCount() > 1);
        }
    }

    private static class NewRangeAction
    extends MaskAction {
        private NewRangeAction(MaskForm maskForm) {
            super(maskForm, "Range24.png", "rangeButton", "Creates a new mask based on a value range");
        }

        @Override
        void updateState() {
            this.setEnabled(this.getMaskForm().isInManagementMode());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] rasterNames = this.collectNamesOfRastersOfSameSize();
            RangeEditorDialog.Model model = new RangeEditorDialog.Model(rasterNames);
            model.setMinValue(0.0);
            model.setMaxValue(1.0);
            model.setRasterName(rasterNames[0]);
            RangeEditorDialog rangeEditorDialog = new RangeEditorDialog(MaskFormActions.getWindow(e), model);
            if (rangeEditorDialog.show() == 1) {
                RasterDataNode referencedRaster = this.getMaskForm().getProduct().getRasterDataNode(model.getRasterName());
                if (referencedRaster == null) {
                    Dialogs.showError(String.format("Raster '%s' not found.", model.getRasterName()));
                    return;
                }
                Dimension expectedSize = this.getMaskForm().getTargetMaskSize();
                if (expectedSize != null && !ProductUtils.areRastersEqualInSize((int)expectedSize.width, (int)expectedSize.height, (RasterDataNode[])new RasterDataNode[]{referencedRaster})) {
                    String message = String.format("'%s' does not have the expected size of %d x %d pixels.", model.getRasterName(), expectedSize.width, expectedSize.height);
                    Dialogs.showError(message);
                    return;
                }
                Mask mask = this.createNewMask((Mask.ImageType)Mask.RangeType.INSTANCE);
                String externalName = Tokenizer.createExternalName((String)model.getRasterName());
                mask.setDescription(model.getMinValue() + " <= " + externalName + " <= " + model.getMaxValue());
                PropertyContainer imageConfig = mask.getImageConfig();
                imageConfig.setValue("minimum", (Object)model.getMinValue());
                imageConfig.setValue("maximum", (Object)model.getMaxValue());
                imageConfig.setValue("rasterName", (Object)externalName);
                imageConfig.addPropertyChangeListener(evt -> {
                    String oldText = evt.getOldValue().toString();
                    String newText = evt.getNewValue().toString();
                    mask.setDescription(mask.getDescription().replace(oldText, newText));
                });
                this.getMaskForm().addMask(mask);
            }
        }
    }

    private static class NewComplementAction
    extends BandMathsAction {
        private NewComplementAction(MaskForm maskForm) {
            super(maskForm, "Complement24.png", "complementButton", "Creates the complement (of the union) of the selected mask(s)");
        }

        @Override
        String getCode(ActionEvent e) {
            Mask[] selectedMasks = this.getMaskForm().getSelectedMasks();
            return "!(" + this.createCodeFromSelection("||", selectedMasks, 0) + ")";
        }

        @Override
        void updateState() {
            this.setEnabled(this.getMaskForm().isInManagementMode() && this.getMaskForm().getSelectedRowCount() >= 1);
        }
    }

    private static class NewIntersectionAction
    extends BandMathsAction {
        private NewIntersectionAction(MaskForm maskForm) {
            super(maskForm, "Intersection24.png", "intersectionButton", "Creates the intersection of the selected masks");
        }

        @Override
        String getCode(ActionEvent e) {
            return this.createCodeFromSelection("&&");
        }

        @Override
        void updateState() {
            this.setEnabled(this.getMaskForm().isInManagementMode() && this.getMaskForm().getSelectedRowCount() > 1);
        }
    }

    private static class NewVectorDataNodeAction
    extends MaskAction {
        private CreateVectorDataNodeAction action = new CreateVectorDataNodeAction();

        private NewVectorDataNodeAction(MaskForm maskForm) {
            super(maskForm, "icons/NewVectorDataNode24.gif", "newGeometry", "Creates a new mask based on a new geometry container (lines and polygons))");
        }

        @Override
        void updateState() {
            boolean enabled = SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.VIEW) != null;
            this.action.setEnabled(enabled);
            this.setEnabled(enabled);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.action.actionPerformed(e);
        }
    }

    private static class NewBandMathsAction
    extends BandMathsAction {
        private NewBandMathsAction(MaskForm maskForm) {
            super(maskForm, "BandMath24.png", "bandMathButton", "Creates a new mask based on a logical band maths expression");
        }

        @Override
        String getCode(ActionEvent e) {
            String code;
            Product product = this.getMaskForm().getProduct();
            ProductExpressionPane expressionPane = ProductExpressionPane.createBooleanExpressionPane((Product[])new Product[]{product}, (Product)product, null);
            expressionPane.setEmptyExpressionAllowed(false);
            expressionPane.setCode("");
            if (expressionPane.showModalDialog(null, "New Logical Band Maths Expression") == 1 && !(code = expressionPane.getCode()).isEmpty()) {
                return code;
            }
            return null;
        }

        @Override
        void updateState() {
            this.setEnabled(this.getMaskForm().isInManagementMode());
        }
    }
}

