/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.mask;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.swing.progress.DialogProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.Raster;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.mask.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ComputeMaskAreaAction
extends AbstractAction
implements LookupListener,
ContextAwareAction,
HelpCtx.Provider {
    private static final String HELP_ID = "computeMaskArea";
    private final Lookup lookup;
    private Lookup.Result<ProductSceneView> result;

    public ComputeMaskAreaAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ComputeMaskAreaAction(Lookup lookup) {
        super(Bundle.CTL_ComputeMaskAreaAction_MenuText());
        this.lookup = lookup;
        this.result = lookup.lookupResult(ProductSceneView.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnableState();
    }

    private void setEnableState() {
        this.setEnabled(this.lookup.lookup(ProductSceneView.class) != null);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.computeMaskArea();
    }

    private void computeMaskArea() {
        String maskName;
        String errMsgBase = "Failed to compute Mask area:\n";
        ProductSceneView view = (ProductSceneView)this.lookup.lookup(ProductSceneView.class);
        if (view == null) {
            Dialogs.showError(Bundle.CTL_ComputeMaskAreaAction_DialogTitle(), "Failed to compute Mask area:\nNo view.");
            return;
        }
        RasterDataNode raster = view.getRaster();
        assert (raster != null);
        Product product = raster.getProduct();
        ProductNodeGroup maskGroup = product.getMaskGroup();
        ArrayList<String> maskNameList = new ArrayList<String>();
        for (int i = 0; i < maskGroup.getNodeCount(); ++i) {
            Mask mask = (Mask)maskGroup.get(i);
            if (!raster.getRasterSize().equals(mask.getRasterSize())) continue;
            maskNameList.add(mask.getName());
        }
        String[] maskNames = maskNameList.toArray(new String[maskNameList.size()]);
        if (maskNames.length == 0) {
            Dialogs.showInformation(Bundle.CTL_ComputeMaskAreaAction_DialogTitle(), "No compatible mask available", null);
            return;
        }
        if (maskNames.length == 1) {
            maskName = maskNames[0];
        } else {
            ModalDialog modalDialog;
            JPanel selectPanel = new JPanel();
            selectPanel.setLayout(new BoxLayout(selectPanel, 0));
            selectPanel.add(new JLabel("Select Mask: "));
            JComboBox<String> maskCombo = new JComboBox<String>(maskNames);
            selectPanel.add(maskCombo);
            JPanel dialogPanel = selectPanel;
            if (product.isMultiSize()) {
                JPanel wrapperPanel = new JPanel(new BorderLayout(4, 3));
                wrapperPanel.add((Component)selectPanel, "Center");
                wrapperPanel.add((Component)new JLabel("<html><i>Product has rasters of different size. <br/>Only compatible masks are shown.</i>"), "South");
                dialogPanel = wrapperPanel;
            }
            if ((modalDialog = new ModalDialog((Window)SnapApp.getDefault().getMainFrame(), Bundle.CTL_ComputeMaskAreaAction_DialogTitle(), (Object)dialogPanel, 161, this.getHelpCtx().getHelpID())).show() == 1) {
                maskName = (String)maskCombo.getSelectedItem();
                if (maskName == null) {
                    return;
                }
            } else {
                return;
            }
        }
        Mask mask = (Mask)maskGroup.get(maskName);
        MultiLevelImage maskImage = mask.getSourceImage();
        if (maskImage == null) {
            Dialogs.showError(Bundle.CTL_ComputeMaskAreaAction_DialogTitle(), "Failed to compute Mask area:\nNo Mask image available.");
            return;
        }
        MaskAreaSwingWorker swingWorker = new MaskAreaSwingWorker((RasterDataNode)mask, "Failed to compute Mask area:\n");
        swingWorker.execute();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ComputeMaskAreaAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    private class MaskAreaSwingWorker
    extends SwingWorker<MaskAreaStatistics, Object> {
        private final RasterDataNode mask;
        private final String errMsgBase;

        private MaskAreaSwingWorker(RasterDataNode mask, String errMsgBase) {
            this.mask = mask;
            this.errMsgBase = errMsgBase;
        }

        @Override
        protected MaskAreaStatistics doInBackground() throws Exception {
            DialogProgressMonitor pm = new DialogProgressMonitor((Component)SnapApp.getDefault().getMainFrame(), "Computing Mask area", Dialog.ModalityType.APPLICATION_MODAL);
            return this.computeMaskAreaStatistics((ProgressMonitor)pm);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MaskAreaStatistics computeMaskAreaStatistics(ProgressMonitor pm) {
            MultiLevelImage maskImage = this.mask.getSourceImage();
            int minTileX = maskImage.getMinTileX();
            int minTileY = maskImage.getMinTileY();
            int numXTiles = maskImage.getNumXTiles();
            int numYTiles = maskImage.getNumYTiles();
            int w = this.mask.getRasterWidth();
            int h = this.mask.getRasterHeight();
            Rectangle imageRect = new Rectangle(0, 0, w, h);
            PixelPos[] pixelPoints = new PixelPos[5];
            GeoPos[] geoPoints = new GeoPos[5];
            for (int i = 0; i < geoPoints.length; ++i) {
                pixelPoints[i] = new PixelPos();
                geoPoints[i] = new GeoPos();
            }
            MaskAreaStatistics areaStatistics = new MaskAreaStatistics(6370.997);
            GeoCoding geoCoding = this.mask.getGeoCoding();
            pm.beginTask("Computing Mask area...", numXTiles * numYTiles);
            try {
                for (int tileX = minTileX; tileX < minTileX + numXTiles; ++tileX) {
                    for (int tileY = minTileY; tileY < minTileY + numYTiles && !pm.isCanceled(); ++tileY) {
                        Rectangle tileRectangle = new Rectangle(maskImage.getTileGridXOffset() + tileX * maskImage.getTileWidth(), maskImage.getTileGridYOffset() + tileY * maskImage.getTileHeight(), maskImage.getTileWidth(), maskImage.getTileHeight());
                        Rectangle r = imageRect.intersection(tileRectangle);
                        if (!r.isEmpty()) {
                            Raster maskTile = maskImage.getTile(tileX, tileY);
                            for (int y = r.y; y < r.y + r.height; ++y) {
                                for (int x = r.x; x < r.x + r.width; ++x) {
                                    if (maskTile.getSample(x, y, 0) == 0) continue;
                                    pixelPoints[0].setLocation((double)((float)x + 0.5f), (double)((float)y + 0.5f));
                                    pixelPoints[1].setLocation((double)((float)x + 0.0f), (double)((float)y + 0.5f));
                                    pixelPoints[2].setLocation((double)((float)x + 1.0f), (double)((float)y + 0.5f));
                                    pixelPoints[3].setLocation((double)((float)x + 0.5f), (double)((float)y + 0.0f));
                                    pixelPoints[4].setLocation((double)((float)x + 0.5f), (double)((float)y + 1.0f));
                                    for (int i = 0; i < geoPoints.length; ++i) {
                                        geoCoding.getGeoPos(pixelPoints[i], geoPoints[i]);
                                    }
                                    double deltaLon = Math.abs(geoPoints[2].getLon() - geoPoints[1].getLon());
                                    double deltaLat = Math.abs(geoPoints[4].getLat() - geoPoints[3].getLat());
                                    double r2 = areaStatistics.getEarthRadius() * Math.cos(geoPoints[0].getLat() * (Math.PI / 180));
                                    double a = r2 * deltaLon * (Math.PI / 180);
                                    double b = areaStatistics.getEarthRadius() * deltaLat * (Math.PI / 180);
                                    double pixelArea = a * b;
                                    areaStatistics.setPixelAreaMin(Math.min(areaStatistics.getPixelAreaMin(), pixelArea));
                                    areaStatistics.setPixelAreaMax(Math.max(areaStatistics.getPixelAreaMax(), pixelArea));
                                    areaStatistics.setMaskArea(areaStatistics.getMaskArea() + a * b);
                                    areaStatistics.setNumPixels(areaStatistics.getNumPixels() + 1);
                                }
                            }
                        }
                        pm.worked(1);
                    }
                }
            }
            finally {
                pm.done();
            }
            return areaStatistics;
        }

        @Override
        public void done() {
            try {
                MaskAreaStatistics areaStatistics = (MaskAreaStatistics)this.get();
                if (areaStatistics.getNumPixels() == 0) {
                    String message = MessageFormat.format("{0}Mask is empty.", this.errMsgBase);
                    Dialogs.showError(Bundle.CTL_ComputeMaskAreaAction_DialogTitle(), message);
                } else {
                    this.showResults(areaStatistics);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                String message = MessageFormat.format("An internal Error occurred:\n{0}", e.getMessage());
                Dialogs.showError(Bundle.CTL_ComputeMaskAreaAction_DialogTitle(), message);
                Debug.trace((Throwable)e);
            }
        }

        private void showResults(MaskAreaStatistics areaStatistics) {
            double roundFactor = 10000.0;
            double maskAreaR = MathUtils.round((double)areaStatistics.getMaskArea(), (double)10000.0);
            double meanPixelAreaR = MathUtils.round((double)(areaStatistics.getMaskArea() / (double)areaStatistics.getNumPixels()), (double)10000.0);
            double pixelAreaMinR = MathUtils.round((double)areaStatistics.getPixelAreaMin(), (double)10000.0);
            double pixelAreaMaxR = MathUtils.round((double)areaStatistics.getPixelAreaMax(), (double)10000.0);
            JPanel content = GridBagUtils.createPanel();
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets.right = 4;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.insets.top = 2;
            this.addField(content, gbc, "Number of Mask pixels:", String.format("%15d", areaStatistics.getNumPixels()), "");
            this.addField(content, gbc, "Mask area:", String.format("%15.3f", maskAreaR), "km^2");
            this.addField(content, gbc, "Mean pixel area:", String.format("%15.3f", meanPixelAreaR), "km^2");
            this.addField(content, gbc, "Minimum pixel area:", String.format("%15.3f", pixelAreaMinR), "km^2");
            this.addField(content, gbc, "Maximum pixel area:", String.format("%15.3f", pixelAreaMaxR), "km^2");
            gbc.insets.top = 8;
            this.addField(content, gbc, "Mean earth radius:", String.format("%15.3f", areaStatistics.getEarthRadius()), "km");
            ModalDialog dialog = new ModalDialog((Window)SnapApp.getDefault().getMainFrame(), Bundle.CTL_ComputeMaskAreaAction_DialogTitle() + " - " + this.mask.getDisplayName(), (Object)content, 129, ComputeMaskAreaAction.this.getHelpCtx().getHelpID());
            dialog.show();
        }

        private void addField(JPanel content, GridBagConstraints gbc, String text, String value, String unit) {
            content.add((Component)new JLabel(text), gbc);
            gbc.weightx = 1.0;
            content.add((Component)this.createTextField(value), gbc);
            gbc.weightx = 0.0;
            content.add((Component)new JLabel(unit), gbc);
            ++gbc.gridy;
        }

        private JTextField createTextField(String value) {
            JTextField field = new JTextField(value);
            field.setEditable(false);
            field.setHorizontalAlignment(4);
            return field;
        }
    }

    private static class MaskAreaStatistics {
        private double earthRadius;
        private double maskArea;
        private double pixelAreaMin;
        private double pixelAreaMax;
        private int numPixels;

        private MaskAreaStatistics(double earthRadius) {
            this.earthRadius = earthRadius;
            this.maskArea = 0.0;
            this.pixelAreaMax = Double.NEGATIVE_INFINITY;
            this.pixelAreaMin = Double.POSITIVE_INFINITY;
            this.numPixels = 0;
        }

        public double getEarthRadius() {
            return this.earthRadius;
        }

        public double getMaskArea() {
            return this.maskArea;
        }

        public void setMaskArea(double maskArea) {
            this.maskArea = maskArea;
        }

        public double getPixelAreaMin() {
            return this.pixelAreaMin;
        }

        public void setPixelAreaMin(double pixelAreaMin) {
            this.pixelAreaMin = pixelAreaMin;
        }

        public double getPixelAreaMax() {
            return this.pixelAreaMax;
        }

        public void setPixelAreaMax(double pixelAreaMax) {
            this.pixelAreaMax = pixelAreaMax;
        }

        public int getNumPixels() {
            return this.numPixels;
        }

        public void setNumPixels(int numPixels) {
            this.numPixels = numPixels;
        }
    }
}

