/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.wms;

import com.bc.ceres.glayer.Layer;
import java.awt.Dimension;
import java.util.concurrent.ExecutionException;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.layermanager.layersrc.wms.WmsWorker;
import org.esa.snap.ui.layer.LayerSourcePageContext;
import org.esa.snap.ui.product.ProductSceneView;

class WmsLayerWorker
extends WmsWorker {
    private final Layer rootLayer;

    WmsLayerWorker(LayerSourcePageContext pageContext, RasterDataNode raster) {
        super(pageContext, WmsLayerWorker.getFinalImageSize(raster));
        this.rootLayer = pageContext.getLayerContext().getRootLayer();
    }

    protected void done() {
        try {
            Layer layer = (Layer)this.get();
            try {
                ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
                this.rootLayer.getChildren().add(sceneView.getFirstImageLayerIndex(), layer);
            }
            catch (Exception e) {
                this.getContext().showErrorDialog(e.getMessage());
            }
        }
        catch (ExecutionException e) {
            this.getContext().showErrorDialog(String.format("Error while expecting WMS response:\n%s", e.getCause().getMessage()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static Dimension getFinalImageSize(RasterDataNode raster) {
        int height;
        int width;
        double ratio = (double)raster.getRasterWidth() / (double)raster.getRasterHeight();
        if (ratio >= 1.0) {
            width = Math.min(1280, raster.getRasterWidth());
            height = (int)Math.round((double)width / ratio);
        } else {
            height = Math.min(1280, raster.getRasterHeight());
            width = (int)Math.round((double)height * ratio);
        }
        return new Dimension(width, height);
    }
}

