/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc.wms;

import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.layermanager.layersrc.wms.WmsAssistantPage1;
import org.esa.snap.rcp.layermanager.layersrc.wms.WmsLayerWorker;
import org.esa.snap.ui.layer.AbstractLayerSourceAssistantPage;
import org.esa.snap.ui.layer.LayerSource;
import org.esa.snap.ui.layer.LayerSourcePageContext;
import org.esa.snap.ui.product.ProductSceneView;

public class WmsLayerSource
implements LayerSource {
    static final String PROPERTY_NAME_WMS = "wms";
    static final String PROPERTY_NAME_WMS_URL = "wmsUrl";
    static final String PROPERTY_NAME_WMS_CAPABILITIES = "wmsCapabilities";
    static final String PROPERTY_NAME_SELECTED_LAYER = "selectedLayer";
    static final String PROPERTY_NAME_SELECTED_STYLE = "selectedStyle";
    static final String PROPERTY_NAME_CRS_ENVELOPE = "crsEnvelope";

    public boolean isApplicable(LayerSourcePageContext pageContext) {
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        RasterDataNode raster = view.getRaster();
        return raster.getGeoCoding() instanceof MapGeoCoding || raster.getGeoCoding() instanceof CrsGeoCoding;
    }

    public boolean hasFirstPage() {
        return true;
    }

    public AbstractLayerSourceAssistantPage getFirstPage(LayerSourcePageContext pageContext) {
        return new WmsAssistantPage1();
    }

    public boolean canFinish(LayerSourcePageContext pageContext) {
        return false;
    }

    public boolean performFinish(LayerSourcePageContext pageContext) {
        return false;
    }

    public void cancel(LayerSourcePageContext pageContext) {
    }

    static void insertWmsLayer(LayerSourcePageContext pageContext) {
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        RasterDataNode raster = view.getRaster();
        WmsLayerWorker layerWorker = new WmsLayerWorker(pageContext, raster);
        layerWorker.execute();
    }
}

