/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import com.jidesoft.swing.TitledSeparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;

class MoreOptionsPane {
    private static ImageIcon[] icons;
    private static ImageIcon[] rolloverIcons;
    private final ColorManipulationForm colorManipulationForm;
    private final JPanel contentPanel;
    private final JLabel[] headerLabels;
    private final TitledSeparator headerSeparator;
    private final AbstractButton headerButton;
    private JComponent component;
    private boolean collapsed;

    MoreOptionsPane(ColorManipulationForm colorManipulationForm, boolean collapsed) {
        this.colorManipulationForm = colorManipulationForm;
        if (icons == null) {
            icons = new ImageIcon[]{UIUtils.loadImageIcon((String)"icons/PanelUp12.png"), UIUtils.loadImageIcon((String)"icons/PanelDown12.png")};
            rolloverIcons = new ImageIcon[]{ToolButtonFactory.createRolloverIcon((ImageIcon)icons[0]), ToolButtonFactory.createRolloverIcon((ImageIcon)icons[1])};
        }
        this.headerLabels = new JLabel[]{new JLabel("More Options"), new JLabel("Less Options")};
        Color headerLabelColor = UIManager.getLookAndFeelDefaults().getColor("TitledBorder.titleColor");
        if (headerLabelColor != null) {
            this.headerLabels[0].setForeground(headerLabelColor);
            this.headerLabels[1].setForeground(headerLabelColor);
        }
        this.component = new JLabel();
        this.collapsed = collapsed;
        this.headerButton = ToolButtonFactory.createButton((Icon)icons[0], (boolean)false);
        this.headerButton.setName("MoreOptionsPane.headerButton");
        this.headerButton.addActionListener(e -> this.setCollapsed(!this.isCollapsed()));
        JPanel titleBar = new JPanel(new BorderLayout(2, 2));
        titleBar.add((Component)this.headerButton, "West");
        this.headerSeparator = new TitledSeparator((JComponent)this.headerLabels[0], 0, 2);
        this.headerSeparator.setName("MoreOptionsPane.headerSeparator");
        titleBar.add((Component)this.headerSeparator, "Center");
        this.contentPanel = new JPanel(new BorderLayout(2, 2));
        this.contentPanel.add((Component)titleBar, "North");
        this.contentPanel.setName("MoreOptionsPane.contentPanel");
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setComponent(JComponent component) {
        this.contentPanel.remove(this.component);
        this.component = component;
        this.updateState();
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
        this.updateState();
    }

    private void updateState() {
        if (this.collapsed) {
            this.contentPanel.remove(this.component);
        } else {
            this.contentPanel.add((Component)this.component, "Center");
        }
        int i = this.collapsed ? 0 : 1;
        this.headerSeparator.setLabelComponent((JComponent)this.headerLabels[i]);
        this.headerButton.setIcon(icons[i]);
        this.headerButton.setRolloverIcon(rolloverIcons[i]);
        this.colorManipulationForm.revalidateToolViewPaneControl();
    }
}

