/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.rcp.colormanip.ColorManipulationChildForm;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.colormanip.Continuous1BandGraphicalForm;
import org.esa.snap.rcp.colormanip.FormModel;
import org.esa.snap.rcp.colormanip.ImageInfoEditor2;
import org.esa.snap.rcp.colormanip.ImageInfoEditorModel3B;
import org.esa.snap.rcp.colormanip.ImageInfoEditorSupport;
import org.esa.snap.rcp.colormanip.MoreOptionsForm;
import org.esa.snap.ui.ImageInfoEditorModel;

class Continuous3BandGraphicalForm
implements ColorManipulationChildForm {
    private final ColorManipulationForm parentForm;
    private final ImageInfoEditor2 imageInfoEditor;
    private final ImageInfoEditorSupport imageInfoEditorSupport;
    private final JPanel contentPanel;
    private final ImageInfoEditorModel3B[] models;
    private final RasterDataNode[] initialChannelSources;
    private final RasterDataNode[] currentChannelSources;
    private final List<RasterDataNode> channelSourcesList;
    private final MoreOptionsForm moreOptionsForm;
    private int channel;
    private static final String GAMMA_PROPERTY = "gamma";
    double gamma = 1.0;
    private static final String CHANNEL_SOURCE_NAME_PROPERTY = "channelSourceName";
    String channelSourceName = "";

    public Continuous3BandGraphicalForm(ColorManipulationForm parentForm) {
        this.parentForm = parentForm;
        this.imageInfoEditor = new ImageInfoEditor2(parentForm);
        this.imageInfoEditorSupport = new ImageInfoEditorSupport(this.imageInfoEditor);
        this.moreOptionsForm = new MoreOptionsForm(this, parentForm.getFormModel().canUseHistogramMatching());
        this.models = new ImageInfoEditorModel3B[3];
        this.initialChannelSources = new RasterDataNode[3];
        this.currentChannelSources = new RasterDataNode[3];
        this.channelSourcesList = new ArrayList<RasterDataNode>(32);
        this.channel = 0;
        Property channelSourceNameModel = Property.createForField((Object)this, (String)CHANNEL_SOURCE_NAME_PROPERTY, (Object)"");
        JComboBox channelSourceNameBox = new JComboBox();
        channelSourceNameBox.setEditable(false);
        Property gammaModel = Property.createForField((Object)this, (String)GAMMA_PROPERTY, (Object)1.0);
        gammaModel.getDescriptor().setValueRange(new ValueRange(0.1, 10.0));
        gammaModel.getDescriptor().setDefaultValue((Object)1.0);
        JTextField gammaField = new JTextField();
        gammaField.setColumns(6);
        gammaField.setHorizontalAlignment(4);
        this.moreOptionsForm.getBindingContext().getPropertySet().addProperty(channelSourceNameModel);
        this.moreOptionsForm.getBindingContext().bind(CHANNEL_SOURCE_NAME_PROPERTY, channelSourceNameBox);
        this.moreOptionsForm.getBindingContext().getPropertySet().addProperty(gammaModel);
        this.moreOptionsForm.getBindingContext().bind(GAMMA_PROPERTY, gammaField);
        this.moreOptionsForm.addRow(new JLabel("Source band: "), channelSourceNameBox);
        this.moreOptionsForm.addRow(new JLabel("Gamma non-linearity: "), gammaField);
        PropertyContainer propertyContainer = new PropertyContainer();
        propertyContainer.addProperty(Property.createForField((Object)this, (String)"channel", (Object)0));
        propertyContainer.getProperty("channel").getDescriptor().setValueSet(new ValueSet((Object[])new Integer[]{0, 1, 2}));
        BindingContext bindingContext = new BindingContext((PropertySet)propertyContainer);
        JRadioButton rChannelButton = new JRadioButton("Red");
        JRadioButton gChannelButton = new JRadioButton("Green");
        JRadioButton bChannelButton = new JRadioButton("Blue");
        rChannelButton.setName("rChannelButton");
        gChannelButton.setName("gChannelButton");
        bChannelButton.setName("bChannelButton");
        ButtonGroup channelButtonGroup = new ButtonGroup();
        channelButtonGroup.add(rChannelButton);
        channelButtonGroup.add(gChannelButton);
        channelButtonGroup.add(bChannelButton);
        bindingContext.bind("channel", channelButtonGroup);
        bindingContext.addPropertyChangeListener("channel", evt -> this.acknowledgeChannel());
        JPanel channelButtonPanel = new JPanel(new FlowLayout(0));
        channelButtonPanel.add(rChannelButton);
        channelButtonPanel.add(gChannelButton);
        channelButtonPanel.add(bChannelButton);
        this.contentPanel = new JPanel(new BorderLayout(2, 2));
        this.contentPanel.add((Component)channelButtonPanel, "North");
        this.contentPanel.add((Component)((Object)this.imageInfoEditor), "Center");
        this.moreOptionsForm.getBindingContext().addPropertyChangeListener(GAMMA_PROPERTY, evt -> this.handleGammaChanged());
        this.moreOptionsForm.getBindingContext().addPropertyChangeListener(CHANNEL_SOURCE_NAME_PROPERTY, this::handleChannelSourceNameChanged);
    }

    @Override
    public Component getContentPanel() {
        return this.contentPanel;
    }

    @Override
    public ColorManipulationForm getParentForm() {
        return this.parentForm;
    }

    @Override
    public void handleFormShown(FormModel formModel) {
        RasterDataNode[] rasters = formModel.getRasters();
        this.initialChannelSources[0] = rasters[0];
        this.initialChannelSources[1] = rasters[1];
        this.initialChannelSources[2] = rasters[2];
        this.updateFormModel(formModel);
        this.parentForm.revalidateToolViewPaneControl();
    }

    @Override
    public void handleFormHidden(FormModel formModel) {
        this.imageInfoEditor.setModel(null);
        this.channelSourcesList.clear();
        Arrays.fill((Object[])this.models, null);
        Arrays.fill(this.initialChannelSources, null);
        Arrays.fill(this.currentChannelSources, null);
    }

    @Override
    public void updateFormModel(FormModel formModel) {
        RasterDataNode[] rasters = formModel.getRasters();
        this.currentChannelSources[0] = rasters[0];
        this.currentChannelSources[1] = rasters[1];
        this.currentChannelSources[2] = rasters[2];
        Band[] availableBands = formModel.getProduct().getBands();
        this.channelSourcesList.clear();
        this.appendToChannelSources(this.currentChannelSources);
        this.appendToChannelSources(this.initialChannelSources);
        this.appendToChannelSources((RasterDataNode[])availableBands);
        for (int i = 0; i < this.models.length; ++i) {
            ImageInfoEditorModel3B oldModel = this.models[i];
            this.models[i] = new ImageInfoEditorModel3B(this.parentForm.getFormModel().getModifiedImageInfo(), i);
            Continuous1BandGraphicalForm.setDisplayProperties((ImageInfoEditorModel)this.models[i], this.currentChannelSources[i]);
            if (oldModel == null) continue;
            this.models[i].setHistogramViewGain(oldModel.getHistogramViewGain());
            this.models[i].setMinHistogramViewSample(oldModel.getMinHistogramViewSample());
            this.models[i].setMaxHistogramViewSample(oldModel.getMaxHistogramViewSample());
        }
        Object[] sourceNames = new String[this.channelSourcesList.size()];
        for (int i = 0; i < this.channelSourcesList.size(); ++i) {
            sourceNames[i] = this.channelSourcesList.get(i).getName();
        }
        this.moreOptionsForm.getBindingContext().getPropertySet().getProperty(CHANNEL_SOURCE_NAME_PROPERTY).getDescriptor().setValueSet(new ValueSet(sourceNames));
        this.acknowledgeChannel();
    }

    private void appendToChannelSources(RasterDataNode[] rasterDataNodes) {
        for (RasterDataNode channelSource : rasterDataNodes) {
            if (this.channelSourcesList.contains(channelSource)) continue;
            this.channelSourcesList.add(channelSource);
        }
    }

    @Override
    public void resetFormModel(FormModel formModel) {
        this.updateFormModel(formModel);
        this.imageInfoEditor.computeZoomOutToFullHistogramm();
    }

    @Override
    public void handleRasterPropertyChange(ProductNodeEvent event, RasterDataNode raster) {
        ImageInfoEditorModel model = this.imageInfoEditor.getModel();
        if (model != null) {
            Continuous1BandGraphicalForm.setDisplayProperties(model, raster);
        }
        if (event.getPropertyName().equals("stx")) {
            this.acknowledgeChannel();
        }
    }

    @Override
    public RasterDataNode[] getRasters() {
        return (RasterDataNode[])this.currentChannelSources.clone();
    }

    @Override
    public MoreOptionsForm getMoreOptionsForm() {
        return this.moreOptionsForm;
    }

    @Override
    public AbstractButton[] getToolButtons() {
        return new AbstractButton[]{this.imageInfoEditorSupport.autoStretch95Button, this.imageInfoEditorSupport.autoStretch100Button, this.imageInfoEditorSupport.zoomInVButton, this.imageInfoEditorSupport.zoomOutVButton, this.imageInfoEditorSupport.zoomInHButton, this.imageInfoEditorSupport.zoomOutHButton, this.imageInfoEditorSupport.showExtraInfoButton};
    }

    private void acknowledgeChannel() {
        RasterDataNode channelSource = this.currentChannelSources[this.channel];
        ImageInfoEditorModel3B model = this.models[this.channel];
        Continuous1BandGraphicalForm.setDisplayProperties((ImageInfoEditorModel)model, channelSource);
        this.imageInfoEditor.setModel((ImageInfoEditorModel)model);
        this.moreOptionsForm.getBindingContext().getBinding(CHANNEL_SOURCE_NAME_PROPERTY).setPropertyValue((Object)channelSource.getName());
        this.moreOptionsForm.getBindingContext().getBinding(GAMMA_PROPERTY).setPropertyValue((Object)model.getGamma());
    }

    private void handleGammaChanged() {
        this.imageInfoEditor.getModel().setGamma(this.gamma);
        this.parentForm.applyChanges();
    }

    private void handleChannelSourceNameChanged(PropertyChangeEvent evt) {
        RasterDataNode newChannelSource = null;
        for (RasterDataNode rasterDataNode : this.channelSourcesList) {
            if (!rasterDataNode.getName().equals(this.channelSourceName)) continue;
            newChannelSource = rasterDataNode;
            break;
        }
        if (newChannelSource == null) {
            JOptionPane.showMessageDialog(this.contentPanel, MessageFormat.format("Unknown band: ''{0}''", this.channelSourceName), "Error", 0);
            return;
        }
        RasterDataNode oldChannelSource = this.currentChannelSources[this.channel];
        if (newChannelSource != oldChannelSource) {
            Stx stx = this.parentForm.getStx(newChannelSource);
            if (stx != null) {
                this.currentChannelSources[this.channel] = newChannelSource;
                ImageInfo imageInfo = this.parentForm.getFormModel().getModifiedImageInfo();
                imageInfo.getRgbChannelDef().setSourceName(this.channel, this.channelSourceName);
                ImageInfo info = newChannelSource.getImageInfo(ProgressMonitor.NULL);
                ColorPaletteDef def = info.getColorPaletteDef();
                if (def != null) {
                    imageInfo.getRgbChannelDef().setMinDisplaySample(this.channel, def.getMinDisplaySample());
                    imageInfo.getRgbChannelDef().setMaxDisplaySample(this.channel, def.getMaxDisplaySample());
                }
                this.models[this.channel] = new ImageInfoEditorModel3B(imageInfo, this.channel);
                Continuous1BandGraphicalForm.setDisplayProperties((ImageInfoEditorModel)this.models[this.channel], newChannelSource);
                this.acknowledgeChannel();
                this.parentForm.applyChanges();
            } else {
                Object value = evt.getOldValue();
                this.moreOptionsForm.getBindingContext().getBinding(CHANNEL_SOURCE_NAME_PROPERTY).setPropertyValue(value == null ? "" : value);
            }
        }
    }
}

