/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.colormanip.ColorManipulationChildForm;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.colormanip.DiscreteCheckBox;
import org.esa.snap.rcp.colormanip.FormModel;
import org.esa.snap.rcp.colormanip.MoreOptionsForm;
import org.esa.snap.ui.color.ColorTableCellEditor;
import org.esa.snap.ui.color.ColorTableCellRenderer;

class Continuous1BandTabularForm
implements ColorManipulationChildForm {
    private static final String[] COLUMN_NAMES = new String[]{"Colour", "Value"};
    private static final Class<?>[] COLUMN_TYPES = new Class[]{Color.class, Double.class};
    private final ColorManipulationForm parentForm;
    private ImageInfoTableModel tableModel;
    private JScrollPane contentPanel;
    private final MoreOptionsForm moreOptionsForm;
    private TableModelListener tableModelListener;
    private final DiscreteCheckBox discreteCheckBox;

    public Continuous1BandTabularForm(ColorManipulationForm parentForm) {
        this.parentForm = parentForm;
        this.tableModel = new ImageInfoTableModel();
        this.tableModelListener = e -> {
            this.tableModel.removeTableModelListener(this.tableModelListener);
            parentForm.applyChanges();
            this.tableModel.addTableModelListener(this.tableModelListener);
        };
        this.moreOptionsForm = new MoreOptionsForm(this, parentForm.getFormModel().canUseHistogramMatching());
        this.discreteCheckBox = new DiscreteCheckBox(parentForm);
        this.moreOptionsForm.addRow(this.discreteCheckBox);
        parentForm.getFormModel().modifyMoreOptionsForm(this.moreOptionsForm);
        JTable table = new JTable(this.tableModel);
        table.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorTableCellRenderer());
        table.setDefaultEditor(Color.class, (TableCellEditor)new ColorTableCellEditor());
        table.getTableHeader().setReorderingAllowed(false);
        table.getColumnModel().getColumn(0).setPreferredWidth(140);
        table.getColumnModel().getColumn(1).setPreferredWidth(140);
        table.setAutoResizeMode(0);
        JScrollPane tableScrollPane = new JScrollPane(table);
        tableScrollPane.getViewport().setPreferredSize(table.getPreferredSize());
        this.contentPanel = tableScrollPane;
    }

    @Override
    public ColorManipulationForm getParentForm() {
        return this.parentForm;
    }

    @Override
    public void handleFormShown(FormModel formModel) {
        this.updateFormModel(formModel);
        this.tableModel.addTableModelListener(this.tableModelListener);
    }

    @Override
    public void handleFormHidden(FormModel formModel) {
        this.tableModel.removeTableModelListener(this.tableModelListener);
    }

    @Override
    public void updateFormModel(FormModel formModel) {
        this.tableModel.fireTableDataChanged();
        this.discreteCheckBox.setDiscreteColorsMode(this.parentForm.getFormModel().getModifiedImageInfo().getColorPaletteDef().isDiscrete());
    }

    @Override
    public void resetFormModel(FormModel formModel) {
        this.tableModel.fireTableDataChanged();
    }

    @Override
    public void handleRasterPropertyChange(ProductNodeEvent event, RasterDataNode raster) {
    }

    @Override
    public Component getContentPanel() {
        return this.contentPanel;
    }

    @Override
    public AbstractButton[] getToolButtons() {
        return new AbstractButton[0];
    }

    @Override
    public MoreOptionsForm getMoreOptionsForm() {
        return this.moreOptionsForm;
    }

    @Override
    public RasterDataNode[] getRasters() {
        return this.parentForm.getFormModel().getRasters();
    }

    private class ImageInfoTableModel
    extends AbstractTableModel {
        private ImageInfoTableModel() {
        }

        public ImageInfo getImageInfo() {
            return Continuous1BandTabularForm.this.parentForm.getFormModel().getModifiedImageInfo();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return COLUMN_TYPES[columnIndex];
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public int getRowCount() {
            if (this.getImageInfo() == null) {
                return 0;
            }
            return this.getImageInfo().getColorPaletteDef().getNumPoints();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ColorPaletteDef.Point point = this.getImageInfo().getColorPaletteDef().getPointAt(rowIndex);
            if (columnIndex == 0) {
                Color color = point.getColor();
                return color.equals(ImageInfo.NO_COLOR) ? null : color;
            }
            if (columnIndex == 1) {
                return point.getSample();
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ColorPaletteDef.Point point = this.getImageInfo().getColorPaletteDef().getPointAt(rowIndex);
            if (columnIndex == 0) {
                Color color = (Color)aValue;
                point.setColor(color == null ? ImageInfo.NO_COLOR : color);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            } else if (columnIndex == 1) {
                point.setSample(((Double)aValue).doubleValue());
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0 || columnIndex == 1;
        }
    }
}

