/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.vector;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.esa.snap.core.dataio.geometry.VectorDataNodeReader;
import org.esa.snap.core.datamodel.GeometryDescriptor;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkDescriptorRegistry;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.AbstractSnapAction;
import org.esa.snap.rcp.actions.vector.FeatureCrsDialog;
import org.esa.snap.rcp.actions.vector.TypeDialog;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

abstract class AbstractImportVectorDataNodeAction
extends AbstractSnapAction {
    protected FeatureUtils.FeatureCrsProvider crsProvider = new MyFeatureCrsProvider();
    protected VectorDataNodeReader.PlacemarkDescriptorProvider placemarkDescriptorProvider = new MyPlacemarkDescriptorProvider();
    private int featureCrsDialogResult;

    protected AbstractImportVectorDataNodeAction() {
    }

    protected abstract String getDialogTitle();

    protected abstract String getVectorDataType();

    private class MyFeatureCrsProvider
    implements FeatureUtils.FeatureCrsProvider {
        private MyFeatureCrsProvider() {
        }

        public CoordinateReferenceSystem getFeatureCrs(Product product) {
            if (product.getSceneCRS() == Product.DEFAULT_IMAGE_CRS) {
                return Product.DEFAULT_IMAGE_CRS;
            }
            CoordinateReferenceSystem[] featureCrsBuffer = new CoordinateReferenceSystem[1];
            Runnable runnable = () -> {
                featureCrsBuffer[0] = this.promptForFeatureCrs(product);
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            } else {
                runnable.run();
            }
            CoordinateReferenceSystem featureCrs = featureCrsBuffer[0];
            return featureCrs != null ? featureCrs : DefaultGeographicCRS.WGS84;
        }

        public boolean clipToProductBounds() {
            return true;
        }

        private CoordinateReferenceSystem promptForFeatureCrs(Product product) {
            FeatureCrsDialog dialog = new FeatureCrsDialog(product, "Import " + AbstractImportVectorDataNodeAction.this.getVectorDataType() + " Data");
            AbstractImportVectorDataNodeAction.this.featureCrsDialogResult = dialog.show();
            if (AbstractImportVectorDataNodeAction.this.featureCrsDialogResult == 1) {
                return dialog.getFeatureCrs();
            }
            return DefaultGeographicCRS.WGS84;
        }
    }

    private class MyPlacemarkDescriptorProvider
    implements VectorDataNodeReader.PlacemarkDescriptorProvider {
        private MyPlacemarkDescriptorProvider() {
        }

        public PlacemarkDescriptor getPlacemarkDescriptor(SimpleFeatureType simpleFeatureType) {
            String placemarkDescriptorClass;
            PlacemarkDescriptor placemarkDescriptor;
            PlacemarkDescriptorRegistry placemarkDescriptorRegistry = PlacemarkDescriptorRegistry.getInstance();
            if (simpleFeatureType.getUserData().containsKey("placemarkDescriptor") && (placemarkDescriptor = placemarkDescriptorRegistry.getPlacemarkDescriptor(placemarkDescriptorClass = simpleFeatureType.getUserData().get("placemarkDescriptor").toString())) != null) {
                return placemarkDescriptor;
            }
            List validPlacemarkDescriptors = placemarkDescriptorRegistry.getPlacemarkDescriptors(simpleFeatureType);
            if (validPlacemarkDescriptors.size() == 1) {
                return (PlacemarkDescriptor)validPlacemarkDescriptors.get(0);
            }
            if (AbstractImportVectorDataNodeAction.this.featureCrsDialogResult == 1) {
                TypeDialog typeDialog = new TypeDialog(SnapApp.getDefault().getMainFrame(), simpleFeatureType);
                int dialogResult = typeDialog.show();
                if (dialogResult == 1) {
                    return typeDialog.getPlacemarkDescriptor();
                }
                if (dialogResult == 32) {
                    typeDialog.close();
                    return null;
                }
            } else {
                return null;
            }
            return PlacemarkDescriptorRegistry.getInstance().getPlacemarkDescriptor(GeometryDescriptor.class);
        }
    }
}

