/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file.export;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EventListener;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.export.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ExportColorPaletteAction
extends AbstractAction
implements LookupListener,
ContextAwareAction,
HelpCtx.Provider {
    private static final String KEY_LAST_OPEN = "ExportColorPaletteVPI.path";
    private static final String HELP_ID = "exportColorPalette";
    private final Lookup.Result<ProductSceneView> result;

    public ExportColorPaletteAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ExportColorPaletteAction(Lookup lookup) {
        super(Bundle.CTL_ExportColorPaletteAction_MenuText());
        this.putValue("popupText", Bundle.CTL_ExportColorPaletteAction_PopupText());
        this.result = lookup.lookupResult(ProductSceneView.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SnapFileFilter fileFilter1 = new SnapFileFilter("CSV", ".csv", "CSV files");
        SnapFileFilter fileFilter2 = new SnapFileFilter("TXT", ".txt", "Text files");
        JFileChooser fileChooser = new JFileChooser();
        File lastDir = new File(ExportColorPaletteAction.getPreferences().getPropertyString(KEY_LAST_OPEN, "."));
        fileChooser.setCurrentDirectory(lastDir);
        RasterDataNode raster = this.getSelectedRaster();
        fileChooser.setSelectedFile(new File(lastDir, raster.getName() + "-palette.csv"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter((FileFilter)fileFilter1);
        fileChooser.addChoosableFileFilter((FileFilter)fileFilter2);
        fileChooser.setFileFilter((FileFilter)fileFilter1);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setDialogTitle(Bundle.CTL_ExportColorPaletteAction_DialogTitle());
        if (fileChooser.showSaveDialog(SnapApp.getDefault().getMainFrame()) == 0 && fileChooser.getSelectedFile() != null) {
            ExportColorPaletteAction.getPreferences().setPropertyString(KEY_LAST_OPEN, fileChooser.getCurrentDirectory().getAbsolutePath());
            File file = fileChooser.getSelectedFile();
            if (fileChooser.getFileFilter() instanceof SnapFileFilter) {
                SnapFileFilter fileFilter = (SnapFileFilter)fileChooser.getFileFilter();
                file = FileUtils.ensureExtension((File)file, (String)fileFilter.getDefaultExtension());
            }
            try {
                ExportColorPaletteAction.writeColorPalette(raster, file);
            }
            catch (IOException ie) {
                Dialogs.showError(Bundle.CTL_ExportColorPaletteAction_DialogTitle(), "Failed to export colour palette:\n" + ie.getMessage());
            }
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ExportColorPaletteAction(lookup);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setEnabled(this.getSelectedImageInfo() != null);
    }

    private static void writeColorPalette(RasterDataNode raster, File file) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            ExportColorPaletteAction.writeColorPalette(raster, writer);
        }
    }

    private static void writeColorPalette(RasterDataNode raster, FileWriter writer) throws IOException {
        ImageInfo imageInfo = raster.getImageInfo();
        ColorPaletteDef paletteDef = imageInfo.getColorPaletteDef();
        Color[] colorPalette = ImageManager.createColorPalette((ImageInfo)imageInfo);
        double s1 = paletteDef.getMinDisplaySample();
        double s2 = paletteDef.getMaxDisplaySample();
        int numColors = colorPalette.length;
        writer.write("# Band: " + raster.getName() + "\n");
        writer.write("# Sample unit: " + raster.getUnit() + "\n");
        writer.write("# Minimum sample value: " + s1 + "\n");
        writer.write("# Maximum sample value: " + s2 + "\n");
        writer.write("# Number of colors: " + numColors + "\n");
        double sf = (s2 - s1) / ((double)numColors - 1.0);
        writer.write("ID;Sample;RGB\n");
        for (int i = 0; i < numColors; ++i) {
            Color color = colorPalette[i];
            double s = s1 + (double)i * sf;
            writer.write(i + ";" + s + ";" + StringUtils.formatColor((Color)color) + "\n");
        }
    }

    private RasterDataNode getSelectedRaster() {
        Optional first = this.result.allInstances().stream().findFirst();
        if (first.isPresent()) {
            return ((ProductSceneView)first.get()).getRaster();
        }
        return null;
    }

    private ImageInfo getSelectedImageInfo() {
        RasterDataNode raster = this.getSelectedRaster();
        if (raster != null) {
            return raster.getImageInfo();
        }
        return null;
    }

    private static PropertyMap getPreferences() {
        return SnapApp.getDefault().getPreferencesPropertyMap();
    }
}

