/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import javax.swing.SwingUtilities;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeList;
import org.esa.snap.core.util.Debug;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.Bundle;
import org.esa.snap.rcp.actions.file.OpenProductAction;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.util.ProgressHandleMonitor;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Cancellable;

class WriteProductOperation
implements Runnable,
Cancellable {
    private final Product product;
    private final Boolean incremental;
    private final ProgressHandleMonitor pm;
    private final File fileLocation;
    private final String formatName;
    private Boolean status;

    public WriteProductOperation(Product product, Boolean incremental) {
        this(product, product.getFileLocation(), "BEAM-DIMAP", incremental);
    }

    public WriteProductOperation(Product product, File fileLocation, String formatName, Boolean incremental) {
        Assert.notNull((Object)product, (String)"product");
        Assert.notNull((Object)fileLocation, (String)"fileLocation");
        Assert.notNull((Object)formatName, (String)"formatName");
        this.product = product;
        this.fileLocation = fileLocation;
        this.formatName = formatName;
        this.incremental = incremental != null ? incremental : Boolean.valueOf(SnapApp.getDefault().getPreferences().getBoolean("save.incremental", true));
        this.pm = ProgressHandleMonitor.create(Bundle.CTL_WriteProductOperationName(), this);
    }

    public Boolean getStatus() {
        return this.status;
    }

    public ProgressHandle getProgressHandle() {
        return this.pm.getProgressHandle();
    }

    public boolean cancel() {
        Dialogs.Answer answer = Dialogs.requestDecision(Bundle.CTL_WriteProductOperationName(), "Cancellation of writing may lead to an unreadable product.\n\nDo you really want to cancel the write process?", false, null);
        return answer == Dialogs.Answer.YES;
    }

    @Override
    public void run() {
        Boolean saveOk;
        MetadataElement element;
        boolean saveProductHeaders = SnapApp.getDefault().getPreferences().getBoolean("save.product.headers", true);
        boolean saveProductHistory = SnapApp.getDefault().getPreferences().getBoolean("save.product.history", true);
        boolean saveADS = SnapApp.getDefault().getPreferences().getBoolean("save.product.annotations", false);
        MetadataElement metadataRoot = this.product.getMetadataRoot();
        ProductNodeList metadataElementBackup = new ProductNodeList();
        if (!saveProductHeaders) {
            String[] headerNames = new String[]{"MPH", "SPH", "Earth_Explorer_Header", "Fixed_Header", "Variable_Header", "Specific_Product_Header", "Global_Attributes", "GlobalAttributes", "Variable_Attributes"};
            for (String headerName : headerNames) {
                element = metadataRoot.getElement(headerName);
                metadataElementBackup.add((ProductNode)element);
                metadataRoot.removeElement(element);
            }
        }
        if (!saveProductHistory) {
            MetadataElement element2 = metadataRoot.getElement("History");
            metadataElementBackup.add((ProductNode)element2);
            metadataRoot.removeElement(element2);
        }
        if (!saveADS) {
            String[] names;
            for (String name : names = metadataRoot.getElementNames()) {
                if (!name.endsWith("ADS") && !name.endsWith("Ads") && !name.endsWith("ads")) continue;
                element = metadataRoot.getElement(name);
                metadataElementBackup.add((ProductNode)element);
                metadataRoot.removeElement(element);
            }
        }
        if ((saveOk = WriteProductOperation.writeProduct(this.product, this.fileLocation, this.formatName, this.incremental, this.pm)) != null && saveOk.booleanValue()) {
            this.product.setModified(false);
            OpenProductAction.getRecentProductPaths().add(this.fileLocation.getPath());
        } else if (metadataRoot != null) {
            MetadataElement[] elementsArray = new MetadataElement[metadataElementBackup.size()];
            metadataElementBackup.toArray((ProductNode[])elementsArray);
            for (MetadataElement metadataElement : elementsArray) {
                metadataRoot.addElement(metadataElement);
            }
        }
        this.status = saveOk;
    }

    private static Boolean writeProduct(Product product, File file, String formatName, boolean incremental, ProgressMonitor pm) {
        Debug.assertNotNull((Object)product);
        try {
            ProductIO.writeProduct((Product)product, (File)file, (String)formatName, (boolean)incremental, (ProgressMonitor)pm);
            return !pm.isCanceled() ? Boolean.valueOf(true) : null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(() -> Dialogs.showError("Writing failed", e.getMessage()));
            return false;
        }
    }
}

