/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.session.dom;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.net.URL;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.rcp.layermanager.layersrc.shapefile.FeatureLayer;
import org.esa.snap.rcp.layermanager.layersrc.shapefile.FeatureLayerType;
import org.esa.snap.rcp.session.dom.AbstractLayerConfigurationPersistencyTest;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.style.Fill;

public class FeatureLayerConfigurationPersistencyTest
extends AbstractLayerConfigurationPersistencyTest {
    public FeatureLayerConfigurationPersistencyTest() {
        super(LayerTypeRegistry.getLayerType(FeatureLayerType.class));
    }

    @Override
    protected Layer createLayer(LayerType layerType) throws Exception {
        FeatureCollection fc;
        PropertySet configuration = layerType.createLayerConfig(null);
        URL shapefileUrl = this.getClass().getResource("bundeslaender.shp");
        configuration.setValue("featureCollectionUrl", (Object)shapefileUrl);
        configuration.setValue("featureCollectionTargetCrs", (Object)DefaultGeographicCRS.WGS84);
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(-10.0, 50.0), new Coordinate(10.0, 50.0), new Coordinate(10.0, 30.0), new Coordinate(-10.0, 30.0), new Coordinate(-10.0, 50.0)};
        GeometryFactory geometryFactory = new GeometryFactory();
        LinearRing ring = geometryFactory.createLinearRing(coordinates);
        Polygon clipGeometry = geometryFactory.createPolygon(ring, new LinearRing[0]);
        configuration.setValue("featureCollectionClipGeometry", (Object)clipGeometry);
        configuration.setValue("sldStyle", (Object)FeatureLayerConfigurationPersistencyTest.createStyle());
        try {
            fc = FeatureUtils.createFeatureCollection((URL)shapefileUrl, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (Geometry)clipGeometry);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return new FeatureLayer(layerType, fc, configuration);
    }

    private static Style createStyle() {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
        PolygonSymbolizer symbolizer = styleFactory.createPolygonSymbolizer();
        org.geotools.styling.Fill fill = styleFactory.createFill((Expression)filterFactory.literal((Object)"#FFAA00"), (Expression)filterFactory.literal(0.5));
        symbolizer.setFill((Fill)fill);
        Rule rule = styleFactory.createRule();
        rule.setSymbolizers(new Symbolizer[]{symbolizer});
        FeatureTypeStyle fts = styleFactory.createFeatureTypeStyle();
        fts.setRules(new Rule[]{rule});
        Style style = styleFactory.createStyle();
        style.addFeatureTypeStyle(fts);
        return style;
    }
}

