/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.session.dom;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.dom.DefaultDomElement;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerType;
import java.io.File;
import java.lang.reflect.Array;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.rcp.session.dom.SessionDomConverter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AbstractLayerConfigurationPersistencyTest {
    private static ProductManager productManager;
    private final LayerType layerType;

    protected AbstractLayerConfigurationPersistencyTest(LayerType layerType) {
        Assert.assertNotNull((Object)layerType);
        this.layerType = layerType;
    }

    @BeforeClass
    public static void setupClass() {
        Product product = AbstractLayerConfigurationPersistencyTest.createTestProduct("P", "T");
        AbstractLayerConfigurationPersistencyTest.addVirtualBand(product, "V", 12, "42");
        productManager = new ProductManager();
        productManager.addProduct(product);
    }

    protected static ProductManager getProductManager() {
        return productManager;
    }

    protected static Product createTestProduct(String name, String type) {
        Product product = new Product(name, type, 10, 10);
        product.setFileLocation(new File(String.format("out/%s.dim", name)));
        return product;
    }

    protected static RasterDataNode addVirtualBand(Product product, String bandName, int dataType, String expression) {
        VirtualBand band = new VirtualBand(bandName, dataType, 10, 10, expression);
        product.addBand((Band)band);
        return band;
    }

    @Test
    public void testLayerConfigurationPersistency() throws Exception {
        Layer layer = this.createLayer(this.layerType);
        SessionDomConverter domConverter = new SessionDomConverter(AbstractLayerConfigurationPersistencyTest.getProductManager());
        DefaultDomElement originalDomElement = new DefaultDomElement("configuration");
        domConverter.convertValueToDom((Object)layer.getConfiguration(), (DomElement)originalDomElement);
        PropertySet template = layer.getLayerType().createLayerConfig(null);
        PropertyContainer restoredConfiguration = (PropertyContainer)domConverter.convertDomToValue((DomElement)originalDomElement, (Object)template);
        AbstractLayerConfigurationPersistencyTest.compareConfigurations(layer.getConfiguration(), (PropertySet)restoredConfiguration);
        DefaultDomElement restoredDomElement = new DefaultDomElement("configuration");
        domConverter.convertValueToDom((Object)restoredConfiguration, (DomElement)restoredDomElement);
    }

    protected abstract Layer createLayer(LayerType var1) throws Exception;

    private static void compareConfigurations(PropertySet originalConfiguration, PropertySet restoredConfiguration) {
        for (Property originalModel : originalConfiguration.getProperties()) {
            PropertyDescriptor originalDescriptor = originalModel.getDescriptor();
            Property restoredModel = restoredConfiguration.getProperty(originalDescriptor.getName());
            PropertyDescriptor restoredDescriptor = restoredModel.getDescriptor();
            Assert.assertNotNull((Object)restoredModel);
            junit.framework.Assert.assertSame((Object)originalDescriptor.getName(), (Object)restoredDescriptor.getName());
            junit.framework.Assert.assertSame((Object)originalDescriptor.getType(), (Object)restoredDescriptor.getType());
            if (originalDescriptor.isTransient()) {
                junit.framework.Assert.assertEquals((boolean)originalDescriptor.isTransient(), (boolean)restoredDescriptor.isTransient());
                continue;
            }
            Object originalValue = originalModel.getValue();
            Object restoredValue = restoredModel.getValue();
            junit.framework.Assert.assertSame(originalValue.getClass(), restoredValue.getClass());
            if (!originalValue.getClass().isArray()) continue;
            int originalLength = Array.getLength(originalValue);
            int restoredLength = Array.getLength(restoredValue);
            junit.framework.Assert.assertEquals((int)originalLength, (int)restoredLength);
            for (int i = 0; i < restoredLength; ++i) {
                junit.framework.Assert.assertEquals((Object)Array.get(originalValue, i), (Object)Array.get(restoredValue, i));
            }
        }
    }
}

