/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.scripting;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.snap.rcp.scripting.SnapUtils;
import org.esa.snap.rcp.scripting.TransientAction;
import org.junit.Assert;
import org.junit.Test;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SnapUtilsTest {
    @Test
    public void testAddRemoveAction() throws Exception {
        AbstractAction realAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        FileObject actionFile = SnapUtils.addAction((Action)realAction, (String)"Test/Action");
        Assert.assertNotNull((Object)actionFile);
        Assert.assertNotNull((Object)actionFile.getParent());
        Assert.assertEquals((Object)"application/x-nbsettings", (Object)actionFile.getMIMEType());
        Assert.assertEquals((Object)"Test/Action", (Object)actionFile.getParent().getPath());
        Assert.assertEquals((Object)"instance", (Object)actionFile.getExt());
        Action action = (Action)FileUtil.getConfigObject((String)actionFile.getPath(), Action.class);
        Assert.assertNotNull((Object)action);
        Assert.assertEquals(TransientAction.class, action.getClass());
        Assert.assertSame((Object)realAction, (Object)((TransientAction)action).getDelegate());
        boolean ok = SnapUtils.removeAction((FileObject)actionFile);
        Assert.assertEquals((Object)true, (Object)ok);
        action = (Action)FileUtil.getConfigObject((String)actionFile.getPath(), Action.class);
        Assert.assertNull((Object)action);
    }

    @Test
    public void testAddRemoveActionReference() throws Exception {
        AbstractAction realAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        FileObject actionFile = SnapUtils.addAction((Action)realAction, (String)"Test/Action");
        FileObject actionRef1File = SnapUtils.addActionReference((FileObject)actionFile, (String)"Test/Refs1", (Integer)10);
        Assert.assertNotNull((Object)actionRef1File);
        Assert.assertNotNull((Object)actionRef1File.getParent());
        Assert.assertEquals((Object)"Test/Refs1", (Object)actionRef1File.getParent().getPath());
        Assert.assertEquals((Object)"shadow", (Object)actionRef1File.getExt());
        Assert.assertEquals((Object)"content/unknown", (Object)actionRef1File.getMIMEType());
        Action refAction = (Action)FileUtil.getConfigObject((String)actionRef1File.getPath(), Action.class);
        Assert.assertNotNull((Object)refAction);
        Assert.assertEquals(TransientAction.class, refAction.getClass());
        Assert.assertSame((Object)realAction, (Object)((TransientAction)refAction).getDelegate());
        boolean ok = SnapUtils.removeActionReference((FileObject)actionFile);
        Assert.assertEquals((Object)false, (Object)ok);
        ok = SnapUtils.removeActionReference((FileObject)actionRef1File);
        Assert.assertEquals((Object)true, (Object)ok);
        refAction = (Action)FileUtil.getConfigObject((String)actionRef1File.getPath(), Action.class);
        Assert.assertNull((Object)refAction);
    }
}

