/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.placemark;

import java.awt.HeadlessException;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PinDescriptor;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.rcp.placemark.PlacemarkDialog;
import org.junit.Assert;
import org.junit.Test;

public class PlacemarkDialogTest {
    @Test
    public void test() {
        try {
            PlacemarkDialog pinDialog = new PlacemarkDialog(null, new Product("x", "y", 10, 10), (PlacemarkDescriptor)PinDescriptor.getInstance(), false);
            pinDialog.setDescription("descrip");
            Assert.assertEquals((Object)"descrip", (Object)pinDialog.getDescription());
            pinDialog.setLat((double)3.6f);
            Assert.assertEquals((double)3.6f, (double)pinDialog.getLat(), (double)1.0E-15);
            pinDialog.setLon((double)5.7f);
            Assert.assertEquals((double)5.7f, (double)pinDialog.getLon(), (double)1.0E-15);
            GeoPos geoPos = pinDialog.getGeoPos();
            Assert.assertNotNull((Object)geoPos);
            Assert.assertEquals((double)3.6f, (double)geoPos.lat, (double)1.0E-6f);
            Assert.assertEquals((double)5.7f, (double)geoPos.lon, (double)1.0E-6f);
            pinDialog.setName("name");
            Assert.assertEquals((Object)"name", (Object)pinDialog.getName());
            pinDialog.setLabel("label");
            Assert.assertEquals((Object)"label", (Object)pinDialog.getLabel());
            pinDialog.setPixelX((double)2.3f);
            Assert.assertEquals((double)2.3f, (double)pinDialog.getPixelX(), (double)1.0E-6f);
            pinDialog.setPixelY((double)14.1f);
            Assert.assertEquals((double)14.1f, (double)pinDialog.getPixelY(), (double)1.0E-6f);
            PixelPos pixelPos = pinDialog.getPixelPos();
            Assert.assertNotNull((Object)pixelPos);
            Assert.assertEquals((double)2.3f, (double)pixelPos.x, (double)1.0E-6f);
            Assert.assertEquals((double)14.1f, (double)pixelPos.y, (double)1.0E-6f);
        }
        catch (HeadlessException e) {
            System.out.println("A " + PlacemarkDialogTest.class + " test has not been performed: HeadlessException");
        }
    }
}

