/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.nodes;

import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.rcp.nodes.PNode;
import org.esa.snap.rcp.nodes.ProductGroupNode;
import org.esa.snap.rcp.util.TestProducts;
import org.junit.Assert;
import org.junit.Test;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class ProductGroupNodeTest {
    @Test
    public void testDefaultTree() throws Exception {
        ProductManager productManager = new ProductManager();
        ProductGroupNode rootNode = new ProductGroupNode(productManager);
        Product product1 = TestProducts.createProduct1();
        productManager.addProduct(product1);
        Assert.assertEquals((long)1L, (long)rootNode.getChildren().getNodesCount());
        Assert.assertEquals(PNode.class, rootNode.getChildren().getNodeAt(0).getClass());
        PNode pNode = (PNode)rootNode.getChildren().getNodeAt(0);
        Assert.assertSame((Object)product1, (Object)pNode.getProduct());
        Assert.assertEquals((Object)"[1] Test_Product_1", (Object)pNode.getDisplayName());
        Children children = pNode.getChildren();
        Assert.assertNotNull((Object)children);
        Node[] groupNodes = children.getNodes();
        Assert.assertNotNull((Object)groupNodes);
        Assert.assertEquals((long)5L, (long)groupNodes.length);
        Assert.assertEquals((Object)"Metadata", (Object)groupNodes[0].getDisplayName());
        Assert.assertEquals((Object)"Vector Data", (Object)groupNodes[1].getDisplayName());
        Assert.assertEquals((Object)"Tie-Point Grids", (Object)groupNodes[2].getDisplayName());
        Assert.assertEquals((Object)"Bands", (Object)groupNodes[3].getDisplayName());
        Assert.assertEquals((Object)"Masks", (Object)groupNodes[4].getDisplayName());
        for (Node groupNode : groupNodes) {
            Assert.assertTrue((boolean)(groupNode instanceof UndoRedo.Provider));
        }
    }
}

