/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.mask;

import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.ProductNodeListener;
import org.esa.snap.core.datamodel.ProductNodeListenerAdapter;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.rcp.mask.MaskFormTest;
import org.esa.snap.rcp.mask.MaskManagerForm;
import org.esa.snap.rcp.mask.MaskViewerForm;
import org.esa.snap.ui.GridLayout2;
import org.junit.Ignore;
import org.junit.Test;

public class MaskApplicationTest {
    private final Product product = MaskFormTest.createTestProduct();
    private final MaskManagerForm maskManagerForm;
    private final MaskViewerForm maskViewerForm;
    private Product selectedProduct;
    private RasterDataNode selectedBand;

    @Ignore
    @Test
    public void testNothing() {
    }

    public MaskApplicationTest() {
        this.product.addProductNodeListener((ProductNodeListener)new ProductNodeListenerAdapter(){

            public void nodeChanged(ProductNodeEvent event) {
                System.out.println("event = " + event);
            }

            public void nodeDataChanged(ProductNodeEvent event) {
                System.out.println("event = " + event);
            }

            public void nodeAdded(ProductNodeEvent event) {
                System.out.println("event = " + event);
            }

            public void nodeRemoved(ProductNodeEvent event) {
                System.out.println("event = " + event);
            }
        });
        this.selectedProduct = null;
        this.selectedBand = null;
        this.maskManagerForm = new MaskManagerForm(null, null);
        this.maskManagerForm.reconfigureMaskTable(this.selectedProduct, this.selectedBand);
        this.maskViewerForm = new MaskViewerForm(null);
        this.maskViewerForm.reconfigureMaskTable(this.selectedProduct, this.selectedBand);
    }

    public static void main(String[] args) {
        Locale.setDefault(Locale.UK);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        MaskApplicationTest app = new MaskApplicationTest();
        final JFrame maskManagerFrame = MaskApplicationTest.createFrame("ROI/Mask Manager", app.maskManagerForm.createContentPanel());
        final JFrame maskViewerFrame = MaskApplicationTest.createFrame("Bitmask Overlay", app.maskViewerForm.createContentPanel());
        final JFrame productManagerFrame = MaskApplicationTest.createFrame("Product Manager", MaskApplicationTest.createProductManagerPanel(app));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                maskManagerFrame.setLocation(50, 50);
                maskViewerFrame.setLocation(maskManagerFrame.getX() + maskManagerFrame.getWidth(), 50);
                productManagerFrame.setLocation(maskViewerFrame.getX() + maskViewerFrame.getWidth(), 50);
                maskManagerFrame.setVisible(true);
                maskViewerFrame.setVisible(true);
                productManagerFrame.setVisible(true);
            }
        });
    }

    private static JFrame createFrame(String name, JPanel panel) {
        JFrame frame = new JFrame(name);
        frame.setDefaultCloseOperation(3);
        frame.add(panel);
        frame.setAlwaysOnTop(true);
        frame.pack();
        return frame;
    }

    private static JPanel createProductManagerPanel(final MaskApplicationTest app) {
        String[] bandNames;
        JPanel panel = new JPanel((LayoutManager)new GridLayout2(-1, 1, 2, 2));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        panel.add(new JButton(new AbstractAction("Select product"){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.selectProduct(app.product);
            }
        }));
        panel.add(new JButton(new AbstractAction("Unselect product"){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.selectProduct(null);
            }
        }));
        for (String bandName : bandNames = app.product.getBandNames()) {
            AbstractAction action = new AbstractAction("Select band '" + bandName + "'"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    app.selectBand((RasterDataNode)app.product.getBand((String)this.getValue("bandName")));
                }
            };
            action.putValue("bandName", bandName);
            panel.add(new JButton(action));
        }
        panel.add(new JButton(new AbstractAction("Unselect band"){

            @Override
            public void actionPerformed(ActionEvent e) {
                app.selectBand(null);
            }
        }));
        return panel;
    }

    void selectProduct(Product product) {
        this.selectedProduct = product;
        this.selectedBand = null;
        this.handleSelectionStateChange();
    }

    void selectBand(RasterDataNode band) {
        if (band != null) {
            this.selectedProduct = band.getProduct();
        }
        this.selectedBand = band;
        this.handleSelectionStateChange();
    }

    private void handleSelectionStateChange() {
        this.maskManagerForm.reconfigureMaskTable(this.selectedProduct, this.selectedBand);
        this.maskViewerForm.reconfigureMaskTable(this.selectedProduct, this.selectedBand);
    }
}

