/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager.layersrc;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.esa.snap.rcp.layermanager.layersrc.HistoryComboBoxModel;
import org.esa.snap.ui.UserInputHistory;
import org.junit.Assert;
import org.junit.Test;

public class HistoryComboBoxModelTest {
    @Test
    public void testAddElement() {
        HistoryComboBoxModel model = new HistoryComboBoxModel(new UserInputHistory(3, "historyItem"));
        Assert.assertEquals((long)0L, (long)model.getSize());
        model.setSelectedItem((Object)"one");
        Assert.assertEquals((long)1L, (long)model.getSize());
        model.setSelectedItem((Object)"two");
        model.setSelectedItem((Object)"three");
        Assert.assertEquals((long)3L, (long)model.getSize());
        Assert.assertEquals((Object)"three", (Object)model.getElementAt(0));
        Assert.assertEquals((Object)"two", (Object)model.getElementAt(1));
        Assert.assertEquals((Object)"one", (Object)model.getElementAt(2));
        model.setSelectedItem((Object)"four");
        Assert.assertEquals((long)3L, (long)model.getSize());
        Assert.assertEquals((Object)"four", (Object)model.getElementAt(0));
        Assert.assertEquals((Object)"three", (Object)model.getElementAt(1));
        Assert.assertEquals((Object)"two", (Object)model.getElementAt(2));
        model.setSelectedItem((Object)"five");
        Assert.assertEquals((long)3L, (long)model.getSize());
        Assert.assertEquals((Object)"five", (Object)model.getElementAt(0));
        Assert.assertEquals((Object)"four", (Object)model.getElementAt(1));
        Assert.assertEquals((Object)"three", (Object)model.getElementAt(2));
    }

    @Test
    public void testAddElementWithInnitilaizedProperties() {
        DummyPreferences preferences = new DummyPreferences();
        ((Preferences)preferences).put("historyItem.0", "one");
        ((Preferences)preferences).put("historyItem.1", "two");
        UserInputHistory history = new UserInputHistory(3, "historyItem");
        history.initBy((Preferences)preferences);
        HistoryComboBoxModel model = new HistoryComboBoxModel(history);
        Assert.assertEquals((long)2L, (long)model.getSize());
        Assert.assertEquals((Object)"one", (Object)model.getElementAt(0));
        Assert.assertEquals((Object)"two", (Object)model.getElementAt(1));
        model.setSelectedItem((Object)"three");
        Assert.assertEquals((long)3L, (long)model.getSize());
        Assert.assertEquals((Object)"three", (Object)model.getElementAt(0));
        Assert.assertEquals((Object)"one", (Object)model.getElementAt(1));
        Assert.assertEquals((Object)"two", (Object)model.getElementAt(2));
        model.setSelectedItem((Object)"four");
        Assert.assertEquals((long)3L, (long)model.getSize());
        Assert.assertEquals((Object)"four", (Object)model.getElementAt(0));
        Assert.assertEquals((Object)"three", (Object)model.getElementAt(1));
        Assert.assertEquals((Object)"one", (Object)model.getElementAt(2));
    }

    @Test
    public void testValidation() {
        DummyPreferences preferences = new DummyPreferences();
        ((Preferences)preferences).put("historyItem.0", "one");
        ((Preferences)preferences).put("historyItem.1", "two");
        ((Preferences)preferences).put("historyItem.2", "three");
        UserInputHistory history = new UserInputHistory(3, "historyItem"){

            protected boolean isValidItem(String item) {
                return "two".equals(item);
            }
        };
        history.initBy((Preferences)preferences);
        HistoryComboBoxModel model = new HistoryComboBoxModel(history);
        Assert.assertEquals((long)1L, (long)model.getSize());
        Assert.assertEquals((Object)"two", (Object)model.getElementAt(0));
    }

    @Test
    public void testSetSelected() {
        DummyPreferences preferences = new DummyPreferences();
        ((Preferences)preferences).put("historyItem.0", "one");
        ((Preferences)preferences).put("historyItem.1", "two");
        UserInputHistory history = new UserInputHistory(3, "historyItem");
        history.initBy((Preferences)preferences);
        HistoryComboBoxModel model = new HistoryComboBoxModel(history);
        Assert.assertEquals((long)2L, (long)model.getSize());
        Assert.assertEquals((Object)"one", (Object)model.getElementAt(0));
        Assert.assertEquals((Object)"two", (Object)model.getElementAt(1));
        model.setSelectedItem((Object)"two");
        Assert.assertEquals((long)2L, (long)model.getSize());
        Assert.assertEquals((Object)"two", (Object)model.getElementAt(0));
        Assert.assertEquals((Object)"one", (Object)model.getElementAt(1));
        model.setSelectedItem((Object)"three");
        Assert.assertEquals((long)3L, (long)model.getSize());
        Assert.assertEquals((Object)"three", (Object)model.getElementAt(0));
        Assert.assertEquals((Object)"two", (Object)model.getElementAt(1));
        Assert.assertEquals((Object)"one", (Object)model.getElementAt(2));
        model.setSelectedItem((Object)"one");
        Assert.assertEquals((long)3L, (long)model.getSize());
        Assert.assertEquals((Object)"one", (Object)model.getElementAt(0));
        Assert.assertEquals((Object)"three", (Object)model.getElementAt(1));
        Assert.assertEquals((Object)"two", (Object)model.getElementAt(2));
        model.setSelectedItem((Object)"four");
        Assert.assertEquals((long)3L, (long)model.getSize());
        Assert.assertEquals((Object)"four", (Object)model.getElementAt(0));
        Assert.assertEquals((Object)"one", (Object)model.getElementAt(1));
        Assert.assertEquals((Object)"three", (Object)model.getElementAt(2));
    }

    @Test
    public void testSetSelectedOnEmptyHistory() {
        HistoryComboBoxModel model = new HistoryComboBoxModel(new UserInputHistory(3, "historyItem"));
        Assert.assertEquals((long)0L, (long)model.getSize());
        model.setSelectedItem((Object)"one");
        Assert.assertEquals((long)1L, (long)model.getSize());
        Assert.assertEquals((Object)"one", (Object)model.getElementAt(0));
        model.setSelectedItem((Object)"two");
        Assert.assertEquals((long)2L, (long)model.getSize());
        Assert.assertEquals((Object)"two", (Object)model.getElementAt(0));
        Assert.assertEquals((Object)"one", (Object)model.getElementAt(1));
    }

    @Test
    public void testLoadHistory() {
        DummyPreferences preferences = new DummyPreferences();
        ((Preferences)preferences).put("historyItem.0", "one");
        UserInputHistory history = new UserInputHistory(3, "historyItem");
        history.initBy((Preferences)preferences);
        HistoryComboBoxModel model = new HistoryComboBoxModel(history);
        Assert.assertEquals((long)1L, (long)model.getSize());
        ((Preferences)preferences).put("historyItem.1", "two");
        ((Preferences)preferences).put("historyItem.2", "three");
        model.getHistory().initBy((Preferences)preferences);
        Assert.assertEquals((long)3L, (long)model.getSize());
        Assert.assertEquals((Object)"one", (Object)model.getElementAt(0));
        Assert.assertEquals((Object)"two", (Object)model.getElementAt(1));
        Assert.assertEquals((Object)"three", (Object)model.getElementAt(2));
    }

    @Test
    public void testLoadHistoryOverwritesCurrentModel() {
        DummyPreferences preferences = new DummyPreferences();
        ((Preferences)preferences).put("historyItem.0", "one");
        UserInputHistory history = new UserInputHistory(3, "historyItem");
        history.initBy((Preferences)preferences);
        HistoryComboBoxModel model = new HistoryComboBoxModel(history);
        Assert.assertEquals((long)1L, (long)model.getSize());
        model.setSelectedItem((Object)"two");
        model.setSelectedItem((Object)"three");
        Assert.assertEquals((long)3L, (long)model.getSize());
        ((Preferences)preferences).put("historyItem.1", "two2");
        ((Preferences)preferences).put("historyItem.2", "three3");
        model.getHistory().initBy((Preferences)preferences);
        Assert.assertEquals((long)3L, (long)model.getSize());
        Assert.assertEquals((Object)"one", (Object)model.getElementAt(0));
        Assert.assertEquals((Object)"two2", (Object)model.getElementAt(1));
        Assert.assertEquals((Object)"three3", (Object)model.getElementAt(2));
    }

    @Test
    public void testSaveHistory() {
        HistoryComboBoxModel model = new HistoryComboBoxModel(new UserInputHistory(3, "historyItem"));
        model.setSelectedItem((Object)"one");
        model.setSelectedItem((Object)"two");
        DummyPreferences preferences = new DummyPreferences();
        model.getHistory().copyInto((Preferences)preferences);
        Assert.assertEquals((Object)"two", (Object)((Preferences)preferences).get("historyItem.0", ""));
        Assert.assertEquals((Object)"one", (Object)((Preferences)preferences).get("historyItem.1", ""));
        Assert.assertEquals((Object)"", (Object)((Preferences)preferences).get("historyItem.2", ""));
        model.setSelectedItem((Object)"three");
        model.getHistory().copyInto((Preferences)preferences);
        Assert.assertEquals((Object)"three", (Object)((Preferences)preferences).get("historyItem.0", ""));
        Assert.assertEquals((Object)"two", (Object)((Preferences)preferences).get("historyItem.1", ""));
        Assert.assertEquals((Object)"one", (Object)((Preferences)preferences).get("historyItem.2", ""));
    }

    private class DummyPreferences
    extends Preferences {
        Map<String, Object> propertyMap = new HashMap<String, Object>();

        DummyPreferences() {
        }

        @Override
        public void put(String key, String value) {
            this.propertyMap.put(key, value);
        }

        @Override
        public String get(String key, String def) {
            Object value = this.propertyMap.get(key);
            if (value != null) {
                return value.toString();
            }
            return def;
        }

        @Override
        public void remove(String key) {
        }

        @Override
        public void clear() throws BackingStoreException {
        }

        @Override
        public void putInt(String key, int value) {
            this.propertyMap.put(key, value);
        }

        @Override
        public int getInt(String key, int def) {
            Object value = this.propertyMap.get(key);
            if (value != null) {
                return Integer.parseInt(value.toString());
            }
            return def;
        }

        @Override
        public void putLong(String key, long value) {
        }

        @Override
        public long getLong(String key, long def) {
            return 0L;
        }

        @Override
        public void putBoolean(String key, boolean value) {
        }

        @Override
        public boolean getBoolean(String key, boolean def) {
            return false;
        }

        @Override
        public void putFloat(String key, float value) {
        }

        @Override
        public float getFloat(String key, float def) {
            return 0.0f;
        }

        @Override
        public void putDouble(String key, double value) {
        }

        @Override
        public double getDouble(String key, double def) {
            return 0.0;
        }

        @Override
        public void putByteArray(String key, byte[] value) {
        }

        @Override
        public byte[] getByteArray(String key, byte[] def) {
            return new byte[0];
        }

        @Override
        public String[] keys() throws BackingStoreException {
            return new String[0];
        }

        @Override
        public String[] childrenNames() throws BackingStoreException {
            return new String[0];
        }

        @Override
        public Preferences parent() {
            return null;
        }

        @Override
        public Preferences node(String pathName) {
            return null;
        }

        @Override
        public boolean nodeExists(String pathName) throws BackingStoreException {
            return false;
        }

        @Override
        public void removeNode() throws BackingStoreException {
        }

        @Override
        public String name() {
            return null;
        }

        @Override
        public String absolutePath() {
            return null;
        }

        @Override
        public boolean isUserNode() {
            return false;
        }

        @Override
        public String toString() {
            return null;
        }

        @Override
        public void flush() throws BackingStoreException {
        }

        @Override
        public void sync() throws BackingStoreException {
        }

        @Override
        public void addPreferenceChangeListener(PreferenceChangeListener pcl) {
        }

        @Override
        public void removePreferenceChangeListener(PreferenceChangeListener pcl) {
        }

        @Override
        public void addNodeChangeListener(NodeChangeListener ncl) {
        }

        @Override
        public void removeNodeChangeListener(NodeChangeListener ncl) {
        }

        @Override
        public void exportNode(OutputStream os) throws IOException, BackingStoreException {
        }

        @Override
        public void exportSubtree(OutputStream os) throws IOException, BackingStoreException {
        }
    }
}

