/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.layermanager;

import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.support.LayerUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.esa.snap.rcp.layermanager.LayerTreeModel;
import org.junit.Assert;
import org.junit.Test;

public class LayerTreeModelTest {
    @Test
    public void testIt() {
        CollectionLayer layer0 = new CollectionLayer();
        CollectionLayer layer1 = new CollectionLayer();
        CollectionLayer layer2 = new CollectionLayer();
        CollectionLayer layer3 = new CollectionLayer();
        layer0.getChildren().add(layer1);
        layer0.getChildren().add(layer2);
        layer0.getChildren().add(layer3);
        CollectionLayer layer4 = new CollectionLayer();
        CollectionLayer layer5 = new CollectionLayer();
        layer3.getChildren().add(layer4);
        layer3.getChildren().add(layer5);
        LayerTreeModel treeModel = new LayerTreeModel((Layer)layer0);
        Assert.assertSame((Object)layer0, (Object)treeModel.getRoot());
        Layer[] path = LayerUtils.getLayerPath((Layer)layer0, (Layer)layer0);
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((long)1L, (long)path.length);
        Assert.assertSame((Object)layer0, (Object)path[0]);
        path = LayerUtils.getLayerPath((Layer)layer3, (Layer)layer4);
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((long)2L, (long)path.length);
        Assert.assertSame((Object)layer3, (Object)path[0]);
        Assert.assertSame((Object)layer4, (Object)path[1]);
        path = LayerUtils.getLayerPath((Layer)layer0, (Layer)layer4);
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((long)3L, (long)path.length);
        Assert.assertSame((Object)layer0, (Object)path[0]);
        Assert.assertSame((Object)layer3, (Object)path[1]);
        Assert.assertSame((Object)layer4, (Object)path[2]);
        path = LayerUtils.getLayerPath((Layer)layer4, (Layer)layer3);
        Assert.assertNotNull((Object)path);
        Assert.assertEquals((long)0L, (long)path.length);
        Assert.assertEquals((long)3L, (long)treeModel.getChildCount((Object)layer0));
        Assert.assertSame((Object)layer1, (Object)treeModel.getChild((Object)layer0, 0));
        Assert.assertSame((Object)layer2, (Object)treeModel.getChild((Object)layer0, 1));
        Assert.assertSame((Object)layer3, (Object)treeModel.getChild((Object)layer0, 2));
        Assert.assertEquals((long)0L, (long)treeModel.getChildCount((Object)layer1));
        Assert.assertEquals((long)0L, (long)treeModel.getChildCount((Object)layer2));
        Assert.assertEquals((long)2L, (long)treeModel.getChildCount((Object)layer3));
        Assert.assertSame((Object)layer4, (Object)treeModel.getChild((Object)layer3, 0));
        Assert.assertSame((Object)layer5, (Object)treeModel.getChild((Object)layer3, 1));
        MyTreeModelListener listener = new MyTreeModelListener();
        treeModel.addTreeModelListener((TreeModelListener)listener);
        List children = layer3.getChildren();
        children.remove(layer4);
        try {
            SwingUtilities.invokeAndWait(() -> Assert.assertEquals((Object)"treeStructureChanged;", (Object)listener.trace));
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    private static class MyTreeModelListener
    implements TreeModelListener {
        String trace = "";
        TreeModelEvent e;

        private MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.trace = this.trace + "treeNodesChanged;";
            this.e = e;
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.trace = this.trace + "treeNodesInserted;";
            this.e = e;
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.trace = this.trace + "treeNodesRemoved;";
            this.e = e;
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.trace = this.trace + "treeStructureChanged;";
            this.e = e;
        }
    }
}

