/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.vector;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.InputStreamReader;
import java.io.Reader;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.rcp.actions.vector.ImportTrackAction;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ImportTrackActionTest {
    @Test
    public void testReadTrack() throws Exception {
        CrsGeoCoding geoCoding = new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, new Rectangle(360, 180), new AffineTransform());
        InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("TrackData.csv"));
        FeatureCollection featureCollection = ImportTrackAction.readTrack((Reader)reader, (GeoCoding)geoCoding);
        Assert.assertNotNull((Object)featureCollection);
        Assert.assertEquals((long)23L, (long)featureCollection.size());
        SimpleFeature[] simpleFeatures = (SimpleFeature[])featureCollection.toArray((Object[])new SimpleFeature[0]);
        Assert.assertEquals((long)23L, (long)simpleFeatures.length);
        Assert.assertEquals((Object)"ID00000000", (Object)simpleFeatures[0].getID());
        Assert.assertEquals((Object)"ID00000011", (Object)simpleFeatures[11].getID());
        Assert.assertEquals((Object)"ID00000022", (Object)simpleFeatures[22].getID());
    }
}

