/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import org.esa.snap.rcp.actions.file.RecentPaths;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RecentPathsTest {
    private RecentPaths recentPaths;

    @Before
    public void setUp() throws Exception {
        Preferences preferences = Preferences.userNodeForPackage(RecentPathsTest.class).node("test");
        preferences.remove("recents");
        this.recentPaths = new RecentPaths(Preferences.userNodeForPackage(RecentPathsTest.class).node("test"), "recents", false);
    }

    @Test
    public void testEmpty() throws Exception {
        List paths = this.recentPaths.get();
        Assert.assertNotNull((Object)paths);
        Assert.assertTrue((boolean)paths.isEmpty());
    }

    @Test
    public void testLastInIsFirstOut() throws Exception {
        this.recentPaths.add("a");
        this.recentPaths.add("b");
        this.recentPaths.add("c");
        Assert.assertEquals(Arrays.asList("c", "b", "a"), (Object)this.recentPaths.get());
    }

    @Test
    public void testEmptyEntriesAreNotAdded() throws Exception {
        this.recentPaths.add("a");
        this.recentPaths.add("");
        this.recentPaths.add("c");
        Assert.assertEquals(Arrays.asList("c", "a"), (Object)this.recentPaths.get());
    }

    @Test
    public void testEqualEntriesAreRemoved() throws Exception {
        this.recentPaths.add("a");
        this.recentPaths.add("b");
        this.recentPaths.add("a");
        this.recentPaths.add("a");
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)this.recentPaths.get());
    }
}

