/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.rcp.actions;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.Action;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.raster.rcp.actions.Bundle;
import org.esa.snap.rcp.actions.AbstractSnapAction;
import org.esa.snap.rcp.util.Dialogs;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ComplexToPhaseAction
extends AbstractSnapAction
implements ContextAwareAction,
LookupListener {
    private final Lookup lkp;

    public ComplexToPhaseAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ComplexToPhaseAction(Lookup lkp) {
        this.lkp = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), (Object)lkpContext));
        this.setEnableState();
        this.putValue("Name", Bundle.CTL_ComplexToPhaseAction_Text());
        this.putValue("ShortDescription", Bundle.CTL_ComplexToPhaseAction_Description());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ComplexToPhaseAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    public void actionPerformed(ActionEvent event) {
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        if (productNode != null && productNode instanceof Band) {
            String phaseBandName;
            String qBandName;
            String iBandName;
            Band band = (Band)productNode;
            Product product = band.getProduct();
            String bandName = band.getName();
            String unit = band.getUnit();
            if (unit != null && unit.contains("real")) {
                iBandName = bandName;
                qBandName = bandName.replaceFirst("i_", "q_");
                phaseBandName = bandName.replaceFirst("i_", "Phase_");
            } else if (unit != null && unit.contains("imaginary")) {
                iBandName = bandName.replaceFirst("q_", "i_");
                qBandName = bandName;
                phaseBandName = bandName.replaceFirst("q_", "Phase_");
            } else {
                return;
            }
            if (product.getBand(iBandName) == null) {
                Dialogs.showWarning((String)(product.getName() + " missing " + iBandName + " band"));
                return;
            }
            if (product.getBand(qBandName) == null) {
                Dialogs.showWarning((String)(product.getName() + " missing " + qBandName + " band"));
                return;
            }
            if (product.getBand(phaseBandName) != null) {
                Dialogs.showWarning((String)(product.getName() + " already contains a " + phaseBandName + " band"));
                return;
            }
            if (Dialogs.requestDecision((String)"Convert to Phase", (String)"Would you like to convert i and q bands  to Phase in a new virtual band?", (boolean)true, null) == Dialogs.Answer.YES) {
                ComplexToPhaseAction.convert(product, iBandName, qBandName, phaseBandName);
            }
        }
    }

    public void setEnableState() {
        Band band;
        String unit;
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        if (productNode != null && productNode instanceof Band && (unit = (band = (Band)productNode).getUnit()) != null && (unit.contains("real") || unit.contains("imaginary"))) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public static void convert(Product product, String iBandName, String qBandName, String phaseBandName) {
        Band iBand = product.getBand(iBandName);
        String expression = "atan2(" + qBandName + ',' + iBandName + ')';
        VirtualBand virtBand = new VirtualBand(phaseBandName, 30, iBand.getRasterWidth(), iBand.getRasterHeight(), expression);
        virtBand.setUnit("phase");
        virtBand.setDescription("Phase from complex data");
        virtBand.setNoDataValueUsed(true);
        virtBand.setOwner((ProductNode)product);
        product.addBand((Band)virtBand);
    }
}

