/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.rcp.actions;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.Action;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.raster.rcp.actions.Bundle;
import org.esa.snap.rcp.actions.AbstractSnapAction;
import org.esa.snap.rcp.util.Dialogs;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ComplexToIntensityAction
extends AbstractSnapAction
implements ContextAwareAction,
LookupListener {
    private final Lookup lkp;

    public ComplexToIntensityAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ComplexToIntensityAction(Lookup lkp) {
        this.lkp = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), (Object)lkpContext));
        this.setEnableState();
        this.putValue("Name", Bundle.CTL_ComplexToIntensityAction_Text());
        this.putValue("ShortDescription", Bundle.CTL_ComplexToIntensityAction_Description());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ComplexToIntensityAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    public void actionPerformed(ActionEvent event) {
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        if (productNode != null && productNode instanceof Band) {
            String intensityBandName;
            String qBandName;
            String iBandName;
            Band band = (Band)productNode;
            Product product = band.getProduct();
            String bandName = band.getName();
            String unit = band.getUnit();
            if (unit != null && unit.contains("real")) {
                iBandName = bandName;
                qBandName = bandName.replaceFirst("i_", "q_");
                intensityBandName = bandName.replaceFirst("i_", "Intensity_");
            } else if (unit != null && unit.contains("imaginary")) {
                iBandName = bandName.replaceFirst("q_", "i_");
                qBandName = bandName;
                intensityBandName = bandName.replaceFirst("q_", "Intensity_");
            } else {
                return;
            }
            if (product.getBand(iBandName) == null) {
                Dialogs.showWarning((String)(product.getName() + " missing " + iBandName + " band"));
                return;
            }
            if (product.getBand(qBandName) == null) {
                Dialogs.showWarning((String)(product.getName() + " missing " + qBandName + " band"));
                return;
            }
            if (product.getBand(intensityBandName) != null) {
                Dialogs.showWarning((String)(product.getName() + " already contains a " + intensityBandName + " band"));
                return;
            }
            if (Dialogs.requestDecision((String)"Convert to Intensity", (String)"Would you like to convert i and q bands  to Intensity in a new virtual band?", (boolean)true, null) == Dialogs.Answer.YES) {
                ComplexToIntensityAction.convert(product, iBandName, qBandName, intensityBandName);
            }
        }
    }

    public void setEnableState() {
        Band band;
        String unit;
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        if (productNode != null && productNode instanceof Band && (unit = (band = (Band)productNode).getUnit()) != null && (unit.contains("real") || unit.contains("imaginary"))) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public static void convert(Product product, String iBandName, String qBandName, String targetBandName) {
        Band iBand = product.getBand(iBandName);
        String expression = iBandName + " * " + iBandName + " + " + qBandName + " * " + qBandName;
        VirtualBand virtBand = new VirtualBand(targetBandName, 30, iBand.getRasterWidth(), iBand.getRasterHeight(), expression);
        virtBand.setUnit("intensity");
        virtBand.setDescription("Intensity from complex data");
        virtBand.setNoDataValueUsed(true);
        virtBand.setOwner((ProductNode)product);
        product.addBand((Band)virtBand);
    }
}

