/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.python.gpf;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.descriptor.DefaultOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.main.GPT;
import org.esa.snap.core.util.io.TreeDeleter;
import org.esa.snap.python.gpf.PyOperator;
import org.esa.snap.python.gpf.PyOperatorSpi;
import org.esa.snap.python.gpf.PyOperatorSpiTest;
import org.esa.snap.runtime.Config;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class PyOperatorTest {
    @BeforeClass
    public static void init() {
        File moduleDir = PyOperatorTest.getResourceFile("/");
        Assert.assertTrue((boolean)moduleDir.isDirectory());
        String pythonExe = Config.instance().preferences().get("snap.pythonExecutable", null);
        Assume.assumeTrue((String)String.format("Please set '%s' to execute this test", "snap.pythonExecutable"), (pythonExe != null ? 1 : 0) != 0);
        Config.instance().preferences().put("snap.forcePythonConfig", "false");
        Config.instance().preferences().put("snap.pythonModuleDir", moduleDir.getPath());
        PyOperatorSpiTest.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPythonOperatorWithGPT() throws Exception {
        String targetName = "ndvi_" + Long.toHexString(System.currentTimeMillis());
        Path targetDim = Paths.get(targetName + ".dim", new String[0]);
        Path targetData = Paths.get(targetName + ".data", new String[0]);
        try {
            GPT.main((String[])new String[]{"py_ndvi_op", "-q", "4", "-e", "-t", targetDim.toString(), "-PlowerName=radiance_13", "-PupperName=radiance_7", "-Ssource=" + PyOperatorTest.getResourceFile("/snappy/testdata/MER_FRS_L1B_SUBSET.dim")});
            Assert.assertTrue((boolean)Files.isRegularFile(targetDim, new LinkOption[0]));
            Assert.assertTrue((boolean)Files.isDirectory(targetData, new LinkOption[0]));
            Assert.assertTrue((boolean)Files.isRegularFile(targetData.resolve("ndvi.hdr"), new LinkOption[0]));
            Assert.assertTrue((boolean)Files.isRegularFile(targetData.resolve("ndvi.img"), new LinkOption[0]));
            Assert.assertEquals((long)162656L, (long)Files.size(targetData.resolve("ndvi.img")));
            Assert.assertTrue((boolean)Files.isRegularFile(targetData.resolve("ndvi_flags.hdr"), new LinkOption[0]));
            Assert.assertTrue((boolean)Files.isRegularFile(targetData.resolve("ndvi_flags.img"), new LinkOption[0]));
            Assert.assertEquals((long)40664L, (long)Files.size(targetData.resolve("ndvi_flags.img")));
        }
        finally {
            Files.deleteIfExists(targetDim);
            if (Files.isDirectory(targetData, new LinkOption[0])) {
                TreeDeleter.deleteDir((Path)targetData);
            }
        }
    }

    @Test
    public void testPythonOperatorInstantiationAndInvocation() throws Exception {
        File moduleDir = PyOperatorTest.getResourceFile("/snappy_ndvi_op");
        Assert.assertTrue((boolean)moduleDir.isDirectory());
        Product source = new Product("N", "T", 100, 100);
        source.addBand("radiance_7", "120.0");
        source.addBand("radiance_13", "50.0");
        URL infoXmlFile = PyOperatorSpi.class.getResource("/snappy_ndvi_op/ndvi_op-info.xml");
        DefaultOperatorDescriptor descriptor = DefaultOperatorDescriptor.fromXml((URL)infoXmlFile, (ClassLoader)this.getClass().getClassLoader());
        PyOperatorSpi spi = new PyOperatorSpi((OperatorDescriptor)descriptor);
        PyOperator operator = new PyOperator();
        operator.setSpi((OperatorSpi)spi);
        operator.setParameterDefaultValues();
        operator.setPythonModulePath(moduleDir.getPath());
        operator.setPythonModuleName("ndvi_op");
        operator.setPythonClassName("NdviOp");
        operator.setParameter("lowerName", (Object)"radiance_13");
        operator.setParameter("upperName", (Object)"radiance_7");
        operator.setSourceProduct("source", source);
        Product target = operator.getTargetProduct();
        Assert.assertNotNull((Object)target);
        Assert.assertNotNull((Object)target.getBand("ndvi"));
        Assert.assertNotNull((Object)target.getBand("ndvi_flags"));
        Assert.assertEquals((float)0.4117647f, (float)target.getBand("ndvi").readPixels(10, 10, 1, 1, (float[])null)[0], (float)1.0E-5f);
        Assert.assertEquals((long)2L, (long)target.getBand("ndvi_flags").readPixels(10, 10, 1, 1, (int[])null)[0]);
    }

    public static File getResourceFile(String name) {
        URL resource = PyOperator.class.getResource(name);
        Assert.assertNotNull((String)("missing resource '" + name + "'"), (Object)resource);
        return new File(URI.create(resource.toString()));
    }
}

