/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.db.DBQuery;
import org.esa.snap.engine_utilities.db.ProductDB;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.db.SQLUtils;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.UIUtils;
import org.jdesktop.swingx.JXDatePicker;

public final class DatabasePane
extends JPanel {
    private final JTextField nameField = new JTextField();
    private final JList missionJList = new JList();
    private final JList productTypeJList = new JList();
    private final JComboBox acquisitionModeCombo = new JComboBox<String>(new String[]{"All_Modes"});
    private final JComboBox passCombo = new JComboBox<String>(new String[]{"All_Passes", "ASCENDING", "DESCENDING"});
    private final JTextField trackField = new JTextField();
    private final JXDatePicker startDateBox = new JXDatePicker();
    private final JXDatePicker endDateBox = new JXDatePicker();
    private final JComboBox polarizationCombo = new JComboBox<String>(new String[]{"Any", "Quad-Pol", "Dual-Pol", "HH+VV", "HH+HV", "VV+VH", "HH", "VV", "HV", "VH"});
    private final JComboBox calibrationCombo = new JComboBox<String>(new String[]{"Any", "Calibrated", "Not_Calibrated"});
    private final JComboBox orbitCorrectionCombo = new JComboBox<String>(new String[]{"Any", "Preliminary", "Precise", "Verified"});
    private final JComboBox metadataNameCombo = new JComboBox();
    private final JTextField metdataValueField = new JTextField();
    private final JTextArea metadataArea = new JTextArea();
    private final JButton addMetadataButton = new JButton("+");
    private final JButton updateButton = new JButton(UIUtils.loadImageIcon((String)"icons/ViewRefresh16.png"));
    private final JTextArea productText = new JTextArea();
    private ProductDB db;
    private DBQuery dbQuery = new DBQuery();
    private ProductEntry[] productEntryList = null;
    boolean modifyingCombos = false;
    private final List<DatabaseQueryListener> listenerList = new ArrayList<DatabaseQueryListener>(1);
    private static final double MB = 1048576.0;
    private static final double GB = 1024.0;
    private static final double TB = 1048576.0;
    private static final DecimalFormat df = new DecimalFormat("#.00");

    public DatabasePane() {
        try {
            this.missionJList.setFixedCellWidth(100);
            this.createPanel();
            this.missionJList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (DatabasePane.this.modifyingCombos || event.getValueIsAdjusting()) {
                        return;
                    }
                    DatabasePane.this.updateProductTypeCombo();
                    DatabasePane.this.queryDatabase();
                }
            });
            this.productTypeJList.setFixedCellWidth(100);
            this.productTypeJList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (DatabasePane.this.modifyingCombos || event.getValueIsAdjusting()) {
                        return;
                    }
                    DatabasePane.this.queryDatabase();
                }
            });
            this.addComboListener(this.acquisitionModeCombo);
            this.addComboListener(this.passCombo);
            this.addComboListener(this.polarizationCombo);
            this.addComboListener(this.calibrationCombo);
            this.addComboListener(this.orbitCorrectionCombo);
            this.addMetadataButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatabasePane.this.addMetadataText();
                }
            });
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatabasePane.this.queryDatabase();
                }
            });
        }
        catch (Throwable t) {
            DatabasePane.handleException(t);
        }
    }

    private void addComboListener(JComboBox combo) {
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (DatabasePane.this.modifyingCombos || event.getStateChange() == 2) {
                    return;
                }
                DatabasePane.this.queryDatabase();
            }
        });
    }

    public void addListener(DatabaseQueryListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeListener(DatabaseQueryListener listener) {
        this.listenerList.remove(listener);
    }

    private void notifyQuery() {
        for (DatabaseQueryListener listener : this.listenerList) {
            listener.notifyNewEntryListAvailable();
        }
    }

    private static void handleException(Throwable t) {
        t.printStackTrace();
        SnapApp app = SnapApp.getDefault();
        if (app != null) {
            Dialogs.showError((String)t.getMessage());
        }
    }

    private void createPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)new JLabel("Mission:"), gbc);
        gbc.gridx = 1;
        this.add((Component)new JLabel("Product Type:"), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)new JScrollPane(this.missionJList), gbc);
        gbc.gridx = 1;
        this.add((Component)new JScrollPane(this.productTypeJList), gbc);
        ++gbc.gridy;
        JLabel label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Product Name:", (JComponent)this.nameField);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Acquisition Mode:", (JComponent)this.acquisitionModeCombo);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Pass:", (JComponent)this.passCombo);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Track:", (JComponent)this.trackField);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Start Date:", (JComponent)this.startDateBox);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"End Date:", (JComponent)this.endDateBox);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Polarization:", (JComponent)this.polarizationCombo);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Calibration:", (JComponent)this.calibrationCombo);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Orbit Correction:", (JComponent)this.orbitCorrectionCombo);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        this.add((Component)this.createFreeSearchPanel(), gbc);
        ++gbc.gridy;
        JPanel productDetailsPanel = new JPanel(new BorderLayout());
        productDetailsPanel.setBorder(BorderFactory.createTitledBorder("Product Details"));
        this.productText.setLineWrap(true);
        this.productText.setRows(4);
        this.productText.setBackground(this.getBackground());
        productDetailsPanel.add((Component)this.productText, "Center");
        this.add((Component)productDetailsPanel, gbc);
    }

    private JPanel createFreeSearchPanel() {
        JPanel freeSearchPanel = new JPanel(new GridBagLayout());
        freeSearchPanel.setBorder(BorderFactory.createTitledBorder("Metadata SQL Query"));
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        freeSearchPanel.add((Component)this.metadataNameCombo, gbc);
        this.metadataNameCombo.setPrototypeDisplayValue("123456789012");
        gbc.gridx = 1;
        freeSearchPanel.add((Component)this.metdataValueField, gbc);
        this.metdataValueField.setColumns(10);
        gbc.gridx = 2;
        freeSearchPanel.add((Component)this.addMetadataButton, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        freeSearchPanel.add((Component)this.metadataArea, gbc);
        this.metadataArea.setBorder(new LineBorder(Color.BLACK));
        this.metadataArea.setLineWrap(true);
        this.metadataArea.setRows(4);
        this.metadataArea.setToolTipText("Use AND,OR,NOT and =,<,>,<=,>-");
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        freeSearchPanel.add((Component)this.updateButton, gbc);
        DialogUtils.fillPanel((JPanel)freeSearchPanel, (GridBagConstraints)gbc);
        return freeSearchPanel;
    }

    private void connectToDatabase() throws Exception {
        this.db = ProductDB.instance();
        this.refresh();
    }

    public ProductDB getDB() {
        if (this.db == null) {
            this.queryDatabase();
        }
        return this.db;
    }

    public void refresh() {
        try {
            if (!this.db.isReady()) {
                return;
            }
            boolean origState = this.lockCombos(true);
            if (this.metadataNameCombo.getItemCount() == 0) {
                String[] metadataNames;
                for (String name : metadataNames = this.db.getMetadataNames()) {
                    this.metadataNameCombo.insertItemAt(name, this.metadataNameCombo.getItemCount());
                }
            }
            this.updateMissionCombo();
            this.lockCombos(origState);
        }
        catch (Throwable t) {
            DatabasePane.handleException(t);
        }
    }

    private boolean lockCombos(boolean flag) {
        boolean origState = this.modifyingCombos;
        this.modifyingCombos = flag;
        return origState;
    }

    private void updateMissionCombo() throws SQLException {
        boolean origState = this.lockCombos(true);
        try {
            this.missionJList.removeAll();
            this.missionJList.setListData(SQLUtils.prependString((String)"All_Missions", (String[])this.db.getAllMissions()));
        }
        finally {
            this.lockCombos(origState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProductTypeCombo() {
        boolean origState = this.lockCombos(true);
        try {
            String[] modeItems;
            String[] acquisitionModeList;
            String[] productTypeList;
            this.productTypeJList.removeAll();
            this.acquisitionModeCombo.removeAllItems();
            String[] selectedMissions = DatabasePane.toStringArray(this.missionJList.getSelectedValuesList());
            if (StringUtils.contains((String[])selectedMissions, (String)"All_Missions")) {
                productTypeList = this.db.getAllProductTypes();
                acquisitionModeList = this.db.getAllAcquisitionModes();
            } else {
                productTypeList = this.db.getProductTypes(selectedMissions);
                acquisitionModeList = this.db.getAcquisitionModes(selectedMissions);
            }
            this.productTypeJList.setListData(SQLUtils.prependString((String)"All_Types", (String[])productTypeList));
            for (String item : modeItems = SQLUtils.prependString((String)"All_Modes", (String[])acquisitionModeList)) {
                this.acquisitionModeCombo.addItem(item);
            }
        }
        catch (Throwable t) {
            DatabasePane.handleException(t);
        }
        finally {
            this.lockCombos(origState);
        }
    }

    private static String[] toStringArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    public void setBaseDir(File dir) {
        this.dbQuery.setBaseDir(dir);
        if (this.db != null) {
            this.queryDatabase();
        }
    }

    private void addMetadataText() {
        String name = (String)this.metadataNameCombo.getSelectedItem();
        String value = this.metdataValueField.getText();
        if (!name.isEmpty() && !value.isEmpty()) {
            if (this.metadataArea.getText().length() > 0) {
                this.metadataArea.append(" AND ");
            }
            if (value.matches("-?\\d+(\\.\\d+)?")) {
                this.metadataArea.append(name + "=" + value + " ");
            } else {
                this.metadataArea.append(name + "='" + value + "' ");
            }
        }
    }

    private static Calendar getDate(JXDatePicker dateField) {
        Date date = dateField.getDate();
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    private void setData() {
        this.dbQuery.setSelectedMissions(DatabasePane.toStringArray(this.missionJList.getSelectedValuesList()));
        this.dbQuery.setSelectedProductTypes(DatabasePane.toStringArray(this.productTypeJList.getSelectedValuesList()));
        this.dbQuery.setSelectedName(this.nameField.getText());
        this.dbQuery.setSelectedAcquisitionMode((String)this.acquisitionModeCombo.getSelectedItem());
        this.dbQuery.setSelectedPass((String)this.passCombo.getSelectedItem());
        this.dbQuery.setSelectedTrack(this.trackField.getText());
        this.dbQuery.setStartEndDate(DatabasePane.getDate(this.startDateBox), DatabasePane.getDate(this.endDateBox));
        this.dbQuery.setSelectedPolarization((String)this.polarizationCombo.getSelectedItem());
        this.dbQuery.setSelectedCalibration((String)this.calibrationCombo.getSelectedItem());
        this.dbQuery.setSelectedOrbitCorrection((String)this.orbitCorrectionCombo.getSelectedItem());
        this.dbQuery.clearMetadataQuery();
        this.dbQuery.setFreeQuery(this.metadataArea.getText());
    }

    public void queryDatabase() {
        if (this.db == null) {
            try {
                this.connectToDatabase();
            }
            catch (Throwable t) {
                DatabasePane.handleException(t);
            }
        }
        if (this.metadataNameCombo.getItemCount() == 0) {
            this.refresh();
        }
        this.setData();
        if (this.productEntryList != null) {
            ProductEntry.dispose((ProductEntry[])this.productEntryList);
        }
        try {
            if (this.db.isReady()) {
                this.productEntryList = this.dbQuery.queryDatabase(this.db);
                this.notifyQuery();
            }
        }
        catch (Throwable t) {
            DatabasePane.handleException(t);
        }
    }

    public void setSelectionRect(GeoPos[] selectionBox) {
        this.dbQuery.setSelectionRect(selectionBox);
        this.dbQuery.setReturnAllIfNoIntersection(true);
        this.queryDatabase();
    }

    public ProductEntry[] getProductEntryList() {
        return this.productEntryList;
    }

    public DBQuery getDBQuery() {
        this.setData();
        return this.dbQuery;
    }

    public void findSlices(int dataTakeId) {
        this.metadataArea.setText("data_take_id=" + dataTakeId);
        this.dbQuery.setSelectionRect(null);
        this.queryDatabase();
        this.metadataArea.setText("");
    }

    public void setDBQuery(DBQuery query) throws Exception {
        if (query == null) {
            return;
        }
        this.dbQuery = query;
        if (this.db == null) {
            this.connectToDatabase();
        }
        boolean origState = this.lockCombos(true);
        try {
            this.missionJList.setSelectedIndices(DatabasePane.findIndices(this.missionJList, this.dbQuery.getSelectedMissions()));
            this.updateProductTypeCombo();
            this.productTypeJList.setSelectedIndices(DatabasePane.findIndices(this.productTypeJList, this.dbQuery.getSelectedProductTypes()));
            this.acquisitionModeCombo.setSelectedItem(this.dbQuery.getSelectedAcquisitionMode());
            this.passCombo.setSelectedItem(this.dbQuery.getSelectedPass());
            if (this.dbQuery.getStartDate() != null) {
                this.startDateBox.setDate(this.dbQuery.getStartDate().getTime());
            }
            if (this.dbQuery.getEndDate() != null) {
                this.endDateBox.setDate(this.dbQuery.getEndDate().getTime());
            }
            this.polarizationCombo.setSelectedItem(this.dbQuery.getSelectedPolarization());
            this.calibrationCombo.setSelectedItem(this.dbQuery.getSelectedCalibration());
            this.orbitCorrectionCombo.setSelectedItem(this.dbQuery.getSelectedOrbitCorrection());
            this.metadataArea.setText(this.dbQuery.getFreeQuery());
        }
        finally {
            this.lockCombos(origState);
        }
    }

    private static int[] findIndices(JList list, String[] values) {
        int size = list.getModel().getSize();
        ArrayList<Integer> indices = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            String str = (String)list.getModel().getElementAt(i);
            if (!StringUtils.contains((String[])values, (String)str)) continue;
            indices.add(i);
        }
        int[] intIndices = new int[indices.size()];
        for (int i = 0; i < indices.size(); ++i) {
            intIndices[i] = (Integer)indices.get(i);
        }
        return intIndices;
    }

    public void updateProductSelectionText(ProductEntry[] selections) {
        if (selections != null && selections.length == 1) {
            ProductEntry entry = selections[0];
            StringBuilder text = new StringBuilder(255);
            MetadataElement absRoot = entry.getMetadata();
            String sampleType = absRoot.getAttributeString("SAMPLE_TYPE", "-");
            ProductData.UTC acqTime = absRoot.getAttributeUTC("first_line_time", AbstractMetadata.NO_METADATA_UTC);
            int absOrbit = absRoot.getAttributeInt("ABS_ORBIT", 99999);
            int relOrbit = absRoot.getAttributeInt("REL_ORBIT", 99999);
            String map = absRoot.getAttributeString("map_projection", "-").trim();
            int cal = absRoot.getAttributeInt("abs_calibration_flag", 99999);
            int tc = absRoot.getAttributeInt("is_terrain_corrected", 99999);
            int coreg = absRoot.getAttributeInt("coregistered_stack", 99999);
            text.append(entry.getName());
            text.append("\n\n");
            text.append(entry.getMission());
            text.append("\n");
            text.append(entry.getAcquisitionMode() + "   " + entry.getProductType() + " " + sampleType + '\n');
            text.append(acqTime.format());
            text.append('\n');
            text.append("Orbit: " + absOrbit);
            if (relOrbit != 99999) {
                text.append("  Track: " + relOrbit);
            }
            text.append('\n');
            text.append("Size: " + DatabasePane.getSizeString(entry.getFileSize()));
            text.append('\n');
            if (!map.isEmpty()) {
                text.append(map);
                text.append('\n');
            }
            if (cal == 1) {
                text.append("Calibrated ");
            }
            if (coreg == 1) {
                text.append("Coregistered ");
            }
            if (tc == 1) {
                text.append("Terrain Corrected ");
            }
            this.productText.setText(text.toString());
        } else if (selections != null && selections.length > 1) {
            long totalSize = 0L;
            for (ProductEntry entry : selections) {
                totalSize += entry.getFileSize();
            }
            StringBuilder text = new StringBuilder(255);
            text.append(selections.length + " products");
            text.append("\n");
            text.append("Total: " + DatabasePane.getSizeString(totalSize));
            this.productText.setText(text.toString());
        } else {
            this.productText.setText("");
        }
    }

    private static String getSizeString(long bytes) {
        String unit;
        double value;
        double mb = (double)bytes / 1048576.0;
        if (mb > 1048576.0) {
            value = mb / 1048576.0;
            unit = "TB";
        } else if (mb > 1024.0) {
            value = mb / 1024.0;
            unit = "GB";
        } else {
            value = mb;
            unit = "MB";
        }
        return df.format(value) + " " + unit;
    }

    public static interface DatabaseQueryListener {
        public void notifyNewEntryListAvailable();
    }
}

