/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import org.esa.snap.engine_utilities.db.ProductDB;

public final class DBRemover
extends SwingWorker {
    private final ProductDB db;
    private final File baseDir;
    private final ProgressMonitor pm;
    private final List<DBRemoverListener> listenerList = new ArrayList<DBRemoverListener>(1);

    public DBRemover(ProductDB database, File baseDir, ProgressMonitor pm) {
        this.db = database;
        this.pm = pm;
        this.baseDir = baseDir;
    }

    public void addListener(DBRemoverListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    private void notifyMSG(DBRemoverListener.MSG msg) {
        for (DBRemoverListener listener : this.listenerList) {
            listener.notifyMSG(msg);
        }
    }

    protected Boolean doInBackground() throws Exception {
        try {
            if (this.baseDir == null) {
                this.db.removeAllProducts(this.pm);
            } else {
                this.db.removeProducts(this.baseDir, this.pm);
            }
        }
        catch (Throwable e) {
            System.out.println("Product Removal Exception\n" + e.getMessage());
        }
        finally {
            this.pm.done();
        }
        return true;
    }

    @Override
    public void done() {
        this.notifyMSG(DBRemoverListener.MSG.DONE);
    }

    public static interface DBRemoverListener {
        public void notifyMSG(MSG var1);

        public static enum MSG {
            DONE;

        }
    }
}

