/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.dialogs;

import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.ModalDialog;

public class CheckListDialog
extends ModalDialog {
    private final List<JToggleButton> toggleList = new ArrayList<JToggleButton>(3);
    protected final Map<String, Boolean> items;
    private final boolean singleSelection;
    private boolean ok = false;

    public CheckListDialog(String title) {
        this(title, new HashMap<String, Boolean>(3), false);
    }

    public CheckListDialog(String title, Map<String, Boolean> items, boolean singleSelection) {
        super((Window)SnapApp.getDefault().getMainFrame(), title, 1, null);
        this.items = items;
        this.singleSelection = singleSelection;
        this.initContent();
    }

    protected void initContent() {
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        ButtonGroup group = new ButtonGroup();
        for (String name : this.items.keySet()) {
            JToggleButton btn;
            if (this.singleSelection) {
                btn = new JRadioButton(name);
                group.add(btn);
            } else {
                btn = new JCheckBox(name);
            }
            this.toggleList.add(btn);
            content.add(btn);
            btn.setSelected(this.items.get(name));
        }
        this.getJDialog().setMinimumSize(new Dimension(200, 100));
        this.setContent(content);
    }

    protected void onOK() {
        for (JToggleButton btn : this.toggleList) {
            this.items.put(btn.getText(), btn.isSelected());
        }
        this.ok = true;
        this.hide();
    }

    public boolean IsOK() {
        return this.ok;
    }
}

