/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.pixex.output.DefaultFormatStrategy;
import org.esa.snap.pixex.output.RasterNamesFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PixExFormatStrategyTest_writeMeasurement {
    private RasterNamesFactory dummyRasterNamesFactory;

    @Before
    public void setUp() throws Exception {
        this.dummyRasterNamesFactory = this.newDummyRasterNamesFactory();
    }

    @Test
    public void testWriteMeasurements_oneMeasurement_withNaN() throws Exception {
        Measurement measurement = this.newMeasurement(12, new Number[]{12.4, Double.NaN, 1.0345, 7}, true);
        Measurement[] oneMeasurement = new Measurement[]{measurement};
        DefaultFormatStrategy defaultFormat = new DefaultFormatStrategy(this.dummyRasterNamesFactory, 1, "expression", false);
        StringWriter stringWriter = new StringWriter();
        defaultFormat.writeMeasurements(null, new PrintWriter(stringWriter), oneMeasurement);
        BufferedReader reader = new BufferedReader(new StringReader(stringWriter.toString()));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"14\t13\tname12\t20.799999\t21.900000\t15.300\t16.400\t2000-01-18\t00:00:18\t12.4\t\t1.0345\t7"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void testWriteMeasurements_oneMeasurement_withoutDate() throws Exception {
        Measurement measurement = this.newMeasurementWithoutDate(12, new Number[]{12.4, Double.NaN, 1.0345, 7}, true);
        Measurement[] oneMeasurement = new Measurement[]{measurement};
        DefaultFormatStrategy defaultFormat = new DefaultFormatStrategy(this.dummyRasterNamesFactory, 1, "expression", false);
        StringWriter stringWriter = new StringWriter();
        defaultFormat.writeMeasurements(null, new PrintWriter(stringWriter), oneMeasurement);
        BufferedReader reader = new BufferedReader(new StringReader(stringWriter.toString()));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"14\t13\tname12\t20.799999\t21.900000\t15.300\t16.400\t \t \t12.4\t\t1.0345\t7"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void testWriteMeasurements_twoMeasurements_() throws Exception {
        Measurement measurement1 = this.newMeasurement(1, new Number[]{12.4, Double.NaN, 1.0345, 7}, true);
        Measurement measurement2 = this.newMeasurement(2, new Number[]{14.4, 2.345, 1.666, 8}, false);
        boolean exportInvalids = true;
        DefaultFormatStrategy defaultFormat = new DefaultFormatStrategy(this.dummyRasterNamesFactory, 1, "expression", true);
        StringWriter stringWriter = new StringWriter();
        defaultFormat.writeMeasurements(null, new PrintWriter(stringWriter), new Measurement[]{measurement1, measurement2});
        BufferedReader reader = new BufferedReader(new StringReader(stringWriter.toString()));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"true\t3\t2\tname1\t9.800000\t10.900000\t4.300\t5.400\t2000-01-07\t00:00:07\t12.4\t\t1.0345\t7"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"false\t4\t3\tname2\t10.800000\t11.900000\t5.300\t6.400\t2000-01-08\t00:00:08\t14.4\t2.345\t1.666\t8"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo(null));
    }

    private Measurement newMeasurementWithoutDate(int offset, Number[] values, boolean valid) {
        return this.newMeasurement(offset, values, valid, false);
    }

    private Measurement newMeasurement(int offset, Number[] values, boolean valid) {
        return this.newMeasurement(offset, values, valid, true);
    }

    private Measurement newMeasurement(int offset, Number[] values, boolean valid, boolean createDate) {
        ProductData.UTC time;
        int coordinateID = 1 + offset;
        String name = "name" + offset;
        int productId = 2 + offset;
        float pixelX = 3.3f + (float)offset;
        float pixelY = 4.4f + (float)offset;
        if (createDate) {
            int days = 5 + offset;
            int seconds = 6 + offset;
            int microSeconds = 7 + offset;
            time = new ProductData.UTC(days, seconds, microSeconds);
        } else {
            time = null;
        }
        float lat = 8.8f + (float)offset;
        float lon = 9.9f + (float)offset;
        GeoPos geoPos = new GeoPos((double)lat, (double)lon);
        return new Measurement(coordinateID, name, (long)productId, (double)pixelX, (double)pixelY, time, geoPos, (Object[])values, valid);
    }

    private RasterNamesFactory newDummyRasterNamesFactory() {
        return new RasterNamesFactory(){

            public String[] getRasterNames(Product product) {
                return new String[0];
            }

            public String[] getUniqueRasterNames(Product product) {
                return this.getRasterNames(product);
            }
        };
    }
}

