/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.aggregators;

import org.esa.snap.pixex.aggregators.MedianAggregatorStrategy;
import org.esa.snap.pixex.calvalus.ma.DefaultRecord;
import org.esa.snap.pixex.calvalus.ma.Record;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MedianAggregatorStrategyTest {
    private MedianAggregatorStrategy strategy;

    @Before
    public void setUp() throws Exception {
        this.strategy = new MedianAggregatorStrategy();
    }

    @Test
    public void testGetValueForOddNumberOfIntegerBandValues() {
        Number[] oddNumberOfIntegerBandValues = new Integer[]{1, 1, 2, 3, 5, 8, 13, 21, 34};
        Assert.assertEquals((double)5.0, (double)this.strategy.getMedian(oddNumberOfIntegerBandValues), (double)1.0E-4);
    }

    @Test
    public void testGetValueForEvenNumberOfIntegerBandValues() {
        Number[] evenNumberOfIntegerBandValues = new Integer[]{1, 2, 3, 5, 8, 13};
        Assert.assertEquals((double)4.0, (double)this.strategy.getMedian(evenNumberOfIntegerBandValues), (double)1.0E-4);
    }

    @Test
    public void testGetValueForOddNumberOfFloatBandValues() {
        Number[] oddNumberOfFloatBandValues = new Float[]{Float.valueOf(2.5f), Float.valueOf(3.5f), Float.valueOf(5.5f), Float.valueOf(8.5f), Float.valueOf(13.5f), Float.valueOf(21.5f), Float.valueOf(34.5f)};
        Assert.assertEquals((double)8.5, (double)this.strategy.getMedian(oddNumberOfFloatBandValues), (double)1.0E-4);
    }

    @Test
    public void testGetValueForEvenNumberOfFloatBandValues() {
        Number[] evenNumberOfFloatBandValues = new Float[]{Float.valueOf(3.5f), Float.valueOf(5.5f), Float.valueOf(8.5f), Float.valueOf(13.5f)};
        Assert.assertEquals((double)7.0, (double)this.strategy.getMedian(evenNumberOfFloatBandValues), (double)1.0E-4);
    }

    @Test
    public void testGetValuesForOneValue() {
        Number[] evenNumberOfFloatBandValues = new Float[]{Float.valueOf(3.5f)};
        Assert.assertEquals((double)3.5, (double)this.strategy.getMedian(evenNumberOfFloatBandValues), (double)1.0E-4);
    }

    @Test
    public void testGetValues() throws Exception {
        Float[] valuesForBand1 = new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f)};
        Number[][] numbers = new Number[][]{valuesForBand1};
        DefaultRecord record = new DefaultRecord((Object[])numbers);
        Assert.assertEquals((long)2L, (long)this.strategy.getValues((Record)record, 0).length);
        Assert.assertEquals((double)3.5, (double)this.strategy.getValues((Record)record, 0)[0].doubleValue(), (double)1.0E-4);
        Assert.assertEquals((long)6L, (long)this.strategy.getValues((Record)record, 0)[1].intValue());
    }

    @Test
    public void testGetValueCount() throws Exception {
        Assert.assertEquals((long)2L, (long)this.strategy.getValueCount());
    }

    @Test
    public void testGetSuffixes() throws Exception {
        Assert.assertEquals((long)2L, (long)this.strategy.getSuffixes().length);
        Assert.assertEquals((Object)"median", (Object)this.strategy.getSuffixes()[0]);
        Assert.assertEquals((Object)"num_pixels", (Object)this.strategy.getSuffixes()[1]);
    }
}

