/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import java.io.File;
import org.esa.snap.core.datamodel.Product;

class ProductIdentifier {
    private final String productName;
    private final String productType;
    private final String productLocation;

    static ProductIdentifier create(Product product) {
        String location = ProductIdentifier.getProductLocation(product);
        return new ProductIdentifier(product.getName(), product.getProductType(), location);
    }

    private static String getProductLocation(Product product) {
        File fileLocation = product.getFileLocation();
        if (fileLocation != null) {
            return fileLocation.getAbsolutePath();
        }
        return String.format("Not saved to disk [%s]", product.getName());
    }

    ProductIdentifier(String name, String type, String location) {
        this.productName = name;
        this.productType = type;
        this.productLocation = location;
    }

    public String getLocation() {
        return this.productLocation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductIdentifier that = (ProductIdentifier)o;
        if (!this.productLocation.equals(that.productLocation)) {
            return false;
        }
        if (!this.productName.equals(that.productName)) {
            return false;
        }
        return this.productType.equals(that.productType);
    }

    public int hashCode() {
        int result = this.productName.hashCode();
        result = 31 * result + this.productType.hashCode();
        result = 31 * result + this.productLocation.hashCode();
        return result;
    }
}

