/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.graph.Graph;
import org.esa.snap.core.gpf.graph.GraphException;
import org.esa.snap.core.gpf.graph.GraphIO;
import org.esa.snap.core.gpf.graph.GraphProcessor;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.pixex.Coordinate;
import org.esa.snap.pixex.PixExMeasurementReader;
import org.esa.snap.pixex.PixExOp;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class PixExOpTest {
    @Test
    public void testUsingGraph() throws GraphException, IOException {
        String parentDir = new File(this.getClass().getResource("dummyProduct1.dim").getFile()).getParent();
        int windowSize = 11;
        Coordinate[] coordinates = new Coordinate[]{new Coordinate("carlCoordinate", Double.valueOf(60.1), Double.valueOf(3.0), null), new Coordinate("cassandraCoordinate", Double.valueOf(59.1), Double.valueOf(0.5), null)};
        File outputDir = PixExOpTest.getOutputDir("testUsingGraph", this.getClass());
        String graphOpXml = "<graph id=\"someGraphId\">\n    <version>1.0</version>\n    <node id=\"someNodeId\">\n      <operator>PixEx</operator>\n      <parameters>\n        <sourceProductPaths>\n           " + parentDir + File.separator + "*.dim" + "        </sourceProductPaths>\n" + "        <exportTiePoints>false</exportTiePoints>\n" + "        <exportBands>true</exportBands>\n" + "        <exportMasks>false</exportMasks>                \n" + "        <coordinates>\n" + "          <coordinate>\n" + "            <latitude>" + coordinates[0].getLat() + "</latitude>\n" + "            <longitude>" + coordinates[0].getLon() + "</longitude>\n" + "            <name>" + coordinates[0].getName() + "</name>\n" + "          </coordinate>\n" + "          <coordinate>\n" + "            <latitude>" + coordinates[1].getLat() + "</latitude>\n" + "            <longitude>" + coordinates[1].getLon() + "</longitude>\n" + "            <name>" + coordinates[1].getName() + "</name>\n" + "          </coordinate>\n" + "        </coordinates>\n" + "        <windowSize>" + windowSize + "</windowSize>\n" + "        <outputDir>" + outputDir.getAbsolutePath() + "</outputDir>\n" + "        <outputFilePrefix>" + "testUsingGraph" + "</outputFilePrefix>\n" + "      </parameters>\n" + "    </node>\n" + "  </graph>";
        Graph graph = GraphIO.read((Reader)new StringReader(graphOpXml));
        GraphProcessor processor = new GraphProcessor();
        processor.executeGraph(graph, ProgressMonitor.NULL);
        PixExMeasurementReader reader = new PixExMeasurementReader(outputDir);
        List<Measurement> measurementList = this.convertToList((Iterator<Measurement>)reader);
        Assert.assertEquals((long)(windowSize * windowSize * 2 * 2), (long)measurementList.size());
    }

    @Test
    public void testGetParsedInputPaths() throws Exception {
        File testDir = PixExOpTest.getOutputDir("testGetParsedInputPaths", this.getClass());
        File subDir1 = new File(testDir, "subDir1");
        File subDir2 = new File(testDir, "subDir2");
        File subDir2_1 = new File(subDir2, "subDir2_1");
        File subDir2_2 = new File(subDir2, "subDir2_2");
        testDir.mkdir();
        subDir1.mkdir();
        subDir2.mkdir();
        subDir2_1.mkdir();
        subDir2_2.mkdir();
        String pattern = testDir.getCanonicalPath() + File.separator + "**";
        Set dirList = PixExOp.getSourceProductFileSet((String[])new String[]{pattern}, (Logger)Logger.getAnonymousLogger());
        Assert.assertEquals((long)4L, (long)dirList.size());
        Assert.assertTrue((String)("Missing dir '" + subDir1.getCanonicalPath() + "'."), (boolean)dirList.contains(subDir1.getCanonicalFile()));
        Assert.assertTrue((String)("Missing dir '" + subDir2.getCanonicalPath() + "'."), (boolean)dirList.contains(subDir2.getCanonicalFile()));
        Assert.assertTrue((String)("Missing dir '" + subDir2_1.getCanonicalPath() + "'."), (boolean)dirList.contains(subDir2_1.getCanonicalFile()));
        Assert.assertTrue((String)("Missing dir '" + subDir2_2.getCanonicalPath() + "'."), (boolean)dirList.contains(subDir2_2.getCanonicalFile()));
        dirList = PixExOp.getSourceProductFileSet((String[])new String[]{testDir.getPath(), subDir2_1.getPath()}, (Logger)Logger.getAnonymousLogger());
        Assert.assertEquals((long)2L, (long)dirList.size());
        Assert.assertTrue((String)("Missing dir '" + testDir.getCanonicalPath() + "'."), (boolean)dirList.contains(testDir.getCanonicalFile()));
        Assert.assertTrue((String)("Missing dir '" + subDir2_1.getCanonicalPath() + "'."), (boolean)dirList.contains(subDir2_1.getCanonicalFile()));
    }

    @Test
    public void testSingleProduct() throws Exception {
        Coordinate[] coordinates = new Coordinate[]{new Coordinate("coord1", Double.valueOf(10.0), Double.valueOf(10.0), null), new Coordinate("coord2", Double.valueOf(20.0), Double.valueOf(20.0), null)};
        int windowSize = 3;
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        File outputDir = PixExOpTest.getOutputDir("testSingleProduct", this.getClass());
        parameterMap.put("outputDir", outputDir);
        parameterMap.put("outputFilePrefix", "pixels");
        parameterMap.put("exportTiePoints", false);
        parameterMap.put("exportMasks", false);
        parameterMap.put("coordinates", coordinates);
        parameterMap.put("windowSize", windowSize);
        parameterMap.put("exportKmz", true);
        String[] bandNames = new String[]{"rad_1", "rad_2"};
        Product[] sourceProducts = new Product[]{PixExOpTest.createTestProduct("andi", "type1", bandNames)};
        PixExOpTest.computeData(parameterMap, sourceProducts);
        Assert.assertTrue((String)"Kmz file does not exists", (boolean)new File(outputDir, "pixels_coordinates.kmz").exists());
        try (PixExMeasurementReader reader = new PixExMeasurementReader(outputDir);){
            List<Measurement> measurementList = this.convertToList((Iterator<Measurement>)reader);
            Assert.assertEquals((long)(windowSize * windowSize * sourceProducts.length * coordinates.length), (long)measurementList.size());
            this.testForExistingMeasurement(measurementList, "coord1", 1, 10.5f, 9.5f, 189.5f, 79.5f);
            this.testForExistingMeasurement(measurementList, "coord2", 2, 20.5f, 19.5f, 199.5f, 69.5f);
        }
    }

    @Test
    public void testTimeExtractionFromFilename() throws Exception {
        Coordinate[] coordinates = new Coordinate[]{new Coordinate("coord", Double.valueOf(20.0), Double.valueOf(20.0), null)};
        int windowSize = 1;
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        File outputDir = PixExOpTest.getOutputDir("testSingleProduct", this.getClass());
        parameterMap.put("outputDir", outputDir);
        parameterMap.put("exportTiePoints", false);
        parameterMap.put("exportMasks", false);
        parameterMap.put("coordinates", coordinates);
        parameterMap.put("windowSize", windowSize);
        parameterMap.put("extractTimeFromFilename", true);
        parameterMap.put("dateInterpretationPattern", "yyyyMMdd");
        parameterMap.put("filenameInterpretationPattern", "*${startDate}*");
        String[] bandNames = new String[]{"rad_1", "rad_2"};
        Product p1 = PixExOpTest.createTestProduct("andi", "type1", bandNames);
        p1.setStartTime(ProductData.UTC.parse((String)"22/08/1999", (String)"dd/MM/yyyy"));
        Product p2 = PixExOpTest.createTestProduct("bob", "type1", bandNames);
        p2.setFileLocation(new File("bob_20010320.nc"));
        p2.setStartTime(ProductData.UTC.parse((String)"30/03/1920", (String)"dd/MM/yyyy"));
        Product p3 = PixExOpTest.createTestProduct("jane", "type1", bandNames);
        p3.setFileLocation(new File("bob_20101114.nc"));
        Product[] sourceProducts = new Product[]{p1, p2, p3};
        PixExOpTest.computeData(parameterMap, sourceProducts);
        try (PixExMeasurementReader reader = new PixExMeasurementReader(outputDir);){
            List<Measurement> measurementList = this.convertToList((Iterator<Measurement>)reader);
            Assert.assertEquals((long)sourceProducts.length, (long)measurementList.size());
            Assert.assertEquals((Object)ProductData.UTC.parse((String)"22/08/1999", (String)"dd/MM/yyyy").getAsDate(), (Object)measurementList.get(0).getTime().getAsDate());
            Assert.assertEquals((Object)ProductData.UTC.parse((String)"20/03/2001", (String)"dd/MM/yyyy").getAsDate(), (Object)measurementList.get(1).getTime().getAsDate());
            Assert.assertEquals((Object)ProductData.UTC.parse((String)"14/11/2010", (String)"dd/MM/yyyy").getAsDate(), (Object)measurementList.get(2).getTime().getAsDate());
        }
    }

    @Test
    public void testTwoProductsSameType() throws Exception {
        Coordinate[] coordinates = new Coordinate[]{new Coordinate("coord1", Double.valueOf(10.0), Double.valueOf(10.0), null), new Coordinate("coord2", Double.valueOf(20.0), Double.valueOf(20.0), null), new Coordinate("coord3", Double.valueOf(0.5), Double.valueOf(0.5), null)};
        int windowSize = 5;
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        File outputDir = PixExOpTest.getOutputDir("testTwoProductsSameType", this.getClass());
        parameterMap.put("outputDir", outputDir);
        parameterMap.put("exportTiePoints", false);
        parameterMap.put("exportMasks", false);
        parameterMap.put("coordinates", coordinates);
        parameterMap.put("windowSize", windowSize);
        String[] bandNames = new String[]{"rad_1", "rad_2"};
        Product[] products = new Product[]{PixExOpTest.createTestProduct("kallegrabowski", "type1", bandNames), PixExOpTest.createTestProduct("keek", "type1", bandNames)};
        PixExOpTest.computeData(parameterMap, products);
        try (PixExMeasurementReader reader = new PixExMeasurementReader(outputDir);){
            List<Measurement> measurementList = this.convertToList((Iterator<Measurement>)reader);
            Assert.assertEquals((long)(windowSize * windowSize * products.length * coordinates.length), (long)measurementList.size());
            this.testForExistingMeasurement(measurementList, "coord1", 1, 10.5f, 9.5f, 189.5f, 79.5f);
            this.testForExistingMeasurement(measurementList, "coord2", 2, 20.5f, 19.5f, 199.5f, 69.5f);
        }
    }

    @Test
    public void testTwentyProductsSameType() throws Exception {
        Coordinate[] coordinates = new Coordinate[]{new Coordinate("coord1", Double.valueOf(10.0), Double.valueOf(10.0), null), new Coordinate("coord3", Double.valueOf(0.5), Double.valueOf(0.5), null)};
        int windowSize = 1;
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        File outputDir = PixExOpTest.getOutputDir("testTwentyProductsSameType", this.getClass());
        parameterMap.put("outputDir", outputDir);
        parameterMap.put("exportTiePoints", false);
        parameterMap.put("exportMasks", false);
        parameterMap.put("coordinates", coordinates);
        parameterMap.put("windowSize", windowSize);
        String[] bandNames = new String[]{"rad_1", "rad_2, radiance_3"};
        ArrayList<Product> productList = new ArrayList<Product>();
        for (int i = 0; i < 20; ++i) {
            productList.add(PixExOpTest.createTestProduct("prod_" + i, "type", bandNames));
        }
        Product[] products = productList.toArray(new Product[productList.size()]);
        PixExOpTest.computeData(parameterMap, products);
        try (PixExMeasurementReader reader = new PixExMeasurementReader(outputDir);){
            List<Measurement> measurementList = this.convertToList((Iterator<Measurement>)reader);
            Assert.assertEquals((long)(windowSize * windowSize * products.length * coordinates.length), (long)measurementList.size());
            this.testForExistingMeasurement(measurementList, "coord1", 1, 9.5f, 10.5f, 190.5f, 80.5f);
            this.testForExistingMeasurement(measurementList, "coord3", 2, 0.5f, 0.5f, 180.5f, 89.5f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTwoProductsTwoDifferentTypes() throws Exception {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Coordinate[] coordinates = new Coordinate[]{new Coordinate("coord1", Double.valueOf(10.0), Double.valueOf(10.0), null), new Coordinate("coord2", Double.valueOf(20.0), Double.valueOf(20.0), null), new Coordinate("coord3", Double.valueOf(0.5), Double.valueOf(0.5), null)};
        int windowSize = 5;
        File outputDir = PixExOpTest.getOutputDir("testTwoProductsTwoDifferentTypes", this.getClass());
        parameterMap.put("outputDir", outputDir);
        parameterMap.put("exportTiePoints", false);
        parameterMap.put("exportMasks", false);
        parameterMap.put("coordinates", coordinates);
        parameterMap.put("windowSize", windowSize);
        String[] bandNames = new String[]{"rad_1", "rad_2"};
        String[] bandNames2 = new String[]{"refl_1", "refl_2"};
        Product[] products = new Product[]{PixExOpTest.createTestProduct("kallegrabowski", "type1", bandNames), PixExOpTest.createTestProduct("keek", "level2", bandNames2)};
        PixExOpTest.computeData(parameterMap, products);
        PixExMeasurementReader reader = new PixExMeasurementReader(outputDir);
        List<Measurement> measurementList = this.convertToList((Iterator<Measurement>)reader);
        try {
            Assert.assertEquals((long)(windowSize * windowSize * products.length * coordinates.length), (long)measurementList.size());
            this.testForExistingMeasurement(measurementList, "coord1", 1, 9.5f, 10.5f, 190.5f, 80.5f);
            this.testForExistingMeasurement(measurementList, "coord2", 2, 20.5f, 19.5f, 199.5f, 69.5f);
            this.testForExistingMeasurement(measurementList, "coord3", 3, 0.5f, 0.5f, 180.5f, 89.5f);
        }
        finally {
            reader.close();
        }
    }

    @Test
    public void testTwoProductsWithTimeConstraints() throws Exception {
        String[] bandNames = new String[]{"rad_1", "rad_2"};
        Product p1 = PixExOpTest.createTestProduct("kallegrabowski", "type1", bandNames);
        p1.setStartTime(ProductData.UTC.parse((String)"01-MAR-2005 12:00:00"));
        p1.setEndTime(ProductData.UTC.parse((String)"01-MAR-2005 13:00:00"));
        Product p2 = PixExOpTest.createTestProduct("keek", "type1", bandNames);
        p2.setStartTime(ProductData.UTC.parse((String)"01-Jan-2006 0:00:00"));
        p2.setEndTime(ProductData.UTC.parse((String)"01-Jan-2006 12:00:00"));
        Calendar calInP1 = Calendar.getInstance();
        calInP1.set(2005, 2, 1, 12, 30, 0);
        Calendar calInP2 = Calendar.getInstance();
        calInP2.set(2006, 0, 1, 6, 0, 0);
        Calendar calOutsideBoth = Calendar.getInstance();
        calOutsideBoth.set(2010, 0, 1, 0, 0, 0);
        Coordinate[] coordinates = new Coordinate[]{new Coordinate("coord1", Double.valueOf(10.0), Double.valueOf(10.0), calInP1.getTime()), new Coordinate("coord2", Double.valueOf(20.0), Double.valueOf(20.0), calInP2.getTime()), new Coordinate("coord3", Double.valueOf(0.5), Double.valueOf(0.5), calOutsideBoth.getTime())};
        PixExOp pixEx = new PixExOp();
        pixEx.setParameterDefaultValues();
        File outputDir = PixExOpTest.getOutputDir("testTwoProductsWithTimeConstraints", this.getClass());
        pixEx.setParameter("outputDir", (Object)outputDir);
        pixEx.setParameter("exportTiePoints", (Object)false);
        pixEx.setParameter("exportMasks", (Object)false);
        pixEx.setParameter("coordinates", (Object)coordinates);
        pixEx.setParameter("windowSize", (Object)1);
        pixEx.setParameter("timeDifference", (Object)"1D");
        pixEx.setSourceProducts(new Product[]{p1, p2});
        try (PixExMeasurementReader reader = (PixExMeasurementReader)pixEx.getTargetProperty("measurements");){
            List<Measurement> measurementList = this.convertToList((Iterator<Measurement>)reader);
            Assert.assertEquals((long)2L, (long)measurementList.size());
            this.testForExistingMeasurement(measurementList, "coord1", 1, 9.5f, 10.5f, 190.5f, 80.5f);
            this.testForExistingMeasurement(measurementList, "coord2", 2, 19.5f, 20.5f, 200.5f, 70.5f);
        }
    }

    @Test
    public void testTwentyProductsWithDifferentTypes() throws Exception {
        Coordinate[] coordinates = new Coordinate[]{new Coordinate("coord3", Double.valueOf(2.5), Double.valueOf(1.0), null), new Coordinate("coord4", Double.valueOf(0.5), Double.valueOf(0.5), null)};
        int windowSize = 1;
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        File outputDir = PixExOpTest.getOutputDir("testTwentyProductsWithDifferentTypes", this.getClass());
        parameterMap.put("outputDir", outputDir);
        parameterMap.put("exportTiePoints", false);
        parameterMap.put("exportMasks", false);
        parameterMap.put("coordinates", coordinates);
        parameterMap.put("windowSize", windowSize);
        ArrayList<Product> productList = new ArrayList<Product>();
        for (int i = 0; i < 20; ++i) {
            productList.add(PixExOpTest.createTestProduct("prod_" + i, "type" + i, new String[]{"band" + i}));
        }
        Product[] products = productList.toArray(new Product[productList.size()]);
        PixExOpTest.computeData(parameterMap, products);
        try (PixExMeasurementReader measurementReader = new PixExMeasurementReader(outputDir);){
            List<Measurement> measurementList = this.convertToList((Iterator<Measurement>)measurementReader);
            Assert.assertEquals((long)(windowSize * windowSize * products.length * coordinates.length), (long)measurementList.size());
            this.testForExistingMeasurement(measurementList, "coord3", 1, 2.5f, 1.5f, 181.5f, 87.5f);
            this.testForExistingMeasurement(measurementList, "coord4", 2, 0.5f, 0.5f, 180.5f, 89.5f);
        }
    }

    @Test(expected=OperatorException.class)
    public void testFailForEvenWindowSize() throws Exception {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("coordinates", new Coordinate[]{new Coordinate("coord1", Double.valueOf(10.0), Double.valueOf(10.0), null)});
        parameterMap.put("windowSize", 2);
        Product[] sourceProduct = new Product[]{PixExOpTest.createTestProduct("werner", "type1", new String[]{"rad_1", "rad_2"})};
        PixExOpTest.computeData(parameterMap, sourceProduct);
    }

    @Test
    public void testExtractMatchupCoordinates() throws Exception {
        File testFile = new File(this.getClass().getResource("test.csv").getFile());
        List coordinates = PixExOp.extractMatchupCoordinates((File)testFile);
        Assert.assertEquals((long)2L, (long)coordinates.size());
        Assert.assertEquals((Object)"0", (Object)((Coordinate)coordinates.get(0)).getName());
        Assert.assertEquals((double)56.0123, (double)((Coordinate)coordinates.get(0)).getLat(), (double)1.0E-4);
        Assert.assertEquals((double)6.2345, (double)((Coordinate)coordinates.get(0)).getLon(), (double)1.0E-4);
        Coordinate.OriginalValue[] originalValues = ((Coordinate)coordinates.get(0)).getOriginalValues();
        Assert.assertEquals((long)4L, (long)originalValues.length);
        Assert.assertEquals((Object)"test1.1", (Object)originalValues[1].value);
        Assert.assertEquals((double)0.2f, (double)Float.parseFloat(originalValues[2].value), (double)0.001);
        Assert.assertEquals((double)0.3f, (double)Float.parseFloat(originalValues[3].value), (double)0.001);
        Assert.assertEquals((Object)"1", (Object)((Coordinate)coordinates.get(1)).getName());
        Assert.assertEquals((double)56.0124, (double)((Coordinate)coordinates.get(1)).getLat(), (double)1.0E-4);
        Assert.assertEquals((double)6.2346, (double)((Coordinate)coordinates.get(1)).getLon(), (double)1.0E-4);
        Coordinate.OriginalValue[] originalValues1 = ((Coordinate)coordinates.get(1)).getOriginalValues();
        Assert.assertEquals((long)4L, (long)originalValues.length);
        Assert.assertEquals((Object)"test1.2", (Object)originalValues1[1].value);
        Assert.assertEquals((double)0.21f, (double)Float.parseFloat(originalValues1[2].value), (double)0.001);
        Assert.assertEquals((double)0.31f, (double)Float.parseFloat(originalValues1[3].value), (double)0.001);
    }

    public static File getOutputDir(String methodName, Class testClass) {
        File[] files;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File baseTestDir = new File(tmpDir, testClass.getSimpleName());
        File dir = new File(baseTestDir, methodName);
        if (!dir.mkdirs() && (files = dir.listFiles()) != null) {
            for (File file : files) {
                file.delete();
            }
        }
        return dir;
    }

    private void testForExistingMeasurement(List<Measurement> measurementList, String coordinateName, int id, float lat, float lon, float x, float y) {
        for (Measurement measurement : measurementList) {
            if (!measurement.getCoordinateName().equals(coordinateName) || id != measurement.getCoordinateID() || Double.compare(lat, measurement.getLat()) != 0 || Double.compare(lon, measurement.getLon()) != 0 || Double.compare(x, measurement.getPixelX()) != 0 || Double.compare(y, measurement.getPixelY()) != 0) continue;
            return;
        }
        Assert.fail((String)("No measurement with the name " + coordinateName));
    }

    private List<Measurement> convertToList(Iterator<Measurement> measurementIterator) {
        ArrayList<Measurement> list = new ArrayList<Measurement>();
        while (measurementIterator.hasNext()) {
            list.add(measurementIterator.next());
        }
        return list;
    }

    private static void computeData(Map<String, Object> parameterMap, Product[] sourceProducts) {
        GPF.createProduct((String)"PixEx", parameterMap, (Product[])sourceProducts);
    }

    public static Product createTestProduct(String name, String type, String[] bandNames) throws FactoryException, TransformException {
        Rectangle bounds = new Rectangle(360, 180);
        Product product = new Product(name, type, bounds.width, bounds.height);
        AffineTransform i2mTransform = new AffineTransform();
        int northing = 90;
        int easting = -180;
        i2mTransform.translate(-180.0, 90.0);
        double scaleX = 360 / bounds.width;
        double scaleY = 180 / bounds.height;
        i2mTransform.scale(scaleX, -scaleY);
        CrsGeoCoding geoCoding = new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, bounds, i2mTransform);
        product.setSceneGeoCoding((GeoCoding)geoCoding);
        for (int i = 0; i < bandNames.length; ++i) {
            Band band = product.addBand(bandNames[i], 30);
            band.setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(bounds.width), (Float)Float.valueOf(bounds.height), (Number[])new Float[]{Float.valueOf(i)}, null));
        }
        return product;
    }
}

