/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import java.io.IOException;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.pixex.output.PixExMeasurementFactory;
import org.esa.snap.pixex.output.ProductRegistry;
import org.esa.snap.pixex.output.RasterNamesFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PixExMeasurementFactoryTest {
    private Product product;
    private RasterNamesFactory rasterNamesFactory;
    private Band band1;
    private Band band2;
    private ProductRegistry productRegistry;

    @Before
    public void setUp() throws Exception {
        this.product = new Product("name", "type", 10, 10);
        this.band1 = this.product.addBand("val1", 11);
        this.fillValues(this.band1, 10);
        this.band2 = this.product.addBand("val2", 30);
        this.fillValues(this.band2, 20);
        this.rasterNamesFactory = this.newRasterNamesFactory();
        this.productRegistry = this.newProductRegistry();
    }

    @Test
    public void testMeasurementCreation() throws IOException {
        int windowSize = 3;
        PixExMeasurementFactory factory = new PixExMeasurementFactory(this.rasterNamesFactory, 3, this.productRegistry);
        int pixelX = 3;
        int pixelY = 4;
        int coordinateID = 2345;
        String cordName = "CordName";
        Measurement[] measurements = factory.createMeasurements(3, 4, 2345, "CordName", this.product, null);
        Assert.assertThat((Object)measurements.length, (Matcher)CoreMatchers.equalTo((Object)9));
        Measurement[] expectedMeasurements = new Measurement[9];
        for (int i = 0; i < expectedMeasurements.length; ++i) {
            expectedMeasurements[i] = this.createExpectedMeasurement(3, 3, 4, 2345, "CordName", i);
        }
        Assert.assertThat((Object)measurements, (Matcher)CoreMatchers.equalTo((Object)expectedMeasurements));
    }

    private Measurement createExpectedMeasurement(int windowSize, int pixelX, int pixelY, int coordinateID, String cordName, int i) throws IOException {
        int windowOffset = windowSize / 2;
        int xOffset = i % windowSize;
        int yOffset = i / windowSize;
        int upperLeftX = pixelX - windowOffset;
        int upperLeftY = pixelY - windowOffset;
        int pixX = upperLeftX + xOffset;
        int pixY = upperLeftY + yOffset;
        Integer intValue = this.band1.getPixelInt(pixX, pixY);
        Double floatValue = this.band2.getPixelDouble(pixX, pixY);
        Object[] values = new Number[]{intValue, floatValue};
        long productId = this.productRegistry.getProductId(this.product);
        return new Measurement(coordinateID, cordName, productId, (double)(0.5f + (float)pixX), (double)(0.5f + (float)pixY), null, new GeoPos(), values, true);
    }

    private ProductRegistry newProductRegistry() {
        return new ProductRegistry(){

            public long getProductId(Product product) {
                return 1234L;
            }

            public void close() {
            }
        };
    }

    private RasterNamesFactory newRasterNamesFactory() {
        return new RasterNamesFactory(){

            public String[] getRasterNames(Product product) {
                return product.getBandNames();
            }

            public String[] getUniqueRasterNames(Product product) {
                return this.getRasterNames(product);
            }
        };
    }

    private void fillValues(Band band, int offset) {
        ProductData data = band.createCompatibleRasterData();
        int numElems = data.getNumElems();
        for (int i = 0; i < numElems; ++i) {
            data.setElemDoubleAt(i, 0.5 + (double)i + (double)offset);
        }
        band.setData(data);
    }
}

