/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.beam;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.dataio.netcdf.ProfileReadContext;
import org.esa.snap.dataio.netcdf.ProfileWriteContext;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartIO;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfBandPart;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;

public class BeamTiePointGridPart
extends ProfilePartIO {
    public final String OFFSET_X = "offset_x";
    public final String OFFSET_Y = "offset_y";
    public final String SUBSAMPLING_X = "subsampling_x";
    public final String SUBSAMPLING_Y = "subsampling_y";

    @Override
    public void decode(ProfileReadContext ctx, Product p) throws IOException {
        List variables = ctx.getNetcdfFile().getVariables();
        for (Variable variable : variables) {
            String tpName;
            List dimensions = variable.getDimensions();
            if (dimensions.size() != 2) continue;
            Dimension dimensionY = (Dimension)dimensions.get(0);
            Dimension dimensionX = (Dimension)dimensions.get(1);
            if (dimensionY.getLength() == p.getSceneRasterHeight() && dimensionX.getLength() == p.getSceneRasterWidth() || p.containsBand(tpName = ReaderUtils.getRasterName(variable))) continue;
            Attribute offsetX = variable.findAttributeIgnoreCase("offset_x");
            Attribute offsetY = variable.findAttributeIgnoreCase("offset_y");
            Attribute subSamplingX = variable.findAttributeIgnoreCase("subsampling_x");
            Attribute subSamplingY = variable.findAttributeIgnoreCase("subsampling_y");
            if (offsetX == null || offsetY == null || subSamplingX == null || subSamplingY == null) continue;
            Array array = variable.read();
            float[] data = new float[(int)array.getSize()];
            for (int i = 0; i < data.length; ++i) {
                data[i] = array.getFloat(i);
            }
            boolean containsAngles = "lon".equalsIgnoreCase(tpName) || "lat".equalsIgnoreCase(tpName) || "longitude".equalsIgnoreCase(tpName) || "latitude".equalsIgnoreCase(tpName);
            TiePointGrid grid = new TiePointGrid(tpName, dimensionX.getLength(), dimensionY.getLength(), (double)offsetX.getNumericValue().floatValue(), (double)offsetY.getNumericValue().floatValue(), (double)subSamplingX.getNumericValue().floatValue(), (double)subSamplingY.getNumericValue().floatValue(), data, containsAngles);
            CfBandPart.readCfBandAttributes(variable, (RasterDataNode)grid);
            p.addTiePointGrid(grid);
        }
    }

    @Override
    public void preEncode(ProfileWriteContext ctx, Product p) throws IOException {
        HashMap<String, String> dimMap = new HashMap<String, String>();
        NFileWriteable ncFile = ctx.getNetcdfFileWriteable();
        for (TiePointGrid tiePointGrid : p.getTiePointGrids()) {
            String key = "" + tiePointGrid.getGridHeight() + " " + tiePointGrid.getGridWidth();
            String dimString = (String)dimMap.get(key);
            if (dimString == null) {
                int size = dimMap.size();
                String suffix = size > 0 ? "" + (size + 1) : "";
                ncFile.addDimension("tp_y" + suffix, tiePointGrid.getGridHeight());
                ncFile.addDimension("tp_x" + suffix, tiePointGrid.getGridWidth());
                dimString = "tp_y" + suffix + " tp_x" + suffix;
                dimMap.put(key, dimString);
            }
            String variableName = ReaderUtils.getVariableName((RasterDataNode)tiePointGrid);
            NVariable variable = ncFile.addVariable(variableName, DataType.FLOAT, null, dimString);
            variable.addAttribute("offset_x", tiePointGrid.getOffsetX());
            variable.addAttribute("offset_y", tiePointGrid.getOffsetY());
            variable.addAttribute("subsampling_x", tiePointGrid.getSubSamplingX());
            variable.addAttribute("subsampling_y", tiePointGrid.getSubSamplingY());
        }
    }

    @Override
    public void encode(ProfileWriteContext ctx, Product p) throws IOException {
        for (TiePointGrid tiePointGrid : p.getTiePointGrids()) {
            int y = tiePointGrid.getGridHeight();
            int x = tiePointGrid.getGridWidth();
            int[] shape = new int[]{y, x};
            Array values = Array.factory((DataType)DataType.FLOAT, (int[])shape, (Object)tiePointGrid.getDataElems());
            String variableName = ReaderUtils.getVariableName((RasterDataNode)tiePointGrid);
            ctx.getNetcdfFileWriteable().findVariable(variableName).writeFully(values);
        }
    }
}

