/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.util;

import org.esa.snap.dataio.netcdf.util.DimKey;
import org.junit.Assert;
import org.junit.Test;
import ucar.nc2.Dimension;

public class DimKeyTest {
    @Test
    public void testEqualsAndHashCode() throws Exception {
        DimKey dimKey1 = new DimKey(new Dimension[]{new Dimension("y", 256), new Dimension("x", 512)});
        DimKey dimKey2 = new DimKey(new Dimension[]{new Dimension("y", 256), new Dimension("x", 512)});
        Assert.assertTrue((boolean)dimKey1.equals((Object)dimKey2));
        Assert.assertTrue((boolean)dimKey2.equals((Object)dimKey1));
        Assert.assertTrue((dimKey1.hashCode() == dimKey2.hashCode() ? 1 : 0) != 0);
        dimKey2 = new DimKey(new Dimension[]{new Dimension("t", 12), new Dimension("y", 256), new Dimension("x", 512)});
        Assert.assertTrue((boolean)dimKey1.equals((Object)dimKey2));
        Assert.assertTrue((boolean)dimKey2.equals((Object)dimKey1));
        Assert.assertTrue((dimKey1.hashCode() == dimKey2.hashCode() ? 1 : 0) != 0);
        dimKey2 = new DimKey(new Dimension[]{new Dimension("t", 12), new Dimension("y", 256), new Dimension("x", 256)});
        Assert.assertFalse((boolean)dimKey1.equals((Object)dimKey2));
        Assert.assertFalse((boolean)dimKey2.equals((Object)dimKey1));
        Assert.assertFalse((dimKey1.hashCode() == dimKey2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testGetDimensionX() throws Exception {
        Dimension yDim = new Dimension("y", 256);
        Dimension xDim = new Dimension("x", 512);
        Assert.assertSame((Object)xDim, (Object)new DimKey(new Dimension[]{yDim, xDim}).getDimensionX());
    }

    @Test
    public void testGetDimensionsForSynVgtProducts() throws Exception {
        Dimension yDim = new Dimension("NY", 2800);
        Dimension xDim = new Dimension("NX", 4032);
        Dimension vDim = new Dimension("nv", 2);
        DimKey dimKey = new DimKey(new Dimension[]{yDim, xDim, vDim});
        Assert.assertSame((Object)xDim, (Object)dimKey.getDimensionX());
        Assert.assertSame((Object)yDim, (Object)dimKey.getDimensionY());
    }
}

