/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.nc;

import java.awt.Point;
import java.awt.Rectangle;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.netcdf.nc.ChunkWriter;
import org.junit.Assert;
import org.junit.Test;

public class ChunkedWriterTest {
    @Test
    public void testDimensions() throws Exception {
        DummyChunkWriter chunkWriter = new DummyChunkWriter(100, 100, 100, 100, false);
        Assert.assertEquals((long)1L, (long)chunkWriter.getNumChunksX());
        Assert.assertEquals((long)1L, (long)chunkWriter.getNumChunksY());
        chunkWriter = new DummyChunkWriter(100, 100, 50, 50, false);
        Assert.assertEquals((long)2L, (long)chunkWriter.getNumChunksX());
        Assert.assertEquals((long)2L, (long)chunkWriter.getNumChunksY());
        chunkWriter = new DummyChunkWriter(100, 100, 30, 30, false);
        Assert.assertEquals((long)4L, (long)chunkWriter.getNumChunksX());
        Assert.assertEquals((long)4L, (long)chunkWriter.getNumChunksY());
    }

    @Test
    public void testGetChunkX() throws Exception {
        DummyChunkWriter chunkWriter = new DummyChunkWriter(100, 100, 30, 30, false);
        Assert.assertEquals((long)0L, (long)chunkWriter.getChunkX(0));
        Assert.assertEquals((long)0L, (long)chunkWriter.getChunkX(1));
        Assert.assertEquals((long)0L, (long)chunkWriter.getChunkX(29));
        Assert.assertEquals((long)1L, (long)chunkWriter.getChunkX(30));
        Assert.assertEquals((long)1L, (long)chunkWriter.getChunkX(31));
        Assert.assertEquals((long)1L, (long)chunkWriter.getChunkX(59));
        Assert.assertEquals((long)2L, (long)chunkWriter.getChunkX(60));
        Assert.assertEquals((long)2L, (long)chunkWriter.getChunkX(61));
        Assert.assertEquals((long)2L, (long)chunkWriter.getChunkX(89));
        Assert.assertEquals((long)3L, (long)chunkWriter.getChunkX(90));
        Assert.assertEquals((long)3L, (long)chunkWriter.getChunkX(91));
        Assert.assertEquals((long)3L, (long)chunkWriter.getChunkX(99));
    }

    @Test
    public void testGetChunkY() throws Exception {
        DummyChunkWriter chunkWriter = new DummyChunkWriter(100, 100, 30, 40, false);
        Assert.assertEquals((long)0L, (long)chunkWriter.getChunkY(0));
        Assert.assertEquals((long)0L, (long)chunkWriter.getChunkY(1));
        Assert.assertEquals((long)0L, (long)chunkWriter.getChunkY(39));
        Assert.assertEquals((long)1L, (long)chunkWriter.getChunkY(40));
        Assert.assertEquals((long)1L, (long)chunkWriter.getChunkY(41));
        Assert.assertEquals((long)1L, (long)chunkWriter.getChunkY(79));
        Assert.assertEquals((long)2L, (long)chunkWriter.getChunkY(80));
        Assert.assertEquals((long)2L, (long)chunkWriter.getChunkY(81));
        Assert.assertEquals((long)2L, (long)chunkWriter.getChunkY(99));
    }

    @Test
    public void testGetChunkRect() throws Exception {
        DummyChunkWriter chunkWriter = new DummyChunkWriter(60, 50, 30, 40, false);
        Assert.assertEquals((Object)new Rectangle(0, 0, 30, 40), (Object)chunkWriter.getChunkRect(new Point(0, 0)));
        Assert.assertEquals((Object)new Rectangle(30, 0, 30, 40), (Object)chunkWriter.getChunkRect(new Point(1, 0)));
        Assert.assertEquals((Object)new Rectangle(0, 40, 30, 10), (Object)chunkWriter.getChunkRect(new Point(0, 1)));
        Assert.assertEquals((Object)new Rectangle(30, 40, 30, 10), (Object)chunkWriter.getChunkRect(new Point(1, 1)));
    }

    @Test
    public void testGetChunkIndices_OneChunk() throws Exception {
        DummyChunkWriter chunkWriter = new DummyChunkWriter(100, 100, 100, 100, false);
        Point[] chunks = chunkWriter.getChunkIndices(0, 0, 100, 100);
        Assert.assertNotNull((Object)chunks);
        Assert.assertEquals((long)1L, (long)chunks.length);
        Assert.assertEquals((long)0L, (long)chunks[0].x);
        Assert.assertEquals((long)0L, (long)chunks[0].y);
        chunks = chunkWriter.getChunkIndices(10, 10, 10, 10);
        Assert.assertNotNull((Object)chunks);
        Assert.assertEquals((long)1L, (long)chunks.length);
        Assert.assertEquals((long)0L, (long)chunks[0].x);
        Assert.assertEquals((long)0L, (long)chunks[0].y);
    }

    @Test
    public void testGetChunkIndices_FourChunks() throws Exception {
        DummyChunkWriter chunkWriter = new DummyChunkWriter(100, 100, 50, 50, false);
        Point[] chunks = chunkWriter.getChunkIndices(0, 0, 100, 100);
        Assert.assertNotNull((Object)chunks);
        Assert.assertEquals((long)4L, (long)chunks.length);
        Assert.assertEquals((long)0L, (long)chunks[0].x);
        Assert.assertEquals((long)0L, (long)chunks[0].y);
        Assert.assertEquals((long)1L, (long)chunks[1].x);
        Assert.assertEquals((long)0L, (long)chunks[1].y);
        Assert.assertEquals((long)0L, (long)chunks[2].x);
        Assert.assertEquals((long)1L, (long)chunks[2].y);
        Assert.assertEquals((long)1L, (long)chunks[3].x);
        Assert.assertEquals((long)1L, (long)chunks[3].y);
        chunks = chunkWriter.getChunkIndices(10, 10, 10, 10);
        Assert.assertNotNull((Object)chunks);
        Assert.assertEquals((long)1L, (long)chunks.length);
        Assert.assertEquals((long)0L, (long)chunks[0].x);
        Assert.assertEquals((long)0L, (long)chunks[0].y);
        chunks = chunkWriter.getChunkIndices(0, 0, 100, 10);
        Assert.assertNotNull((Object)chunks);
        Assert.assertEquals((long)2L, (long)chunks.length);
        Assert.assertEquals((long)0L, (long)chunks[0].x);
        Assert.assertEquals((long)0L, (long)chunks[0].y);
        Assert.assertEquals((long)1L, (long)chunks[1].x);
        Assert.assertEquals((long)0L, (long)chunks[1].y);
    }

    @Test
    public void testWrite_OneChunk() throws Exception {
        DummyChunkWriter chunkWriter = new DummyChunkWriter(4, 4, 4, 4, false);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][0]);
        chunkWriter.write(0, 0, 1, 1, ProductData.createInstance((int[])new int[]{0}));
        chunkWriter.write(1, 0, 1, 1, ProductData.createInstance((int[])new int[]{1}));
        chunkWriter.write(0, 1, 1, 1, ProductData.createInstance((int[])new int[]{4}));
        chunkWriter.write(1, 1, 1, 1, ProductData.createInstance((int[])new int[]{5}));
        chunkWriter.write(2, 0, 2, 2, ProductData.createInstance((int[])new int[]{2, 3, 6, 7}));
        chunkWriter.write(0, 2, 4, 2, ProductData.createInstance((int[])new int[]{8, 9, 10, 11, 12, 13, 14, 15}));
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][0]);
        int[] expected = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        Assert.assertArrayEquals((int[])expected, (int[])((int[])chunkWriter.writtenChunks[0][0].getElems()));
    }

    @Test
    public void testWrite_OneChunk_YFlipped() throws Exception {
        DummyChunkWriter chunkWriter = new DummyChunkWriter(4, 4, 4, 4, true);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][0]);
        chunkWriter.write(0, 0, 1, 1, ProductData.createInstance((int[])new int[]{0}));
        chunkWriter.write(1, 0, 1, 1, ProductData.createInstance((int[])new int[]{1}));
        chunkWriter.write(0, 1, 1, 1, ProductData.createInstance((int[])new int[]{4}));
        chunkWriter.write(1, 1, 1, 1, ProductData.createInstance((int[])new int[]{5}));
        chunkWriter.write(2, 0, 2, 2, ProductData.createInstance((int[])new int[]{2, 3, 6, 7}));
        chunkWriter.write(0, 2, 4, 2, ProductData.createInstance((int[])new int[]{8, 9, 10, 11, 12, 13, 14, 15}));
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][0]);
        int[] expected = new int[]{12, 13, 14, 15, 8, 9, 10, 11, 4, 5, 6, 7, 0, 1, 2, 3};
        Assert.assertArrayEquals((int[])expected, (int[])((int[])chunkWriter.writtenChunks[0][0].getElems()));
    }

    @Test
    public void testWrite_FourChunk_AllAtOnce() throws Exception {
        DummyChunkWriter chunkWriter = new DummyChunkWriter(4, 4, 2, 2, false);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][1]);
        int[] data = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        chunkWriter.write(0, 0, 4, 4, ProductData.createInstance((int[])data));
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][1]);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 4, 5}, (int[])((int[])chunkWriter.writtenChunks[0][0].getElems()));
        Assert.assertArrayEquals((int[])new int[]{2, 3, 6, 7}, (int[])((int[])chunkWriter.writtenChunks[1][0].getElems()));
        Assert.assertArrayEquals((int[])new int[]{8, 9, 12, 13}, (int[])((int[])chunkWriter.writtenChunks[0][1].getElems()));
        Assert.assertArrayEquals((int[])new int[]{10, 11, 14, 15}, (int[])((int[])chunkWriter.writtenChunks[1][1].getElems()));
    }

    @Test
    public void testWrite_FourChunk_FittingWrites() throws Exception {
        DummyChunkWriter chunkWriter = new DummyChunkWriter(4, 4, 2, 2, false);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][1]);
        chunkWriter.write(0, 0, 2, 2, ProductData.createInstance((int[])new int[]{0, 1, 4, 5}));
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][1]);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 4, 5}, (int[])((int[])chunkWriter.writtenChunks[0][0].getElems()));
        chunkWriter.write(2, 0, 2, 2, ProductData.createInstance((int[])new int[]{2, 3, 6, 7}));
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][1]);
        Assert.assertArrayEquals((int[])new int[]{2, 3, 6, 7}, (int[])((int[])chunkWriter.writtenChunks[1][0].getElems()));
        chunkWriter.write(0, 2, 2, 2, ProductData.createInstance((int[])new int[]{8, 9, 12, 13}));
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][1]);
        Assert.assertArrayEquals((int[])new int[]{8, 9, 12, 13}, (int[])((int[])chunkWriter.writtenChunks[0][1].getElems()));
        chunkWriter.write(2, 2, 2, 2, ProductData.createInstance((int[])new int[]{10, 11, 14, 15}));
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][1]);
        Assert.assertArrayEquals((int[])new int[]{10, 11, 14, 15}, (int[])((int[])chunkWriter.writtenChunks[1][1].getElems()));
    }

    @Test
    public void testWrite_FourChunk_FittingWrites_YFlipped() throws Exception {
        DummyChunkWriter chunkWriter = new DummyChunkWriter(4, 4, 2, 2, true);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][1]);
        chunkWriter.write(0, 0, 2, 2, ProductData.createInstance((int[])new int[]{0, 1, 4, 5}));
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][1]);
        Assert.assertArrayEquals((int[])new int[]{4, 5, 0, 1}, (int[])((int[])chunkWriter.writtenChunks[0][1].getElems()));
        chunkWriter.write(2, 0, 2, 2, ProductData.createInstance((int[])new int[]{2, 3, 6, 7}));
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][1]);
        Assert.assertArrayEquals((int[])new int[]{6, 7, 2, 3}, (int[])((int[])chunkWriter.writtenChunks[1][1].getElems()));
        chunkWriter.write(0, 2, 2, 2, ProductData.createInstance((int[])new int[]{8, 9, 12, 13}));
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][1]);
        Assert.assertArrayEquals((int[])new int[]{12, 13, 8, 9}, (int[])((int[])chunkWriter.writtenChunks[0][0].getElems()));
        chunkWriter.write(2, 2, 2, 2, ProductData.createInstance((int[])new int[]{10, 11, 14, 15}));
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][1]);
        Assert.assertArrayEquals((int[])new int[]{14, 15, 10, 11}, (int[])((int[])chunkWriter.writtenChunks[1][0].getElems()));
    }

    @Test
    public void testWrite_FourChunk_LineOriented() throws Exception {
        DummyChunkWriter chunkWriter = new DummyChunkWriter(4, 4, 2, 2, false);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][1]);
        chunkWriter.write(0, 0, 4, 1, ProductData.createInstance((int[])new int[]{0, 1, 2, 3}));
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][1]);
        chunkWriter.write(0, 1, 4, 1, ProductData.createInstance((int[])new int[]{4, 5, 6, 7}));
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][1]);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 4, 5}, (int[])((int[])chunkWriter.writtenChunks[0][0].getElems()));
        Assert.assertArrayEquals((int[])new int[]{2, 3, 6, 7}, (int[])((int[])chunkWriter.writtenChunks[1][0].getElems()));
        chunkWriter.write(0, 2, 4, 1, ProductData.createInstance((int[])new int[]{8, 9, 10, 11}));
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][1]);
        chunkWriter.write(0, 3, 4, 1, ProductData.createInstance((int[])new int[]{12, 13, 14, 15}));
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][1]);
        Assert.assertArrayEquals((int[])new int[]{8, 9, 12, 13}, (int[])((int[])chunkWriter.writtenChunks[0][1].getElems()));
        Assert.assertArrayEquals((int[])new int[]{10, 11, 14, 15}, (int[])((int[])chunkWriter.writtenChunks[1][1].getElems()));
    }

    @Test
    public void testWrite_FourChunk_LineOriented_YFlipped() throws Exception {
        DummyChunkWriter chunkWriter = new DummyChunkWriter(4, 4, 2, 2, true);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][1]);
        chunkWriter.write(0, 0, 4, 1, ProductData.createInstance((int[])new int[]{0, 1, 2, 3}));
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][1]);
        chunkWriter.write(0, 1, 4, 1, ProductData.createInstance((int[])new int[]{4, 5, 6, 7}));
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][1]);
        Assert.assertArrayEquals((int[])new int[]{4, 5, 0, 1}, (int[])((int[])chunkWriter.writtenChunks[0][1].getElems()));
        Assert.assertArrayEquals((int[])new int[]{6, 7, 2, 3}, (int[])((int[])chunkWriter.writtenChunks[1][1].getElems()));
        chunkWriter.write(0, 2, 4, 1, ProductData.createInstance((int[])new int[]{8, 9, 10, 11}));
        Assert.assertNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][1]);
        chunkWriter.write(0, 3, 4, 1, ProductData.createInstance((int[])new int[]{12, 13, 14, 15}));
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][0]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[0][1]);
        Assert.assertNotNull((Object)chunkWriter.writtenChunks[1][1]);
        Assert.assertArrayEquals((int[])new int[]{12, 13, 8, 9}, (int[])((int[])chunkWriter.writtenChunks[0][0].getElems()));
        Assert.assertArrayEquals((int[])new int[]{14, 15, 10, 11}, (int[])((int[])chunkWriter.writtenChunks[1][0].getElems()));
    }

    private class DummyChunkWriter
    extends ChunkWriter {
        private final ProductData[][] writtenChunks;

        public DummyChunkWriter(int sceneWidth, int sceneHeight, int chunkWidth, int chunkHeight, boolean isYFlipped) {
            super(sceneWidth, sceneHeight, chunkWidth, chunkHeight, isYFlipped);
            this.writtenChunks = new ProductData[chunkWidth][chunkHeight];
        }

        public void writeChunk(Rectangle rect, ProductData data) {
            this.writtenChunks[this.getChunkX((int)rect.x)][this.getChunkY((int)rect.y)] = data;
        }
    }
}

