/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfHdfEosGeoInfoExtractor;
import ucar.nc2.Attribute;

public class CfHdfGeoInfoExtractorTest
extends TestCase {
    public void testExtractGeoInfo() throws Exception {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        String attrString = "projeCTIon=GCTP_SNSOID\n\txdim=1200\n\t\tyDiM=2400\n\t\tupperleFT=(1.23,45.6)\n\t\tLOWERRIGHT=(78.9,10.34)\n\t\t";
        attributes.add(new Attribute("dummy", "bla"));
        attributes.add(new Attribute("StructMetadata.0", "projeCTIon=GCTP_SNSOID\n\txdim=1200\n\t\tyDiM=2400\n\t\tupperleFT=(1.23,45.6)\n\t\tLOWERRIGHT=(78.9,10.34)\n\t\t"));
        attributes.add(new Attribute("bla", "blubb"));
        CfHdfEosGeoInfoExtractor cfHdfEosGeoInfoExtractor = new CfHdfEosGeoInfoExtractor(attributes);
        cfHdfEosGeoInfoExtractor.extractInfo();
        CfHdfGeoInfoExtractorTest.assertNotNull((Object)cfHdfEosGeoInfoExtractor.getProjection());
        CfHdfGeoInfoExtractorTest.assertEquals((String)"GCTP_SNSOID", (String)cfHdfEosGeoInfoExtractor.getProjection());
        CfHdfGeoInfoExtractorTest.assertEquals((int)1200, (int)cfHdfEosGeoInfoExtractor.getxDim());
        CfHdfGeoInfoExtractorTest.assertEquals((int)2400, (int)cfHdfEosGeoInfoExtractor.getyDim());
        CfHdfGeoInfoExtractorTest.assertEquals((Object)1.23, (Object)cfHdfEosGeoInfoExtractor.getUlLon());
        CfHdfGeoInfoExtractorTest.assertEquals((Object)45.6, (Object)cfHdfEosGeoInfoExtractor.getUlLat());
        CfHdfGeoInfoExtractorTest.assertEquals((Object)78.9, (Object)cfHdfEosGeoInfoExtractor.getLrLon());
        CfHdfGeoInfoExtractorTest.assertEquals((Object)10.34, (Object)cfHdfEosGeoInfoExtractor.getLrLat());
    }
}

