/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.cf;

import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfBandPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfFlagCodingPart;
import org.esa.snap.dataio.netcdf.nc.N3FileWriteable;
import org.esa.snap.dataio.netcdf.nc.N3Variable;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class CfFlagCodingPartTest
extends TestCase {
    public void testReplaceNonWordCharacters() {
        CfFlagCodingPartTest.assertEquals((String)"a_b", (String)CfFlagCodingPart.replaceNonWordCharacters((String)"a/b"));
        CfFlagCodingPartTest.assertEquals((String)"a_b", (String)CfFlagCodingPart.replaceNonWordCharacters((String)"a / b"));
        CfFlagCodingPartTest.assertEquals((String)"a_b", (String)CfFlagCodingPart.replaceNonWordCharacters((String)"a.b"));
    }

    public void testWriteFlagCoding() throws Exception {
        Band flagBand = new Band("flag_band", 20, 10, 10);
        FlagCoding flagCoding = new FlagCoding("some_flags");
        flagBand.setSampleCoding((SampleCoding)flagCoding);
        flagCoding.setDescription("A Flag Coding");
        for (int i = 0; i < 8; ++i) {
            this.addFlag(flagCoding, i);
        }
        NetcdfFileWriteable writeable = NetcdfFileWriteable.createNew((String)"not stored");
        writeable.addDimension("y", flagBand.getRasterHeight());
        writeable.addDimension("x", flagBand.getRasterWidth());
        DataType ncDataType = DataTypeUtils.getNetcdfDataType((int)flagBand.getDataType());
        Variable variable = writeable.addVariable(flagBand.getName(), ncDataType, writeable.getRootGroup().getDimensions());
        CfBandPart.writeCfBandAttributes((RasterDataNode)flagBand, (NVariable)new N3Variable(variable, writeable));
        CfFlagCodingPart.writeFlagCoding((Band)flagBand, (NFileWriteable)new N3FileWriteable(writeable));
        Variable someFlagsVariable = writeable.findVariable("flag_band");
        CfFlagCodingPartTest.assertNotNull((Object)someFlagsVariable);
        Attribute flagMasksAttrib = someFlagsVariable.findAttribute("flag_masks");
        CfFlagCodingPartTest.assertNotNull((Object)flagMasksAttrib);
        CfFlagCodingPartTest.assertEquals((Object)someFlagsVariable.getDataType(), (Object)flagMasksAttrib.getDataType());
        CfFlagCodingPartTest.assertEquals((int)8, (int)flagMasksAttrib.getLength());
        CfFlagCodingPartTest.assertTrue((boolean)flagMasksAttrib.isUnsigned());
        for (int i = 0; i < 8; ++i) {
            CfFlagCodingPartTest.assertEquals((int)(1 << i), (int)flagMasksAttrib.getValues().getInt(i));
        }
        Attribute descriptionAttrib = someFlagsVariable.findAttribute("long_name");
        CfFlagCodingPartTest.assertNotNull((String)flagCoding.getDescription(), (Object)descriptionAttrib.getStringValue());
    }

    private void addFlag(FlagCoding flagCoding, int index) {
        MetadataAttribute attribute = new MetadataAttribute(String.format("%d_FLAG", index + 1), 20);
        int maskValue = 1 << index;
        attribute.getData().setElemInt(maskValue);
        flagCoding.addAttribute(attribute);
    }
}

