/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf;

import java.util.ArrayList;
import java.util.List;
import org.esa.snap.dataio.netcdf.util.ReaderUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import ucar.nc2.Variable;

public class Nc4ReaderUtils_getVariablesTest {
    private ArrayList<Variable> variables;

    @Before
    public void before() throws Exception {
        this.variables = new ArrayList();
        Variable v1 = (Variable)Mockito.mock(Variable.class);
        Mockito.when((Object)v1.getFullName()).thenReturn((Object)"waswei\u00dfich");
        this.variables.add(v1);
        Variable v2 = (Variable)Mockito.mock(Variable.class);
        Mockito.when((Object)v2.getFullName()).thenReturn((Object)"ade");
        this.variables.add(v2);
        Variable v3 = (Variable)Mockito.mock(Variable.class);
        Mockito.when((Object)v3.getFullName()).thenReturn((Object)"welcome");
        this.variables.add(v3);
    }

    @Test
    public void testOK_ContainsAllVariables() {
        String[] names = new String[]{"ade", "welcome"};
        Variable[] result = ReaderUtils.getVariables(this.variables, (String[])names);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertSame((Object)this.variables.get(1), (Object)result[0]);
        Assert.assertSame((Object)this.variables.get(2), (Object)result[1]);
    }

    @Test
    public void testOK_ContainsAllVariables_ReverseNames() {
        String[] names = new String[]{"welcome", "ade"};
        Variable[] result = ReaderUtils.getVariables(this.variables, (String[])names);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertSame((Object)this.variables.get(2), (Object)result[0]);
        Assert.assertSame((Object)this.variables.get(1), (Object)result[1]);
    }

    @Test
    public void testNotAllVariables() {
        String[] names = new String[]{"ade", "lsmf"};
        Variable[] result = ReaderUtils.getVariables(this.variables, (String[])names);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testListIsNull() {
        String[] names = new String[]{"a", "b"};
        List variables = null;
        Variable[] result = ReaderUtils.getVariables(variables, (String[])names);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testNamesAreNull() {
        String[] names = null;
        Variable[] result = ReaderUtils.getVariables(this.variables, names);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testListIsSmallerThanNames() {
        String[] names = new String[]{"ade", "welcome", "wasWei\u00dfIch", "undNochEins"};
        Variable[] result = ReaderUtils.getVariables(this.variables, (String[])names);
        Assert.assertNull((Object)result);
    }
}

