/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Calendar;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfNetCdfReaderPlugIn;
import org.esa.snap.runtime.Config;
import org.junit.Assert;
import org.junit.Test;

public class Nc4ReaderTest {
    @Test
    public void testGlobalAttributes() throws IOException {
        URL url = Nc4ReaderTest.class.getResource("test.nc");
        Assert.assertNotNull((Object)url);
        Assert.assertEquals((Object)"file", (Object)url.getProtocol());
        String path = URLDecoder.decode(url.getPath(), "UTF-8");
        Assert.assertTrue((boolean)path.endsWith("test.nc"));
        File file = new File(path);
        Assert.assertEquals((Object)file.getName(), (Object)"test.nc");
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((boolean)file.canRead());
        ProductReader reader = new CfNetCdfReaderPlugIn().createReaderInstance();
        Product product = reader.readProductNodes((Object)file.getPath(), null);
        Assert.assertNotNull((Object)product);
        this.testStartTime(product);
        this.testEndTime(product);
    }

    @Test
    public void testVariableAttributes() throws Exception {
        URL url = Nc4ReaderTest.class.getResource("test.nc");
        String path = URLDecoder.decode(url.getPath(), "UTF-8");
        File file = new File(path);
        ProductReader reader = new CfNetCdfReaderPlugIn().createReaderInstance();
        Product defaultProduct = reader.readProductNodes((Object)file.getPath(), null);
        MetadataElement defaultLonElement = defaultProduct.getMetadataRoot().getElement("Variable_Attributes").getElement("lon");
        MetadataAttribute defaultLonValues = defaultLonElement.getElement("Values").getAttribute("data");
        long defaultLonValueCount = defaultLonValues.getNumDataElems();
        Assert.assertEquals((long)5L, (long)defaultLonValueCount);
        Config.instance().preferences().putInt("snap.dataio.netcdf.metadataElementLimit", 3);
        Product constrainedProduct = reader.readProductNodes((Object)file.getPath(), null);
        MetadataElement constrainedLonElement = constrainedProduct.getMetadataRoot().getElement("Variable_Attributes").getElement("lon");
        MetadataAttribute constrainedLonValues = constrainedLonElement.getElement("Values").getAttribute("data");
        long constrainedLonValueCount = constrainedLonValues.getNumDataElems();
        Assert.assertEquals((long)3L, (long)constrainedLonValueCount);
        Config.instance().preferences().putInt("snap.dataio.netcdf.metadataElementLimit", -1);
        Product unconstrainedProduct = reader.readProductNodes((Object)file.getPath(), null);
        MetadataElement unconstrainedLonElement = unconstrainedProduct.getMetadataRoot().getElement("Variable_Attributes").getElement("lon");
        MetadataAttribute unconstrainedLonValues = unconstrainedLonElement.getElement("Values").getAttribute("data");
        long unconstrainedLonValueCount = unconstrainedLonValues.getNumDataElems();
        Assert.assertEquals((long)5L, (long)unconstrainedLonValueCount);
    }

    private void testStartTime(Product product) {
        ProductData.UTC utc = product.getStartTime();
        Assert.assertNotNull((Object)utc);
        Calendar startTime = utc.getAsCalendar();
        Assert.assertEquals((long)2002L, (long)startTime.get(1));
        Assert.assertEquals((long)11L, (long)startTime.get(2));
        Assert.assertEquals((long)24L, (long)startTime.get(5));
        Assert.assertEquals((long)11L, (long)startTime.get(11));
        Assert.assertEquals((long)12L, (long)startTime.get(12));
        Assert.assertEquals((long)13L, (long)startTime.get(13));
    }

    private void testEndTime(Product product) {
        ProductData.UTC utc = product.getEndTime();
        Assert.assertNotNull((Object)utc);
        Calendar endTime = utc.getAsCalendar();
        Assert.assertEquals((long)2002L, (long)endTime.get(1));
        Assert.assertEquals((long)11L, (long)endTime.get(2));
        Assert.assertEquals((long)24L, (long)endTime.get(5));
        Assert.assertEquals((long)11L, (long)endTime.get(11));
        Assert.assertEquals((long)12L, (long)endTime.get(12));
        Assert.assertEquals((long)14L, (long)endTime.get(13));
    }
}

