/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.nc;

import java.io.IOException;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.netcdf.nc.NVariable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class N3Variable
implements NVariable {
    private final Variable variable;
    private final NetcdfFileWriteable netcdfFileWriteable;

    public N3Variable(Variable variable, NetcdfFileWriteable netcdfFileWriteable) {
        this.variable = variable;
        this.netcdfFileWriteable = netcdfFileWriteable;
    }

    @Override
    public String getName() {
        return this.variable.getFullName();
    }

    @Override
    public DataType getDataType() {
        return this.variable.getDataType();
    }

    @Override
    public void addAttribute(String name, String value) {
        this.variable.addAttribute(new Attribute(name, value));
    }

    @Override
    public void addAttribute(String name, Number value) {
        this.variable.addAttribute(new Attribute(name, value));
    }

    @Override
    public void addAttribute(String name, Number value, boolean isUnsigned) {
        Attribute attribute = new Attribute(name, value);
        this.variable.addAttribute(attribute);
    }

    @Override
    public void addAttribute(String name, Array value) {
        this.variable.addAttribute(new Attribute(name, value));
    }

    @Override
    public void writeFully(Array values) throws IOException {
        try {
            this.netcdfFileWriteable.write(this.variable.getFullName(), values);
        }
        catch (InvalidRangeException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(int x, int y, int width, int height, boolean isYFlipped, ProductData data) throws IOException {
        String variableName = this.variable.getFullName();
        boolean yIndex = false;
        boolean xIndex = true;
        DataType dataType = this.variable.getDataType();
        int sceneHeight = this.variable.getDimension(0).getLength();
        int[] writeOrigin = new int[2];
        writeOrigin[1] = x;
        int[] sourceShape = new int[]{height, width};
        Array sourceArray = Array.factory((DataType)dataType, (int[])sourceShape, (Object)data.getElems());
        int[] sourceOrigin = new int[2];
        sourceOrigin[1] = 0;
        int[] writeShape = new int[]{1, width};
        for (int line = y; line < y + height; ++line) {
            writeOrigin[0] = isYFlipped ? sceneHeight - 1 - line : line;
            sourceOrigin[0] = line - y;
            try {
                Array dataArrayLine = sourceArray.sectionNoReduce(sourceOrigin, writeShape, null);
                this.netcdfFileWriteable.write(variableName, writeOrigin, dataArrayLine);
                continue;
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IOException("Unable to encode netCDF data.", e);
            }
        }
    }
}

