/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.util;

import org.esa.snap.dataio.netcdf.util.DataTypeUtils;
import org.junit.Assert;
import org.junit.Test;
import ucar.ma2.DataType;

public class DataTypeUtilsTest {
    @Test
    public void testConvertToBYTE() {
        Number convertedNumber = DataTypeUtils.convertTo((double)12.3, (DataType)DataType.BYTE);
        Assert.assertEquals((Object)12, (Object)convertedNumber);
        Assert.assertEquals((Object)DataType.BYTE, (Object)DataType.getType(convertedNumber.getClass()));
        convertedNumber = DataTypeUtils.convertTo((double)-123.0, (DataType)DataType.BYTE);
        Assert.assertEquals((Object)-123, (Object)convertedNumber);
        Assert.assertEquals((Object)DataType.BYTE, (Object)DataType.getType(convertedNumber.getClass()));
    }

    @Test
    public void testConvertToSHORT() {
        Number convertedNumber = DataTypeUtils.convertTo((double)12.3, (DataType)DataType.SHORT);
        Assert.assertEquals((Object)DataType.SHORT, (Object)DataType.getType(convertedNumber.getClass()));
        Assert.assertEquals((Object)12, (Object)convertedNumber);
        convertedNumber = DataTypeUtils.convertTo((double)-123.0, (DataType)DataType.SHORT);
        Assert.assertEquals((Object)DataType.SHORT, (Object)DataType.getType(convertedNumber.getClass()));
        Assert.assertEquals((Object)-123, (Object)convertedNumber);
    }

    @Test
    public void testConvertToINT() {
        Number convertedNumber = DataTypeUtils.convertTo((double)12.3, (DataType)DataType.INT);
        Assert.assertEquals((Object)DataType.INT, (Object)DataType.getType(convertedNumber.getClass()));
        Assert.assertEquals((Object)12, (Object)convertedNumber);
        convertedNumber = DataTypeUtils.convertTo((double)-123.0, (DataType)DataType.INT);
        Assert.assertEquals((Object)DataType.INT, (Object)DataType.getType(convertedNumber.getClass()));
        Assert.assertEquals((Object)-123, (Object)convertedNumber);
    }

    @Test
    public void testConvertToLONG() {
        Number convertedNumber = DataTypeUtils.convertTo((double)12.3, (DataType)DataType.LONG);
        Assert.assertEquals((Object)DataType.LONG, (Object)DataType.getType(convertedNumber.getClass()));
        Assert.assertEquals((Object)12L, (Object)convertedNumber);
        convertedNumber = DataTypeUtils.convertTo((double)-123.0, (DataType)DataType.LONG);
        Assert.assertEquals((Object)DataType.LONG, (Object)DataType.getType(convertedNumber.getClass()));
        Assert.assertEquals((Object)-123L, (Object)convertedNumber);
    }

    @Test
    public void testConvertToFLOAT() {
        Number convertedNumber = DataTypeUtils.convertTo((double)12.3, (DataType)DataType.FLOAT);
        Assert.assertEquals((Object)DataType.FLOAT, (Object)DataType.getType(convertedNumber.getClass()));
        Assert.assertEquals((Object)Float.valueOf(12.3f), (Object)convertedNumber);
        convertedNumber = DataTypeUtils.convertTo((double)-123.0, (DataType)DataType.FLOAT);
        Assert.assertEquals((Object)DataType.FLOAT, (Object)DataType.getType(convertedNumber.getClass()));
        Assert.assertEquals((Object)Float.valueOf(-123.0f), (Object)convertedNumber);
    }

    @Test
    public void testConvertToDOUBLE() {
        Number convertedNumber = DataTypeUtils.convertTo((double)12.3, (DataType)DataType.DOUBLE);
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)DataType.getType(convertedNumber.getClass()));
        Assert.assertEquals((Object)12.3, (Object)convertedNumber);
        convertedNumber = DataTypeUtils.convertTo((double)-123.0, (DataType)DataType.DOUBLE);
        Assert.assertEquals((Object)DataType.DOUBLE, (Object)DataType.getType(convertedNumber.getClass()));
        Assert.assertEquals((Object)-123.0, (Object)convertedNumber);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertToWithIllegalArgument() {
        DataTypeUtils.convertTo((double)12.3, (DataType)DataType.STRING);
    }
}

