/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos;

import org.esa.snap.dataio.netcdf.metadata.profiles.hdfeos.HdfEosGridInfo;
import org.junit.Assert;
import org.junit.Test;

public class HdfEosGridInfoTest {
    private static final double[] PROJ_PARAMS = new double[]{12.3, 4.0, 56.8332, 1234.66, 0.0071, 223.0, 12.009, 12.735, 211.3, 10.0, 1234546.03, 84.9, 234.222224};

    @Test
    public void testGridInfosAreEqual() throws Exception {
        HdfEosGridInfo gridInfo1 = new HdfEosGridInfo("testName", -120.0, 50.0, -100.0, 40.0, "Sinusoidal");
        HdfEosGridInfo gridInfo2 = new HdfEosGridInfo("testName", -120.0, 50.0, -100.0, 40.0, "Sinusoidal");
        Assert.assertTrue((boolean)gridInfo1.equalProjections(gridInfo2));
    }

    @Test
    public void testGridInfosWithProjParamsAreEqual() throws Exception {
        HdfEosGridInfo gridInfo1 = new HdfEosGridInfo("testName", -120.0, 50.0, -100.0, 40.0, "Sinusoidal");
        gridInfo1.setProjectionParameter(PROJ_PARAMS);
        HdfEosGridInfo gridInfo2 = new HdfEosGridInfo("testName", -120.0, 50.0, -100.0, 40.0, "Sinusoidal");
        gridInfo2.setProjectionParameter(PROJ_PARAMS);
        Assert.assertTrue((boolean)gridInfo1.equalProjections(gridInfo2));
    }

    @Test
    public void testGridInfosAreNotEqual() throws Exception {
        HdfEosGridInfo gridInfo1 = new HdfEosGridInfo("testName", -120.0, 50.1, -100.0, 40.0, "Sinusoidal");
        HdfEosGridInfo gridInfo2 = new HdfEosGridInfo("testName", -120.0, 50.0, -100.0, 40.0, "Sinusoidal");
        Assert.assertFalse((boolean)gridInfo1.equalProjections(gridInfo2));
    }

    @Test
    public void testGridInfosWithProjParamsAreNotEqual() throws Exception {
        HdfEosGridInfo gridInfo1 = new HdfEosGridInfo("testName", -120.0, 50.0, -100.0, 40.0, "Sinusoidal");
        gridInfo1.setProjectionParameter(PROJ_PARAMS);
        HdfEosGridInfo gridInfo2 = new HdfEosGridInfo("testName", -120.0, 50.0, -100.0, 40.0, "Sinusoidal");
        double[] projParams2 = (double[])PROJ_PARAMS.clone();
        projParams2[4] = 42.42;
        gridInfo2.setProjectionParameter(projParams2);
        Assert.assertFalse((boolean)gridInfo1.equalProjections(gridInfo2));
    }

    @Test
    public void testEqualProjectionsWithProjParamsNullParamsAreNotEqual() throws Exception {
        HdfEosGridInfo gridInfo1 = new HdfEosGridInfo("testName", -120.0, 50.0, -100.0, 40.0, "Sinusoidal");
        gridInfo1.setProjectionParameter(PROJ_PARAMS);
        HdfEosGridInfo gridInfo2 = new HdfEosGridInfo("testName", -120.0, 50.0, -100.0, 40.0, "Sinusoidal");
        gridInfo2.setProjectionParameter(null);
        Assert.assertFalse((boolean)gridInfo1.equalProjections(gridInfo2));
    }
}

