/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.beam;

import junit.framework.TestCase;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamImageInfoPart;
import org.mockito.Mockito;
import ucar.nc2.Attribute;

public class BeamImageInfoPartTest
extends TestCase {
    private Attribute a1;
    private Attribute a2;
    private Attribute a3;
    private Attribute a4;

    protected void setUp() throws Exception {
        this.a1 = (Attribute)Mockito.mock(Attribute.class);
        this.a2 = (Attribute)Mockito.mock(Attribute.class);
        this.a3 = (Attribute)Mockito.mock(Attribute.class);
        this.a4 = (Attribute)Mockito.mock(Attribute.class);
    }

    protected void tearDown() throws Exception {
    }

    public void testReturnTrue_AllAttributesHaveTheSameSize() {
        Mockito.when((Object)this.a1.getLength()).thenReturn((Object)4);
        Mockito.when((Object)this.a2.getLength()).thenReturn((Object)4);
        Mockito.when((Object)this.a3.getLength()).thenReturn((Object)4);
        Mockito.when((Object)this.a4.getLength()).thenReturn((Object)4);
        Attribute[] attributes = new Attribute[]{this.a1, this.a2, this.a3, this.a4};
        BeamImageInfoPartTest.assertEquals((boolean)true, (boolean)BeamImageInfoPart.allAttributesAreNotNullAndHaveTheSameSize((Attribute[])attributes));
    }

    public void testReturnFalse_FirstAttributeIsNull() {
        Mockito.when((Object)this.a2.getLength()).thenReturn((Object)4);
        Mockito.when((Object)this.a3.getLength()).thenReturn((Object)4);
        Mockito.when((Object)this.a4.getLength()).thenReturn((Object)4);
        Attribute[] attributes = new Attribute[]{null, this.a2, this.a3, this.a4};
        BeamImageInfoPartTest.assertEquals((boolean)false, (boolean)BeamImageInfoPart.allAttributesAreNotNullAndHaveTheSameSize((Attribute[])attributes));
    }

    public void testReturnFalse_OneOfTheAttributesIsNull() {
        Mockito.when((Object)this.a1.getLength()).thenReturn((Object)4);
        Mockito.when((Object)this.a2.getLength()).thenReturn((Object)4);
        Mockito.when((Object)this.a3.getLength()).thenReturn((Object)4);
        Mockito.when((Object)this.a4.getLength()).thenReturn((Object)4);
        Attribute[] attributes = new Attribute[]{this.a1, this.a2, null, this.a4};
        BeamImageInfoPartTest.assertEquals((boolean)false, (boolean)BeamImageInfoPart.allAttributesAreNotNullAndHaveTheSameSize((Attribute[])attributes));
    }

    public void testReturnFalse_TheAttributesHaveDiffenentSizes() {
        Mockito.when((Object)this.a1.getLength()).thenReturn((Object)4);
        Mockito.when((Object)this.a2.getLength()).thenReturn((Object)4);
        Mockito.when((Object)this.a3.getLength()).thenReturn((Object)3);
        Mockito.when((Object)this.a4.getLength()).thenReturn((Object)4);
        Attribute[] attributes = new Attribute[]{this.a1, this.a2, this.a3, this.a4};
        BeamImageInfoPartTest.assertEquals((boolean)false, (boolean)BeamImageInfoPart.allAttributesAreNotNullAndHaveTheSameSize((Attribute[])attributes));
    }
}

