/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf;

import java.io.File;
import junit.framework.Assert;
import org.esa.snap.dataio.netcdf.DefaultNetCdfReader;
import org.junit.Test;

public class DefaultNetCdfReaderTest {
    @Test
    public void testExtractProductName() {
        File ncFile = new File("MER_FRS_CCL2R_20120225_085936_000001973112_00079_52248_0001.nc");
        Assert.assertEquals((String)"MER_FRS_CCL2R_20120225_085936_000001973112_00079_52248_0001", (String)DefaultNetCdfReader.extractProductName((File)ncFile));
        File ncGzFile = new File("MER_FSG_CCL2W_20060528_074246_000002952048_00078_22176_0001.nc.gz");
        Assert.assertEquals((String)"MER_FSG_CCL2W_20060528_074246_000002952048_00078_22176_0001", (String)DefaultNetCdfReader.extractProductName((File)ncGzFile));
        File ncAtsFile = new File("ATS_NR__2PNPDK20101103_130629_000060673096_00096_45369_7055.nc");
        Assert.assertEquals((String)"ATS_NR__2PNPDK20101103_130629_000060673096_00096_45369_7055", (String)DefaultNetCdfReader.extractProductName((File)ncAtsFile));
        File ncHdfFile = new File("MCD43C1.A2010041.005.2010064142011.hdf");
        Assert.assertEquals((String)"MCD43C1.A2010041.005.2010064142011", (String)DefaultNetCdfReader.extractProductName((File)ncHdfFile));
        File ncOifNc3File = new File("oif_sample.nc3");
        Assert.assertEquals((String)"oif_sample", (String)DefaultNetCdfReader.extractProductName((File)ncOifNc3File));
        File ncOifNc4File = new File("oif_sample.nc4");
        Assert.assertEquals((String)"oif_sample", (String)DefaultNetCdfReader.extractProductName((File)ncOifNc4File));
        File ncOifNc4cFile = new File("oif_sample.nc4c");
        Assert.assertEquals((String)"oif_sample", (String)DefaultNetCdfReader.extractProductName((File)ncOifNc4cFile));
    }
}

