/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.jython;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.esa.snap.jython.PluginActivator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class PluginActivatorTest {
    @BeforeClass
    public static void setUp() throws Exception {
        File file = PluginActivatorTest.getResourceFile("/");
        Assert.assertTrue((boolean)file.isDirectory());
        System.setProperty("snap.jythonExtraPaths", file.getPath());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        System.clearProperty("snap.jythonExtraPaths");
    }

    @Test
    public void testActivator() throws Exception {
        PluginActivator activator = new PluginActivator();
        activator.start();
        List jythonPlugins = activator.getJythonActivators();
        Assert.assertNotNull((Object)jythonPlugins);
        Assert.assertEquals((long)2L, (long)jythonPlugins.size());
        PythonInterpreter interpreter = activator.getJythonInterpreter();
        Assert.assertNotNull((Object)interpreter);
        interpreter.exec("import plugin_1");
        interpreter.exec("import plugin_2");
        PyObject pi1Started = interpreter.eval("plugin_1.started");
        Assert.assertNotNull((Object)pi1Started);
        Assert.assertEquals((Object)"True", (Object)pi1Started.toString());
        PyObject pi1Stopped = interpreter.eval("plugin_1.stopped");
        Assert.assertNotNull((Object)pi1Stopped);
        Assert.assertEquals((Object)"False", (Object)pi1Stopped.toString());
        PyObject pi2Started = interpreter.eval("plugin_2.started");
        Assert.assertNotNull((Object)pi2Started);
        Assert.assertEquals((Object)"True", (Object)pi2Started.toString());
        PyObject pi2Stopped = interpreter.eval("plugin_2.stopped");
        Assert.assertNotNull((Object)pi2Stopped);
        Assert.assertEquals((Object)"False", (Object)pi2Stopped.toString());
        PyObject pi2Var = interpreter.eval("plugin_2.var");
        Assert.assertNotNull((Object)pi2Var);
        Assert.assertEquals((Object)"42", (Object)pi2Var.toString());
        activator.stop();
        Assert.assertEquals((Object)"True", (Object)interpreter.eval("plugin_1.started").toString());
        Assert.assertEquals((Object)"True", (Object)interpreter.eval("plugin_1.started").toString());
        Assert.assertEquals((Object)"True", (Object)interpreter.eval("plugin_2.stopped").toString());
        Assert.assertEquals((Object)"True", (Object)interpreter.eval("plugin_2.stopped").toString());
    }

    public static File getResourceFile(String name) {
        URL resource = PluginActivatorTest.class.getResource(name);
        Assert.assertNotNull((String)("missing resource '" + name + "'"), (Object)resource);
        return new File(URI.create(resource.toString()));
    }
}

