/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.rcp.dialogs.support;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.esa.snap.engine_utilities.util.ResourceUtils;
import org.esa.snap.graphbuilder.rcp.dialogs.support.GraphDialog;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.UIUtils;

public class GraphsMenu {
    private final Component parentComponent;
    private final GraphDialog graphDialog;
    private final Action loadAction;
    private final Action saveAction;
    private final Action viewGraphXMLAction;

    public GraphsMenu(Component parentComponent, GraphDialog graphDialog) {
        this.parentComponent = parentComponent;
        this.graphDialog = graphDialog;
        this.loadAction = new LoadAction();
        this.saveAction = new SaveAction();
        this.viewGraphXMLAction = new ViewGraphXMLAction();
    }

    public JMenuBar createDefaultMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(this.loadAction);
        fileMenu.add(this.saveAction);
        fileMenu.addSeparator();
        fileMenu.add(this.viewGraphXMLAction);
        JMenu graphMenu = new JMenu("Graphs");
        this.createGraphMenu(graphMenu, ResourceUtils.getGraphFolder((String)"").toFile());
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(graphMenu);
        return menuBar;
    }

    private void createGraphMenu(JMenu menu, File path) {
        File[] filesList = path.listFiles();
        if (filesList == null || filesList.length == 0) {
            return;
        }
        for (final File file : filesList) {
            String name = file.getName();
            if (file.isDirectory() && !file.isHidden() && !name.equalsIgnoreCase("internal")) {
                JMenu subMenu = new JMenu(name);
                menu.add(subMenu);
                this.createGraphMenu(subMenu, file);
                continue;
            }
            if (!name.toLowerCase().endsWith(".xml")) continue;
            JMenuItem item = new JMenuItem(name.substring(0, name.indexOf(".xml")));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphsMenu.this.graphDialog.LoadGraph(file);
                }
            });
            menu.add(item);
        }
    }

    private void showInformationDialog(String title, Component component) {
        ModalDialog modalDialog = new ModalDialog(UIUtils.getRootWindow((Component)this.parentComponent), title, 1, null);
        modalDialog.setContent(component);
        modalDialog.show();
    }

    private class ViewGraphXMLAction
    extends AbstractAction {
        ViewGraphXMLAction() {
            super("View Graph XML");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String xml = "";
            try {
                xml = GraphsMenu.this.graphDialog.getGraphAsString();
            }
            catch (Exception e) {
                xml = "Unable to diaplay graph " + e.toString();
            }
            JTextArea textArea = new JTextArea(xml);
            textArea.setEditable(false);
            JScrollPane textAreaScrollPane = new JScrollPane(textArea);
            textAreaScrollPane.setPreferredSize(new Dimension(360, 360));
            GraphsMenu.this.showInformationDialog("Graph XML", textAreaScrollPane);
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled();
        }
    }

    private class SaveAction
    extends AbstractAction {
        SaveAction() {
            super("Save Graph");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            GraphsMenu.this.graphDialog.SaveGraph();
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && GraphsMenu.this.graphDialog.canSaveGraphs();
        }
    }

    private class LoadAction
    extends AbstractAction {
        LoadAction() {
            super("Load Graph");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            GraphsMenu.this.graphDialog.LoadGraph();
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled();
        }
    }
}

